/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaSyncPopulateProjectTask {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectDataManager myDataManager;

    public IdeaSyncPopulateProjectTask(@NotNull Project project) {
        if (project == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(0);
        }
        this(project, ProjectDataManager.getInstance());
    }

    @VisibleForTesting
    IdeaSyncPopulateProjectTask(@NotNull Project project, @NotNull ProjectDataManager dataManager) {
        if (project == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(1);
        }
        if (dataManager == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDataManager = dataManager;
    }

    @WorkerThread
    public void populateProject(@NotNull DataNode<ProjectData> projectInfo, @Nullable GradleSyncListener syncListener) {
        if (projectInfo == null) {
            IdeaSyncPopulateProjectTask.$$$reportNull$$$0(3);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            GradleSyncMessages.getInstance(this.myProject).removeAllMessages();
        });
        this.myDataManager.importData(projectInfo, this.myProject, true);
        if (syncListener != null) {
            syncListener.syncSucceeded(this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/IdeaSyncPopulateProjectTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "populateProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

