/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.ProxySettingsDialog;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.ProxySettings;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class HttpProxySettingsCleanUp {
    public static void cleanUp(@NotNull Project project) {
        GradleProperties properties2;
        boolean usingProxy;
        if (project == null) {
            HttpProxySettingsCleanUp.$$$reportNull$$$0(0);
        }
        HttpConfigurable ideHttpProxySettings = HttpConfigurable.getInstance();
        boolean bl = usingProxy = ideHttpProxySettings.USE_HTTP_PROXY && StringUtil.isNotEmpty((String)ideHttpProxySettings.PROXY_HOST) || ideHttpProxySettings.USE_PROXY_PAC;
        if (!usingProxy) {
            return;
        }
        try {
            properties2 = new GradleProperties(GradleProperties.getUserGradlePropertiesFile());
        }
        catch (IOException e) {
            Logger.getInstance(HttpProxySettingsCleanUp.class).info("Failed to read gradle.properties file", (Throwable)e);
            return;
        }
        ProxySettings gradleProxySettings = properties2.getHttpProxySettings();
        ProxySettingsDialog dialog2 = null;
        if (ideHttpProxySettings.USE_PROXY_PAC) {
            if (StringUtil.isEmpty((String)gradleProxySettings.getHost()) || !properties2.getProperties().containsKey("systemProp.http.proxyPort")) {
                dialog2 = new ProxySettingsDialog(project, gradleProxySettings);
            }
        } else {
            ProxySettings ideProxySettings = new ProxySettings(ideHttpProxySettings);
            if (!ideProxySettings.equals(gradleProxySettings)) {
                dialog2 = new ProxySettingsDialog(project, ideProxySettings);
            }
        }
        if (dialog2 != null && dialog2.showAndGet()) {
            boolean needsPassword = dialog2.applyProxySettings(properties2.getProperties());
            try {
                properties2.save();
                if (needsPassword) {
                    String msg = "Proxy passwords are not defined.";
                    OpenFileHyperlink openLink = new OpenFileHyperlink(GradleProperties.getUserGradlePropertiesFile().getPath());
                    AndroidNotification.getInstance(project).showBalloon("Proxy Settings", msg, NotificationType.WARNING, openLink);
                }
            }
            catch (IOException e) {
                Throwable root2 = ExceptionUtil.getRootCause((Throwable)e);
                Object cause = root2.getMessage();
                Object errMsg = "Failed to save HTTP proxy settings to gradle.properties file.";
                if (StringUtil.isNotEmpty((String)cause)) {
                    if (!((String)cause).endsWith(".")) {
                        cause = (String)cause + ".";
                    }
                    errMsg = (String)errMsg + String.format("\nCause: %1$s", cause);
                }
                AndroidNotification notification = AndroidNotification.getInstance(project);
                notification.showBalloon("Proxy Settings", (String)errMsg, NotificationType.ERROR);
                Logger.getInstance(HttpProxySettingsCleanUp.class).info("Failed to save changes to gradle.properties file", root2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/HttpProxySettingsCleanUp", "cleanUp"));
    }
}

