/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateKt;
import com.android.tools.idea.gradle.project.sync.ProjectSyncRequest;
import com.android.tools.idea.gradle.project.sync.PsdModuleModels;
import com.android.tools.idea.gradle.project.sync.SelectedVariantCollector;
import com.android.tools.idea.gradle.project.sync.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver;
import com.android.tools.idea.gradle.project.sync.idea.IdeAndroidNativeVariantsModelsWrapper;
import com.android.tools.idea.gradle.project.sync.idea.ProjectResolutionMode;
import com.android.tools.idea.gradle.project.sync.idea.ProjectSetUpTask;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueData;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssues;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;

public class GradleSyncExecutor {
    @NotNull
    private final Project myProject;
    @NotNull
    public static final com.intellij.openapi.util.Key<Boolean> FULL_SYNC_KEY = new com.intellij.openapi.util.Key("android.full.sync");

    public GradleSyncExecutor(@NotNull Project project) {
        if (project == null) {
            GradleSyncExecutor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @WorkerThread
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener2) {
        if (request == null) {
            GradleSyncExecutor.$$$reportNull$$$0(1);
        }
        this.myProject.putUserData(FULL_SYNC_KEY, (Object)request.forceFullVariantsSync);
        Set androidProjectCandidatesPaths = GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().stream().map(ExternalProjectSettings::getExternalProjectPath).collect(Collectors.toSet());
        if (androidProjectCandidatesPaths.isEmpty() && (IdeInfo.getInstance().isAndroidStudio() || ApplicationManager.getApplication().isUnitTestMode())) {
            String foundPath = GradleSyncExecutor.attemptToLinkGradleProject(this.myProject);
            if (foundPath != null) {
                androidProjectCandidatesPaths.add(foundPath);
            } else {
                GradleSyncState.getInstance(this.myProject).syncSkipped(listener2);
                return;
            }
        }
        for (String rootPath : androidProjectCandidatesPaths) {
            ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, listener2);
            ProgressExecutionMode executionMode = request.getProgressExecutionMode();
            ImportSpecBuilder builder2 = new ImportSpecBuilder(this.myProject, GradleUtil.GRADLE_SYSTEM_ID).callback((ExternalProjectRefreshCallback)setUpTask).use(executionMode);
            this.myProject.putUserData(GradleSyncStateKt.PROJECT_SYNC_REQUEST, (Object)new ProjectSyncRequest(rootPath, request.trigger, request.forceFullVariantsSync));
            ExternalSystemUtil.refreshProject((String)rootPath, (ImportSpec)builder2.build());
        }
    }

    @Nullable
    public static String attemptToLinkGradleProject(@NotNull Project project) {
        String projectBasePath;
        if (project == null) {
            GradleSyncExecutor.$$$reportNull$$$0(2);
        }
        if ((projectBasePath = project.getBasePath()) == null) {
            return null;
        }
        String externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)projectBasePath);
        VirtualFile projectRootFolder = project.getBaseDir();
        projectRootFolder.refresh(false, true);
        if (!GradleProjectImportUtil.canOpenGradleProject((VirtualFile)projectRootFolder)) {
            return null;
        }
        GradleProjectSettings projectSettings = new GradleProjectSettings();
        @NotNull GradleVersion gradleVersion2 = projectSettings.resolveGradleVersion();
        @NotNull GradleSettings settings = GradleSettings.getInstance((Project)project);
        GradleProjectImportUtil.setupGradleSettings((GradleSettings)settings);
        GradleProjectImportUtil.setupGradleProjectSettings((GradleProjectSettings)projectSettings, (Project)project, (Path)Paths.get(externalProjectPath, new String[0]));
        GradleJvmResolutionUtil.setupGradleJvm((Project)project, (GradleProjectSettings)projectSettings, (GradleVersion)gradleVersion2);
        GradleSettings.getInstance((Project)project).setStoreProjectFilesExternally(false);
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)projectSettings);
        return externalProjectPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public List<GradleModuleModels> fetchGradleModels() {
        DataNode projectDataNode;
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(this.myProject);
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        this.myProject.putUserData(FULL_SYNC_KEY, (Object)true);
        try {
            GradleProjectResolver projectResolver = new GradleProjectResolver();
            projectDataNode = projectResolver.resolveProjectInfo(id, projectPath, false, (ExternalSystemExecutionSettings)settings, ExternalSystemTaskNotificationListenerAdapter.NULL_OBJECT);
        }
        finally {
            this.myProject.putUserData(FULL_SYNC_KEY, null);
        }
        ImmutableList.Builder builder2 = ImmutableList.builder();
        if (projectDataNode != null) {
            Collection moduleNodes = ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE);
            for (DataNode moduleNode : moduleNodes) {
                DataNode androidModelNode;
                DataNode gradleModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.GRADLE_MODULE_MODEL);
                if (gradleModelNode == null) continue;
                PsdModuleModels moduleModules = new PsdModuleModels(((ModuleData)moduleNode.getData()).getExternalName());
                moduleModules.addModel(GradleModuleModel.class, (GradleModuleModel)gradleModelNode.getData());
                @NotNull Collection syncIssueNodes = ExternalSystemApiUtil.findAll((DataNode)moduleNode, AndroidProjectKeys.SYNC_ISSUE);
                if (!syncIssueNodes.isEmpty()) {
                    moduleModules.addModel(SyncIssues.class, new SyncIssues(ContainerUtil.map((Collection)syncIssueNodes, it -> (SyncIssueData)it.getData())));
                }
                if ((androidModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.ANDROID_MODEL)) != null) {
                    moduleModules.addModel(AndroidModuleModel.class, (AndroidModuleModel)androidModelNode.getData());
                    DataNode ndkModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.NDK_MODEL);
                    if (ndkModelNode != null) {
                        moduleModules.addModel(NdkModuleModel.class, (NdkModuleModel)ndkModelNode.getData());
                    }
                    builder2.add((Object)moduleModules);
                    continue;
                }
                DataNode javaModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.JAVA_MODULE_MODEL);
                if (javaModelNode == null) continue;
                moduleModules.addModel(JavaModuleModel.class, (JavaModuleModel)javaModelNode.getData());
                builder2.add((Object)moduleModules);
            }
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            GradleSyncExecutor.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @WorkerThread
    public void fetchAndMergeNativeVariants(@NotNull @NotNull Set<@NotNull String> requestedAbis) {
        if (requestedAbis == null) {
            GradleSyncExecutor.$$$reportNull$$$0(4);
        }
        SelectedVariantCollector variantCollector = new SelectedVariantCollector(this.myProject);
        SelectedVariants selectedVariants = variantCollector.collectSelectedVariants();
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(this.myProject);
        if (settings == null) {
            throw new IllegalStateException("Cannot obtain GradleExecutionSettings");
        }
        Map<String, String> variantsByNativeModule = selectedVariants.getSelectedVariants().values().stream().filter(it -> it.getAbiName() != null).collect(Collectors.toMap(it -> it.getModuleId(), it -> it.getVariantName()));
        settings.putUserData(AndroidGradleProjectResolver.REQUESTED_PROJECT_RESOLUTION_MODE_KEY, (Object)new ProjectResolutionMode.FetchNativeVariantsMode(variantsByNativeModule, requestedAbis));
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        GradleProjectResolver projectResolver = new GradleProjectResolver();
        GradlePartialResolverPolicy projectResolverPolicy = new GradlePartialResolverPolicy(it -> it instanceof AndroidGradleProjectResolver);
        DataNode projectDataNode = projectResolver.resolveProjectInfo(id, projectPath, false, settings, (ProjectResolverPolicy)projectResolverPolicy, ExternalSystemTaskNotificationListenerAdapter.NULL_OBJECT);
        if (projectDataNode == null) {
            Logger.getInstance(GradleSyncExecutor.class).warn("Failed to retrieve native variant models.");
            return;
        }
        @NotNull Collection nativeVariants = ExternalSystemApiUtil.findAll((DataNode)projectDataNode, AndroidProjectKeys.NATIVE_VARIANTS);
        Map<String, Module> moduleMap = Stream.of(ModuleManager.getInstance((Project)this.myProject).getModules()).filter(it -> ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)it)).collect(Collectors.toMap(it -> ExternalSystemApiUtil.getExternalProjectId((Module)it), it -> it));
        for (DataNode nativeVariantsWrapperNode : nativeVariants) {
            IdeAndroidNativeVariantsModelsWrapper nativeVariantsWrapper = (IdeAndroidNativeVariantsModelsWrapper)nativeVariantsWrapperNode.getData();
            String moduleId = nativeVariantsWrapper.getModuleId();
            Module module2 = moduleMap.get(moduleId);
            if (module2 == null) {
                Logger.getInstance(GradleSyncExecutor.class).error("Module not found. ModuleId: " + moduleId);
                continue;
            }
            NdkFacet ndkFacet = NdkFacet.getInstance(module2);
            if (ndkFacet == null) {
                Logger.getInstance(GradleSyncExecutor.class).error("NdkFacet not found. ModuleId: " + moduleId);
                continue;
            }
            nativeVariantsWrapper.mergeInto(ndkFacet);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/GradleSyncExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedAbis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/GradleSyncExecutor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchGradleModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attemptToLinkGradleProject";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchAndMergeNativeVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

