/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenFileHyperlink
extends NotificationHyperlink {
    @NotNull
    private final String myFilePath;
    private final int myLineNumber;
    private final int myColumn;

    public OpenFileHyperlink(@NotNull String filePath) {
        if (filePath == null) {
            OpenFileHyperlink.$$$reportNull$$$0(0);
        }
        this(filePath, -1);
    }

    public OpenFileHyperlink(@NotNull String filePath, int lineNumber) {
        if (filePath == null) {
            OpenFileHyperlink.$$$reportNull$$$0(1);
        }
        this(filePath, "Open File", lineNumber, -1);
    }

    public OpenFileHyperlink(@NotNull String filePath, @NotNull String text2, int lineNumber, int column) {
        if (filePath == null) {
            OpenFileHyperlink.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            OpenFileHyperlink.$$$reportNull$$$0(3);
        }
        super("openFile:" + filePath, text2);
        this.myFilePath = FileUtil.toSystemIndependentName((String)filePath);
        this.myLineNumber = lineNumber;
        this.myColumn = column;
    }

    @Override
    protected void execute(@NotNull Project project) {
        OpenFileDescriptor openFile;
        VirtualFile projectFile;
        if (project == null) {
            OpenFileHyperlink.$$$reportNull$$$0(4);
        }
        if ((projectFile = project.getProjectFile()) == null) {
            return;
        }
        VirtualFile file2 = projectFile.getParent().getFileSystem().findFileByPath(this.myFilePath);
        if (file2 != null && (openFile = new OpenFileDescriptor(project, file2, this.myLineNumber, this.myColumn, false)).canNavigate()) {
            openFile.navigate(true);
        }
    }

    @VisibleForTesting
    @NotNull
    public String getFilePath() {
        String string = this.myFilePath;
        if (string == null) {
            OpenFileHyperlink.$$$reportNull$$$0(5);
        }
        return string;
    }

    @VisibleForTesting
    public int getLineNumber() {
        return this.myLineNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/hyperlink/OpenFileHyperlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/OpenFileHyperlink";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

