/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.issues.processor.FixNdkVersionProcessor;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNdkHyperlink
extends NotificationHyperlink {
    private static final String ERROR_TITLE = "Gradle Sync Error";
    private final List<VirtualFile> buildFiles;
    private final String searchPrefix;

    public InstallNdkHyperlink(@Nullable String preferredVersion, @NotNull List<VirtualFile> buildFiles) {
        if (buildFiles == null) {
            InstallNdkHyperlink.$$$reportNull$$$0(0);
        }
        super("install.ndk", preferredVersion == null ? "Install latest NDK and sync project" : String.format("Install NDK '%s' and sync project", preferredVersion));
        this.buildFiles = buildFiles;
        this.searchPrefix = preferredVersion == null ? "ndk" : "ndk;" + preferredVersion;
    }

    @Override
    public void execute(@NotNull Project project) {
        if (project == null) {
            InstallNdkHyperlink.$$$reportNull$$$0(1);
        }
        try {
            LocalProperties localProperties = new LocalProperties(project);
            localProperties.setAndroidNdkPath((File)null);
            localProperties.save();
        }
        catch (IOException localProperties) {
            // empty catch block
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)progressIndicator);
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, false, "Loading Remote SDK", project);
        RepoManager.RepoLoadedListener onComplete2 = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            String ndkPath = null;
            Revision ndkRevision = null;
            if (((Boolean)StudioFlags.NDK_SIDE_BY_SIDE_ENABLED.get()).booleanValue()) {
                Collection ndkPackages = packages.getRemotePackagesForPrefix(this.searchPrefix);
                for (RemotePackage ndkPackage : ndkPackages) {
                    if (ndkRevision != null && ndkRevision.compareTo(ndkPackage.getVersion()) >= 0) continue;
                    ndkRevision = ndkPackage.getVersion();
                    ndkPath = ndkPackage.getPath();
                }
            } else {
                Map remotePackages = packages.getRemotePackages();
                RemotePackage ndkPackage = (RemotePackage)remotePackages.get("ndk-bundle");
                if (ndkPackage != null) {
                    ndkPath = ndkPackage.getPath();
                }
            }
            if (ndkPath != null) {
                ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)ndkPath), true);
                if (dialog2 != null && dialog2.showAndGet()) {
                    LocalPackage highestLocalNdk = IdeSdks.getInstance().getHighestLocalNdkPackage(false);
                    if (highestLocalNdk != null) {
                        ApplicationManager.getApplication().invokeLater(() -> new FixNdkVersionProcessor(project, this.buildFiles, highestLocalNdk.getVersion().toString()).run());
                    } else {
                        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_QF_NDK_INSTALLED);
                    }
                }
                return;
            }
            InstallNdkHyperlink.notifyNdkPackageNotFound(project);
        }, ModalityState.any());
        Runnable onError2 = () -> ApplicationManager.getApplication().invokeLater(() -> InstallNdkHyperlink.notifyNdkPackageNotFound(project), ModalityState.any());
        sdkManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete2), (List)ImmutableList.of((Object)onError2), (ProgressRunner)progressRunner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private static void notifyNdkPackageNotFound(@NotNull Project project) {
        if (project == null) {
            InstallNdkHyperlink.$$$reportNull$$$0(2);
        }
        Messages.showErrorDialog((Project)project, (String)"Failed to obtain NDK package", (String)ERROR_TITLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFiles";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/InstallNdkHyperlink";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyNdkPackageNotFound";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

