/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.Revision;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.issues.processor.FixBuildToolsProcessor;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InstallBuildToolsHyperlink
extends NotificationHyperlink {
    @NotNull
    private final String myVersion;
    @NotNull
    private final List<VirtualFile> myBuildFiles;
    private final boolean myRemoveBuildTools;

    public InstallBuildToolsHyperlink(@NotNull String version2) {
        if (version2 == null) {
            InstallBuildToolsHyperlink.$$$reportNull$$$0(0);
        }
        this(version2, (List<VirtualFile>)ImmutableList.of(), false);
    }

    public InstallBuildToolsHyperlink(@NotNull String version2, @NotNull List<VirtualFile> buildFiles, boolean removeBuildTools) {
        if (version2 == null) {
            InstallBuildToolsHyperlink.$$$reportNull$$$0(1);
        }
        if (buildFiles == null) {
            InstallBuildToolsHyperlink.$$$reportNull$$$0(2);
        }
        super("install.build.tools", InstallBuildToolsHyperlink.getText(version2, !buildFiles.isEmpty()));
        this.myBuildFiles = buildFiles;
        this.myVersion = version2;
        this.myRemoveBuildTools = removeBuildTools;
    }

    @NotNull
    private static String getText(@NotNull String version2, boolean hasBuildFiles) {
        if (version2 == null) {
            InstallBuildToolsHyperlink.$$$reportNull$$$0(3);
        }
        Object msg = String.format("Install Build Tools %1$s", version2);
        msg = hasBuildFiles ? (String)msg + ", update version in build file and sync project" : (String)msg + " and sync project";
        Object object = msg;
        if (object == null) {
            InstallBuildToolsHyperlink.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            InstallBuildToolsHyperlink.$$$reportNull$$$0(5);
        }
        ArrayList<String> requested = new ArrayList<String>();
        Revision minBuildToolsRev = Revision.parseRevision((String)this.myVersion);
        requested.add(DetailsTypes.getBuildToolsPath((Revision)minBuildToolsRev));
        ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, requested);
        if (dialog2 != null && dialog2.showAndGet()) {
            if (!this.myBuildFiles.isEmpty()) {
                FixBuildToolsProcessor processor = new FixBuildToolsProcessor(project, this.myBuildFiles, this.myVersion, true, this.myRemoveBuildTools);
                processor.setPreviewUsages(true);
                processor.run();
            } else {
                GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_QF_BUILD_TOOLS_INSTALLED);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/hyperlink/InstallBuildToolsHyperlink";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/InstallBuildToolsHyperlink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

