/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.errors.FixBuildToolsVersionQuickFix;
import com.android.tools.idea.gradle.project.sync.errors.SdkBuildToolsTooLowIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.InstallBuildToolsQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenFileAtLocationQuickFix;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016JD\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "SDK_BUILD_TOOLS_TOO_LOW_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "getBuildIssueDescriptionAndQuickFixes", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/BuildIssueComposer;", "projectPath", "intellij.android.core"})
public final class SdkBuildToolsTooLowIssueChecker
implements GradleIssueChecker {
    private final Pattern SDK_BUILD_TOOLS_TOO_LOW_PATTERN = Pattern.compile("The SDK Build Tools revision \\((.*)\\) is too low for project '(.*)'. Minimum required is (.*)");

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = ((Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first).getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        CharSequence charSequence = message2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = new Runnable(issueData){
            final /* synthetic */ GradleIssueData $issueData$inlined;
            {
                this.$issueData$inlined = gradleIssueData;
            }

            public final void run() {
                boolean bl = false;
                BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.SDK_BUILD_TOOLS_TOO_LOW);
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable2, modalityState);
        BuildIssueComposer buildIssueComposer = this.getBuildIssueDescriptionAndQuickFixes(message2, issueData.getProjectPath());
        return buildIssueComposer != null ? buildIssueComposer.composeBuildIssue() : null;
    }

    private final BuildIssueComposer getBuildIssueDescriptionAndQuickFixes(String message2, String projectPath) {
        AndroidSdkHandler sdkHandler;
        Matcher matcher = this.SDK_BUILD_TOOLS_TOO_LOW_PATTERN.matcher(message2);
        if (!matcher.matches()) {
            return null;
        }
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        String gradlePath = matcher.group(2);
        String minVersion = matcher.group(3);
        Project project = BuildIssueUtilKt.fetchIdeaProjectForGradleProject(projectPath);
        if (project == null) {
            return buildIssueComposer;
        }
        Project ideaProject = project;
        List modules = CollectionsKt.listOfNotNull((Object)GradleUtil.findModuleByGradlePath(ideaProject, gradlePath));
        List buildFiles = CollectionsKt.listOfNotNull(modules.isEmpty() ? null : GradleUtil.getGradleBuildFile((Module)modules.get(0)));
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        Object object = sdkHandler = androidSdkData != null ? androidSdkData.getSdkHandler() : null;
        if (sdkHandler != null) {
            RepositoryPackages packages;
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SdkBuildToolsTooLowIssueChecker.class);
            RepoManager repoManager = sdkHandler.getSdkManager((ProgressIndicator)progress);
            Intrinsics.checkNotNullExpressionValue((Object)repoManager, (String)"sdkHandler.getSdkManager(progress)");
            RepositoryPackages repositoryPackages = packages = repoManager.getPackages();
            Intrinsics.checkNotNullExpressionValue((Object)repositoryPackages, (String)"packages");
            LocalPackage buildTool = (LocalPackage)repositoryPackages.getLocalPackages().get(DetailsTypes.getBuildToolsPath((Revision)Revision.parseRevision((String)minVersion)));
            if (buildTool == null) {
                Collection collection2 = buildFiles;
                boolean bl = false;
                String linkMessage = "Install Build Tools " + minVersion + ' ' + (!collection2.isEmpty() ? ", update version in build file and sync project" : " and sync project");
                String string = minVersion;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"minVersion");
                buildIssueComposer.addQuickFix(linkMessage, new InstallBuildToolsQuickFix(string, buildFiles, SdkBuildToolsTooLowIssueCheckerKt.doesAndroidGradlePluginPackageBuildTools(modules)));
            } else {
                Collection linkMessage = buildFiles;
                boolean bl = false;
                if (!linkMessage.isEmpty()) {
                    boolean removeBuildTools = SdkBuildToolsTooLowIssueCheckerKt.doesAndroidGradlePluginPackageBuildTools(modules);
                    String string = (removeBuildTools ? "Remove" : "Update") + " Build Tools version and sync project";
                    String string2 = minVersion;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"minVersion");
                    buildIssueComposer.addQuickFix(string, new FixBuildToolsVersionQuickFix(string2, buildFiles, removeBuildTools));
                }
            }
        }
        Collection collection3 = buildFiles;
        boolean bl = false;
        if (!collection3.isEmpty()) {
            Object e = buildFiles.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"buildFiles[0]");
            buildIssueComposer.addQuickFix("Open file.", new OpenFileAtLocationQuickFix(new FilePosition(new File(((VirtualFile)e).getPath()), -1, -1)));
        }
        return buildIssueComposer;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return this.SDK_BUILD_TOOLS_TOO_LOW_PATTERN.matcher(failureCause).matches();
    }
}

