/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.FixAndroidGradlePluginVersionQuickFix;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016JD\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0012\u0010\u001c\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/NdkToolchainMissingABIIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "ERROR_MESSAGE", "", "VALID_ABIS", "", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "getAndroidPluginArtifactModel", "Lcom/android/tools/idea/gradle/dsl/api/dependencies/ArtifactDependencyModel;", "projectPath", "isAndroidPlugin", "artifactModel", "isArtifactVersionOver3dot0", "isVersionOver3dot0", "version", "intellij.android.core"})
public final class NdkToolchainMissingABIIssueChecker
implements GradleIssueChecker {
    private final String ERROR_MESSAGE;
    private final List<String> VALID_ABIS = CollectionsKt.listOf((Object[])new String[]{"mips64el-linux-android", "mipsel-linux-android"});

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = ((Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first).getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        if (!StringsKt.startsWith$default((String)message2, (String)this.ERROR_MESSAGE, (boolean)false, (int)2, null)) {
            return null;
        }
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        boolean valid2 = this.VALID_ABIS.stream().anyMatch(new Predicate(message2){
            final /* synthetic */ String $message;

            public final boolean test(String it) {
                String string = it;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                return StringsKt.endsWith$default((String)this.$message, (String)string, (boolean)false, (int)2, null);
            }
            {
                this.$message = string;
            }
        });
        if (valid2 && !this.isArtifactVersionOver3dot0(this.getAndroidPluginArtifactModel(issueData.getProjectPath()))) {
            buildIssueComposer.addDescription("This version of the NDK may be incompatible with the Android Gradle plugin version 3.0 or older.\n\nPlease use plugin version 3.1 or newer.");
            buildIssueComposer.addQuickFix("Upgrade plugin to version " + GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get()) + " and sync project", new FixAndroidGradlePluginVersionQuickFix(null, null));
        }
        return buildIssueComposer.composeBuildIssue();
    }

    private final boolean isArtifactVersionOver3dot0(ArtifactDependencyModel artifactModel) {
        if (artifactModel == null) {
            return false;
        }
        return this.isVersionOver3dot0(artifactModel.version().toString());
    }

    @VisibleForTesting
    public final boolean isVersionOver3dot0(@NotNull String version2) {
        GradleCoordinate versionOnly;
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        GradleCoordinate gradleCoordinate = versionOnly = GradleCoordinate.parseVersionOnly((String)version2);
        Intrinsics.checkNotNullExpressionValue((Object)gradleCoordinate, (String)"versionOnly");
        return gradleCoordinate.getMajorVersion() > 3 || versionOnly.getMajorVersion() == 3 && versionOnly.getMinorVersion() > 0;
    }

    private final ArtifactDependencyModel getAndroidPluginArtifactModel(String projectPath) {
        Project project = BuildIssueUtilKt.fetchIdeaProjectForGradleProject(projectPath);
        if (project == null) {
            return null;
        }
        Project ideaProject = project;
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.getOrLog((Project)ideaProject);
        if (projectBuildModel2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"ProjectBuildModel.getOrL\u2026eaProject) ?: return null");
        ProjectBuildModel projectBuildModel3 = projectBuildModel2;
        GradleBuildModel gradleBuildModel = projectBuildModel3.getProjectBuildModel();
        if (gradleBuildModel == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)gradleBuildModel, (String)"projectBuildModel.projectBuildModel ?: return null");
        GradleBuildModel rootModel = gradleBuildModel;
        List list = rootModel.buildscript().dependencies().artifacts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"rootModel.buildscript().dependencies().artifacts()");
        List dependencyModels = list;
        return dependencyModels.stream().filter(new Predicate(this){
            final /* synthetic */ NdkToolchainMissingABIIssueChecker this$0;

            public final boolean test(ArtifactDependencyModel dependency) {
                ArtifactDependencyModel artifactDependencyModel = dependency;
                Intrinsics.checkNotNullExpressionValue((Object)artifactDependencyModel, (String)"dependency");
                return NdkToolchainMissingABIIssueChecker.access$isAndroidPlugin(this.this$0, artifactDependencyModel);
            }
            {
                this.this$0 = ndkToolchainMissingABIIssueChecker;
            }
        }).findFirst().orElse(null);
    }

    private final boolean isAndroidPlugin(ArtifactDependencyModel artifactModel) {
        return Intrinsics.areEqual((Object)artifactModel.group().toString(), (Object)"com.android.tools.build") && Intrinsics.areEqual((Object)artifactModel.name().toString(), (Object)"gradle");
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return StringsKt.startsWith$default((String)failureCause, (String)this.ERROR_MESSAGE, (boolean)false, (int)2, null);
    }

    public NdkToolchainMissingABIIssueChecker() {
        this.ERROR_MESSAGE = "No toolchains found in the NDK toolchains folder for ABI with prefix: ";
    }

    public static final /* synthetic */ boolean access$isAndroidPlugin(NdkToolchainMissingABIIssueChecker $this, ArtifactDependencyModel artifactModel) {
        return $this.isAndroidPlugin(artifactModel);
    }
}

