/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.errors.InstallPlatformQuickFix;
import com.android.tools.idea.gradle.project.sync.errors.MissingPlatformIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.errors.OpenAndroidSdkManagerQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.util.Collection;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingPlatformIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.android.core"})
public final class MissingPlatformIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        AndroidVersion version2;
        AndroidSdkHandler sdkHandler;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        String missingPlatform = MissingPlatformIssueCheckerKt.getMissingPlatform(message2);
        if (StringsKt.isBlank((CharSequence)message2) || missingPlatform == null || !(rootCause instanceof IllegalStateException) && !(rootCause instanceof ExternalSystemException)) {
            return null;
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = new Runnable(issueData){
            final /* synthetic */ GradleIssueData $issueData$inlined;
            {
                this.$issueData$inlined = gradleIssueData;
            }

            public final void run() {
                boolean bl = false;
                BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.MISSING_ANDROID_PLATFORM);
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable2, modalityState);
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        Object object = sdkHandler = androidSdkData != null ? androidSdkData.getSdkHandler() : null;
        if (sdkHandler != null && (version2 = AndroidTargetHash.getPlatformVersion((String)missingPlatform)) != null) {
            StudioLoggerProgressIndicator logger2 = new StudioLoggerProgressIndicator(this.getClass());
            String causes = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger2).getErrorForPackage(DetailsTypes.getPlatformPath((AndroidVersion)version2));
            buildIssueComposer.addDescription(causes != null ? "possible cause: \n " + causes : "");
            buildIssueComposer.addQuickFix("Install missing platform(s) and sync project", new InstallPlatformQuickFix(CollectionsKt.listOf((Object)version2)));
        }
        if (buildIssueComposer.getIssueQuickFixes().isEmpty()) {
            boolean projectFound = false;
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            for (Project project : projectManager.getOpenProjects()) {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                for (Module module2 : moduleManager.getModules()) {
                    Collection facets;
                    if (!Intrinsics.areEqual((Object)AndroidProjectRootUtil.getModuleDirPath(module2), (Object)issueData.getProjectPath())) continue;
                    projectFound = true;
                    Intrinsics.checkNotNullExpressionValue((Object)FacetManager.getInstance((Module)module2).getFacetsByType(AndroidFacet.ID), (String)"FacetManager.getInstance\u2026tsByType(AndroidFacet.ID)");
                    Collection collection2 = facets;
                    boolean bl = false;
                    if (!(!collection2.isEmpty())) break;
                    buildIssueComposer.addQuickFix("Open Android SDK Manager", new OpenAndroidSdkManagerQuickFix());
                    break;
                }
                if (projectFound) break;
            }
        }
        return buildIssueComposer.composeBuildIssue();
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return stacktrace != null && (MissingPlatformIssueCheckerKt.access$getILLEGAL_STATE_TRACE_PATTERN$p().matcher(stacktrace).find() || MissingPlatformIssueCheckerKt.access$getEXTERNAL_SYSTEM_EXCEPTION_PATTERN$p().matcher(stacktrace).find()) && MissingPlatformIssueCheckerKt.getMissingPlatform(failureCause) != null;
    }
}

