/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.Revision;
import com.android.repository.api.RemotePackage;
import com.android.tools.idea.gradle.project.sync.errors.RevisionOrHigher;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\u0007\u001a\u0004\u0018\u00010\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0007\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"FORK_CMAKE_REPORTED_VERSION", "", "FORK_CMAKE_SDK_VERSION", "ourForkCmakeReportedVersion", "Lcom/android/repository/Revision;", "kotlin.jvm.PlatformType", "ourForkCmakeSdkVersion", "findBestMatch", "cmakePackages", "", "Lcom/android/repository/api/RemotePackage;", "requestedCmake", "Lcom/android/tools/idea/gradle/project/sync/errors/RevisionOrHigher;", "parseRevisionOrHigher", "version", "firstLine", "versionSatisfies", "", "candidateCmake", "intellij.android.core"})
public final class MissingCMakeIssueCheckerKt {
    private static final String FORK_CMAKE_SDK_VERSION = "3.6.4111459";
    private static final String FORK_CMAKE_REPORTED_VERSION = "3.6.0";
    private static final Revision ourForkCmakeSdkVersion = Revision.parseRevision((String)"3.6.4111459");
    private static final Revision ourForkCmakeReportedVersion = Revision.parseRevision((String)"3.6.0");

    @VisibleForTesting
    @Nullable
    public static final Revision findBestMatch(@NotNull Collection<? extends RemotePackage> cmakePackages, @NotNull RevisionOrHigher requestedCmake) {
        Intrinsics.checkNotNullParameter(cmakePackages, (String)"cmakePackages");
        Intrinsics.checkNotNullParameter((Object)requestedCmake, (String)"requestedCmake");
        Revision foundVersion = null;
        for (RemotePackage remotePackage : cmakePackages) {
            Revision remoteCmake = remotePackage.getVersion();
            if (Intrinsics.areEqual((Object)remoteCmake, (Object)ourForkCmakeSdkVersion)) {
                remoteCmake = ourForkCmakeReportedVersion;
            }
            Revision revision = remoteCmake;
            Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"remoteCmake");
            if (!MissingCMakeIssueCheckerKt.versionSatisfies(revision, requestedCmake)) continue;
            if (foundVersion == null) {
                foundVersion = remoteCmake;
                continue;
            }
            if (remoteCmake.compareTo(foundVersion, Revision.PreviewComparison.IGNORE) <= 0) continue;
            foundVersion = remoteCmake;
        }
        return foundVersion;
    }

    @VisibleForTesting
    @Nullable
    public static final RevisionOrHigher parseRevisionOrHigher(@NotNull String version2, @NotNull String firstLine) {
        RevisionOrHigher revisionOrHigher;
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)firstLine, (String)"firstLine");
        try {
            Revision revision = Revision.parseRevision((String)version2);
            Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"Revision.parseRevision(version)");
            revisionOrHigher = new RevisionOrHigher(revision, StringsKt.contains$default((CharSequence)firstLine, (CharSequence)('\'' + version2 + "' or higher"), (boolean)false, (int)2, null));
        }
        catch (NumberFormatException e) {
            revisionOrHigher = null;
        }
        return revisionOrHigher;
    }

    @VisibleForTesting
    public static final boolean versionSatisfies(@NotNull Revision candidateCmake, @NotNull RevisionOrHigher requestedCmake) {
        Intrinsics.checkNotNullParameter((Object)candidateCmake, (String)"candidateCmake");
        Intrinsics.checkNotNullParameter((Object)requestedCmake, (String)"requestedCmake");
        int result2 = candidateCmake.compareTo(requestedCmake.getRevision(), Revision.PreviewComparison.IGNORE);
        return result2 == 0 || requestedCmake.getOrHigher() && result2 >= 0;
    }
}

