/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.FixAndroidGradlePluginVersionQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.InstallBuildToolsQuickFix;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.project.Project;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JD\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00180\u0017H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingBuildToolsIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "EXCEPTION_EXTERNAL_SYSTEM_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "EXCEPTION_ILLEGAL_PATTERN", "MISSING_BUILD_TOOLS_PATTERN", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "getBuildIssueDescription", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/BuildIssueComposer;", "projectPath", "version", "intellij.android.core"})
public final class MissingBuildToolsIssueChecker
implements GradleIssueChecker {
    private final Pattern MISSING_BUILD_TOOLS_PATTERN = Pattern.compile("(Cause: )?([Ff])ailed to find Build Tools revision (.*)");
    private final Pattern EXCEPTION_ILLEGAL_PATTERN = Pattern.compile("Caused by: java.lang.IllegalStateException(.*)");
    private final Pattern EXCEPTION_EXTERNAL_SYSTEM_PATTERN = Pattern.compile("Caused by: com.intellij.openapi.externalSystem.model.ExternalSystemException(.*)");

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        if (StringsKt.isBlank((CharSequence)message2) || !(rootCause instanceof IllegalStateException) && !(rootCause instanceof ExternalSystemException)) {
            return null;
        }
        Matcher matcher = this.MISSING_BUILD_TOOLS_PATTERN.matcher((CharSequence)StringsKt.lines((CharSequence)message2).get(0));
        if (!matcher.matches()) {
            return null;
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = new Runnable(issueData){
            final /* synthetic */ GradleIssueData $issueData$inlined;
            {
                this.$issueData$inlined = gradleIssueData;
            }

            public final void run() {
                boolean bl = false;
                BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.MISSING_BUILD_TOOLS);
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable2, modalityState);
        String version2 = matcher.group(3);
        String string2 = issueData.getProjectPath();
        String string3 = version2;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"version");
        BuildIssueComposer buildIssueComposer = this.getBuildIssueDescription(message2, string2, string3);
        return buildIssueComposer.composeBuildIssue();
    }

    private final BuildIssueComposer getBuildIssueDescription(String message2, String projectPath, String version2) {
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        Project project = BuildIssueUtilKt.fetchIdeaProjectForGradleProject(projectPath);
        if (project == null) {
            return buildIssueComposer;
        }
        Project ideaProject = project;
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.findFromBuildFiles(ideaProject);
        GradleVersion currentAGPVersion = androidPluginInfo != null ? androidPluginInfo.getPluginVersion() : null;
        GradleVersion recommendedAGPVersion = GradleVersion.tryParseAndroidGradlePluginVersion((String)LatestKnownPluginVersionProvider.INSTANCE.get());
        buildIssueComposer.addQuickFix("Install Build Tools " + version2 + " and sync project", new InstallBuildToolsQuickFix(version2, CollectionsKt.emptyList(), false));
        if (currentAGPVersion == null || recommendedAGPVersion == null || currentAGPVersion.compareTo(recommendedAGPVersion) < 0) {
            buildIssueComposer.addQuickFix("Upgrade plugin to version " + GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get()) + " and sync project", new FixAndroidGradlePluginVersionQuickFix(null, null));
        }
        return buildIssueComposer;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return stacktrace != null && (this.EXCEPTION_ILLEGAL_PATTERN.matcher(stacktrace).find() || this.EXCEPTION_EXTERNAL_SYSTEM_PATTERN.matcher(stacktrace).find()) && this.MISSING_BUILD_TOOLS_PATTERN.matcher((CharSequence)StringsKt.lines((CharSequence)failureCause).get(0)).matches();
    }
}

