/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JD\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00170\u0016H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0017J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/FailedToParseSdkIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "EXCEPTION_TRACE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "FAILED_TO_PARSE", "", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "findPathOfSdkWithoutAddonsFolder", "Ljava/io/File;", "projectPath", "isMissingAddonsFolder", "sdkHomePath", "intellij.android.core"})
public class FailedToParseSdkIssueChecker
implements GradleIssueChecker {
    private final String FAILED_TO_PARSE;
    private final Pattern EXCEPTION_TRACE_PATTERN = Pattern.compile("Caused by: java.lang.RuntimeException(.*)");

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        if (!(rootCause instanceof RuntimeException) || StringsKt.isBlank((CharSequence)message2) || !StringsKt.contains$default((CharSequence)message2, (CharSequence)this.FAILED_TO_PARSE, (boolean)false, (int)2, null)) {
            return null;
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = new Runnable(issueData){
            final /* synthetic */ GradleIssueData $issueData$inlined;
            {
                this.$issueData$inlined = gradleIssueData;
            }

            public final void run() {
                boolean bl = false;
                BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.FAILED_TO_PARSE_SDK);
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable2, modalityState);
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        File file2 = this.findPathOfSdkWithoutAddonsFolder(issueData.getProjectPath());
        if (file2 == null) {
            BuildIssueComposer buildIssueComposer2 = buildIssueComposer;
            boolean bl = false;
            boolean bl2 = false;
            BuildIssueComposer $this$apply = buildIssueComposer2;
            boolean bl3 = false;
            $this$apply.addDescription("The Android SDK may be missing the directory 'add-ons'.");
            return buildIssueComposer2.composeBuildIssue();
        }
        File pathOfBrokenSdk = file2;
        buildIssueComposer.addDescription("The directory 'add-ons', in the Android SDK at '" + pathOfBrokenSdk.getPath() + "', is either missing or empty");
        if (!pathOfBrokenSdk.canWrite()) {
            buildIssueComposer.addDescription("Current user ('" + SystemProperties.getUserName() + "') does not have write access to the SDK directory.");
        }
        return buildIssueComposer.composeBuildIssue();
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return stacktrace != null && this.EXCEPTION_TRACE_PATTERN.matcher(stacktrace).find() && StringsKt.contains$default((CharSequence)failureCause, (CharSequence)this.FAILED_TO_PARSE, (boolean)false, (int)2, null);
    }

    @VisibleForTesting
    @Nullable
    public File findPathOfSdkWithoutAddonsFolder(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        AndroidSdks androidSdks = AndroidSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdks, (String)"AndroidSdks.getInstance()");
        AndroidSdks androidSdk = androidSdks;
        IdeInfo ideInfo = IdeInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideInfo, (String)"IdeInfo.getInstance()");
        if (ideInfo.isAndroidStudio()) {
            IdeSdks ideSdks = IdeSdks.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"IdeSdks.getInstance()");
            File sdkPath = ideSdks.getAndroidSdkPath();
            if (sdkPath != null && this.isMissingAddonsFolder(sdkPath)) {
                return sdkPath;
            }
        } else {
            boolean projectFound = false;
            Module[] modules = null;
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            for (Project project : projectManager.getOpenProjects()) {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                for (Module module2 : modules = moduleManager.getModules()) {
                    if (!Intrinsics.areEqual((Object)AndroidProjectRootUtil.getModuleDirPath(module2), (Object)projectPath)) continue;
                    projectFound = true;
                    break;
                }
                if (projectFound) break;
            }
            if (!projectFound || modules == null) {
                return null;
            }
            for (Project project : modules) {
                File sdkHomePath;
                String homePath;
                Sdk moduleSdk;
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)project);
                Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                if (moduleRootManager.getSdk() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)moduleSdk, (String)"ModuleRootManager.getIns\u2026e(module).sdk ?: continue");
                if (!androidSdk.isAndroidSdk(moduleSdk)) continue;
                if (moduleSdk.getHomePath() == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)homePath, (String)"moduleSdk.homePath ?: continue");
                File file2 = sdkHomePath = FilePaths.stringToFile((String)homePath);
                Intrinsics.checkNotNull((Object)file2);
                if (!this.isMissingAddonsFolder(file2)) continue;
                return sdkHomePath;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMissingAddonsFolder(File sdkHomePath) {
        File addonsFolder = new File(sdkHomePath, "add-ons");
        if (!addonsFolder.isDirectory()) return true;
        File[] fileArray = FileUtil.notNullize((File[])addonsFolder.listFiles());
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"FileUtil.notNullize(addonsFolder.listFiles())");
        File[] fileArray2 = fileArray;
        boolean bl = false;
        if (fileArray2.length != 0) return false;
        return true;
    }

    public FailedToParseSdkIssueChecker() {
        this.FAILED_TO_PARSE = "failed to parse SDK";
    }
}

