/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.quickFixes.OpenLinkQuickFix;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016JD\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/DuplicateClassIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "DUPLICATE_CLASS", "", "EXCEPTION_TRACE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "HREF", "SUFFIX", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.android.core"})
public final class DuplicateClassIssueChecker
implements GradleIssueChecker {
    private final String HREF;
    private final String SUFFIX;
    private final String DUPLICATE_CLASS;
    private final Pattern EXCEPTION_TRACE_PATTERN;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        void message2;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        if (!(issueData.getError() instanceof BuildException)) {
            return null;
        }
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        if (!(rootCause instanceof RuntimeException)) {
            return null;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        objectRef.element = string;
        if (!StringsKt.startsWith$default((String)((String)message2.element), (String)this.DUPLICATE_CLASS, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)((String)message2.element), (String)this.SUFFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        OpenLinkQuickFix urlLink = new OpenLinkQuickFix("http://" + this.HREF);
        message2.element = StringsKt.replace$default((String)((String)message2.element), (String)this.HREF, (String)urlLink.getId(), (boolean)false, (int)4, null);
        return new BuildIssue((Ref.ObjectRef)message2, urlLink){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<OpenLinkQuickFix> quickFixes;
            final /* synthetic */ Ref.ObjectRef $message;
            final /* synthetic */ OpenLinkQuickFix $urlLink;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<OpenLinkQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
            {
                this.$message = $captured_local_variable$0;
                this.$urlLink = $captured_local_variable$1;
                this.title = "Duplicate class found";
                this.description = (String)$captured_local_variable$0.element;
                this.quickFixes = CollectionsKt.listOf((Object)$captured_local_variable$1);
            }
        };
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return stacktrace != null && this.EXCEPTION_TRACE_PATTERN.matcher(stacktrace).find() && StringsKt.startsWith$default((String)failureCause, (String)this.DUPLICATE_CLASS, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)failureCause, (String)this.SUFFIX, (boolean)false, (int)2, null);
    }

    public DuplicateClassIssueChecker() {
        this.HREF = "d.android.com/r/tools/classpath-sync-errors";
        this.SUFFIX = "Go to the documentation to learn how to <a href=\"" + this.HREF + "\">Fix dependency resolution errors</a>.";
        this.DUPLICATE_CLASS = "Duplicate class ";
        this.EXCEPTION_TRACE_PATTERN = Pattern.compile("Caused by: java.lang.RuntimeException(.*)");
    }
}

