/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.DexDisabledIssue;
import com.android.tools.idea.gradle.project.sync.errors.DexDisabledIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.quickFixes.SetLanguageLevel8AllQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.SetLanguageLevel8ModuleQuickFix;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/DexDisabledIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.android.core"})
public final class DexDisabledIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        String modulePath;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable throwable = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        if (throwable == null) {
            return null;
        }
        Throwable rootCause = throwable;
        if (!(rootCause instanceof RuntimeException)) {
            return null;
        }
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String rootMessage = string;
        rootMessage = StringsKt.removePrefix((String)rootMessage, (CharSequence)"Error: ");
        if (!(StringsKt.startsWith$default((String)rootMessage, (String)"Invoke-customs are only supported starting with Android O", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)rootMessage, (String)"Default interface methods are only supported starting with Android N (--min-api 24)", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)rootMessage, (String)"Static interface methods are only supported starting with Android N (--min-api 24)", (boolean)false, (int)2, null))) {
            return null;
        }
        Throwable throwable2 = DexDisabledIssueCheckerKt.access$extractDexArchiveBuilderException(issueData.getError());
        if (throwable2 == null) {
            return null;
        }
        Throwable builderException = throwable2;
        BuildIssueComposer issueComposer = new BuildIssueComposer(rootMessage, "Desugaring disabled");
        String buildMessage = builderException.getMessage();
        if (buildMessage != null) {
            issueComposer.addDescription(buildMessage);
        }
        if ((modulePath = DexDisabledIssueCheckerKt.access$extractModulePathFromError(issueData.getError())) != null) {
            issueComposer.addQuickFix(new SetLanguageLevel8ModuleQuickFix(modulePath, false));
        }
        issueComposer.addQuickFix(new SetLanguageLevel8AllQuickFix(false));
        return new DexDisabledIssue(issueComposer.composeBuildIssue());
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return stacktrace != null && DexDisabledIssueCheckerKt.access$getEXCEPTION_TRACE_PATTERN$p().matcher(stacktrace).find() && (StringsKt.startsWith$default((String)failureCause, (String)"Error: Invoke-customs are only supported starting with Android O", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)failureCause, (String)"Error: Default interface methods are only supported starting with Android N (--min-api 24)", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)failureCause, (String)"Error: Static interface methods are only supported starting with Android N (--min-api 24)", (boolean)false, (int)2, null));
    }
}

