/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.StopGradleDaemonQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenProjectStructureQuickfix;
import com.android.tools.idea.gradle.project.sync.quickFixes.SyncProjectRefreshingDependenciesQuickFix;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.base.Splitter;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016JD\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u0018H\u0016J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/ClassLoadingIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "CANNOT_BE_CAST_TO_EXCEPTION", "", "CLASS_NOT_FOUND_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CLASS_NOT_FOUND_TRACE_PATTERN", "NO_SUCH_METHOD_TRACE_PATTERN", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "getExceptionMessage", "exception", "", "projectPath", "intellij.android.core"})
public final class ClassLoadingIssueChecker
implements GradleIssueChecker {
    private final Pattern CLASS_NOT_FOUND_PATTERN = Pattern.compile("(.+) not found.");
    private final Pattern NO_SUCH_METHOD_TRACE_PATTERN = Pattern.compile("Caused by: java.lang.NoSuchMethodError(.*)");
    private final Pattern CLASS_NOT_FOUND_TRACE_PATTERN = Pattern.compile("Caused by: java.lang.ClassNotFoundException(.*)");
    private final String CANNOT_BE_CAST_TO_EXCEPTION;

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            string = "";
        }
        String message2 = string;
        Throwable throwable = rootCause;
        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"rootCause");
        String string2 = this.getExceptionMessage(throwable, message2, issueData.getProjectPath());
        if (string2 == null) {
            return null;
        }
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(string2, null, 2, null);
        SyncProjectRefreshingDependenciesQuickFix syncProjectQuickFix = new SyncProjectRefreshingDependenciesQuickFix();
        StopGradleDaemonQuickFix stopGradleDaemonQuickFix = new StopGradleDaemonQuickFix();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        IdeSdks ideSdks = IdeSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"IdeSdks.getInstance()");
        Sdk sdk = ideSdks.getJdk();
        if (sdk == null) {
        } else {
            JdkVersionDetector.JdkVersionInfo jdkVersion;
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"IdeSdks.getInstance().jdk ?: return@buildString");
            Sdk jdk = sdk;
            String jdkHomePath = jdk.getHomePath();
            JdkVersionDetector.JdkVersionInfo jdkVersionInfo = jdkVersion = jdkHomePath != null ? SdkVersionUtil.getJdkVersionInfo((String)jdkHomePath) : null;
            if (JavaSdkVersion.JDK_1_7 == JavaSdk.getInstance().getVersion(jdk)) {
                JdkVersionDetector.JdkVersionInfo jdkVersionInfo2 = jdkVersion;
                if (jdkVersionInfo2 == null) {
                    $this$buildString.append("Some versions of JDK 1.7 (e.g. 1.7.0_10) may cause class loading errors in Gradle. \nPlease update to a newer version (e.g. 1.7.0_67).");
                } else {
                    $this$buildString.append("You are using JDK version '" + jdkVersion.version.toFeatureMinorUpdateString() + "'.");
                }
            }
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        String jdk7Hint = string3;
        Object e = Splitter.on((String)"\n").omitEmptyStrings().trimResults().splitToList((CharSequence)message2).get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"Splitter.on(\"\\n\").omitEm\u2026).splitToList(message)[0]");
        buildIssueComposer.addDescription((String)e);
        Object object = jdk7Hint;
        boolean bl6 = false;
        if (object.length() > 0) {
            object = buildIssueComposer;
            bl6 = false;
            bl3 = false;
            Object $this$apply = object;
            boolean bl7 = false;
            ((BuildIssueComposer)$this$apply).addDescription("Possible causes for this unexpected error include:");
            ((BuildIssueComposer)$this$apply).addDescription(jdk7Hint);
            ((BuildIssueComposer)$this$apply).addQuickFix("Open JDK Settings", new OpenProjectStructureQuickfix());
        }
        object = buildIssueComposer;
        bl6 = false;
        bl3 = false;
        Object $this$apply = object;
        boolean bl8 = false;
        ((BuildIssueComposer)$this$apply).addDescription("Gradle's dependency cache may be corrupt (this sometimes occurs after a network connection timeout.)");
        ((BuildIssueComposer)$this$apply).addQuickFix(syncProjectQuickFix.getLinkText(), syncProjectQuickFix);
        ((BuildIssueComposer)$this$apply).addDescription("The state of a Gradle build process (daemon) may be corrupt. Stopping all Gradle daemons may solve this problem.");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        boolean bl9 = application.isRestartCapable();
        if (bl9) {
            ((BuildIssueComposer)$this$apply).addQuickFix("Stop Gradle build processes (requires restart)", stopGradleDaemonQuickFix);
        } else if (!bl9) {
            ((BuildIssueComposer)$this$apply).addQuickFix("Open Gradle Daemon documentation", stopGradleDaemonQuickFix);
        }
        ((BuildIssueComposer)$this$apply).addDescription("Your project may be using a third-party plugin which is not compatible with the other plugins in the project or the version of Gradle requested by the project.\n\nIn the case of corrupt Gradle processes, you can also try closing the IDE and then killing all Java processes.");
        return buildIssueComposer.composeBuildIssue();
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (stacktrace != null && this.NO_SUCH_METHOD_TRACE_PATTERN.matcher(stacktrace).find()) {
            return true;
        }
        if (stacktrace != null && this.CLASS_NOT_FOUND_TRACE_PATTERN.matcher(stacktrace).find() && this.CLASS_NOT_FOUND_PATTERN.matcher(failureCause).matches()) {
            return true;
        }
        return StringsKt.contains$default((CharSequence)failureCause, (CharSequence)this.CANNOT_BE_CAST_TO_EXCEPTION, (boolean)false, (int)2, null);
    }

    private final String getExceptionMessage(Throwable exception, String message2, String projectPath) {
        Throwable throwable = exception;
        if (throwable instanceof ClassNotFoundException) {
            String className2 = message2;
            Matcher matcher = this.CLASS_NOT_FOUND_PATTERN.matcher(className2);
            if (matcher.matches()) {
                String string = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
                className2 = string;
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable2 = new Runnable(projectPath){
                    final /* synthetic */ String $projectPath$inlined;
                    {
                        this.$projectPath$inlined = string;
                    }

                    public final void run() {
                        boolean bl = false;
                        BuildIssueUtilKt.updateUsageTracker(this.$projectPath$inlined, AndroidStudioEvent.GradleSyncFailure.CLASS_NOT_FOUND);
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable2, modalityState);
                return "Unable to load class '" + className2 + '\'';
            }
        } else {
            if (throwable instanceof NoSuchMethodError) {
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable3 = new Runnable(projectPath){
                    final /* synthetic */ String $projectPath$inlined;
                    {
                        this.$projectPath$inlined = string;
                    }

                    public final void run() {
                        boolean bl = false;
                        BuildIssueUtilKt.updateUsageTracker(this.$projectPath$inlined, AndroidStudioEvent.GradleSyncFailure.METHOD_NOT_FOUND);
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable3, modalityState);
                return "Unable to find method '" + message2 + '\'';
            }
            if (StringsKt.contains$default((CharSequence)message2, (CharSequence)this.CANNOT_BE_CAST_TO_EXCEPTION, (boolean)false, (int)2, null)) {
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable4 = new Runnable(projectPath){
                    final /* synthetic */ String $projectPath$inlined;
                    {
                        this.$projectPath$inlined = string;
                    }

                    public final void run() {
                        boolean bl = false;
                        BuildIssueUtilKt.updateUsageTracker(this.$projectPath$inlined, AndroidStudioEvent.GradleSyncFailure.CANNOT_BE_CAST_TO);
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable4, modalityState);
                return message2;
            }
        }
        return null;
    }

    public ClassLoadingIssueChecker() {
        this.CANNOT_BE_CAST_TO_EXCEPTION = "cannot be cast to";
    }
}

