/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.issues.processor.AddRepoProcessor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.NpwUiUtilsKt;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/AddGoogleMavenRepositoryQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "()V", "id", "", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.core"})
public final class AddGoogleMavenRepositoryQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String id;

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        NpwUiUtilsKt.invokeLater$default(null, (Function0)new Function0<Unit>(project){
            final /* synthetic */ Project $project;

            public final void invoke() {
                if (this.$project.isInitialized()) {
                    VirtualFile virtualFile;
                    AndroidPluginInfo pluginInfo = AndroidPluginInfo.findFromBuildFiles(this.$project);
                    if (pluginInfo != null) {
                        virtualFile = pluginInfo.getPluginBuildFile();
                    } else {
                        virtualFile = GradleUtil.getGradleBuildFile(Projects.getBaseDirPath((Project)this.$project));
                        if (virtualFile == null) {
                            return;
                        }
                    }
                    VirtualFile buildFile = virtualFile;
                    ProjectBuildModel projectBuildModel2 = ProjectBuildModel.getOrLog((Project)this.$project);
                    if (projectBuildModel2 == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"ProjectBuildModel.getOrL\u2026ct) ?: return@invokeLater");
                    ProjectBuildModel projectBuildModel3 = projectBuildModel2;
                    VirtualFile virtualFile2 = buildFile;
                    Intrinsics.checkNotNull((Object)virtualFile2);
                    GradleBuildModel gradleBuildModel = projectBuildModel3.getModuleBuildModel(virtualFile2);
                    Intrinsics.checkNotNullExpressionValue((Object)gradleBuildModel, (String)"projectBuildModel.getModuleBuildModel(buildFile!!)");
                    GradleBuildModel gradleBuildModel2 = gradleBuildModel;
                    if (!gradleBuildModel2.buildscript().repositories().hasGoogleMavenRepository()) {
                        AddRepoProcessor processor = new AddRepoProcessor(this.$project, CollectionsKt.listOf((Object)buildFile), AddRepoProcessor.Repository.GOOGLE, true);
                        processor.setPreviewUsages(true);
                        processor.run();
                    }
                } else {
                    Messages.showErrorDialog((Project)this.$project, (String)"Failed to add Google Maven repository.", (String)"Quick Fix");
                }
            }
            {
                this.$project = project;
                super(0);
            }
        }, 1, null);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture<Any>(null)");
        return completableFuture;
    }

    public AddGoogleMavenRepositoryQuickFix() {
        this.id = "add.google.maven.repo";
    }
}

