/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.ui.GuiTestingService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Key;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimulatedSyncErrors {
    private static Key<RuntimeException> SIMULATED_ERROR_KEY = Key.create((String)"com.android.tools.idea.gradle.sync.simulated.errors");

    private SimulatedSyncErrors() {
    }

    public static void clear() {
        SimulatedSyncErrors.verifyIsTestMode();
        SimulatedSyncErrors.store(null);
    }

    public static void registerSyncErrorToSimulate(@NotNull String errorMessage) {
        if (errorMessage == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(0);
        }
        SimulatedSyncErrors.registerSyncErrorToSimulate(new RuntimeException(errorMessage));
    }

    public static void registerSyncErrorToSimulate(@NotNull RuntimeException exception) {
        if (exception == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(1);
        }
        SimulatedSyncErrors.verifyIsTestMode();
        SimulatedSyncErrors.store(exception);
    }

    public static void registerSyncErrorToSimulate(@NotNull String errorMessage, @NotNull File errorFile) {
        if (errorMessage == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(2);
        }
        if (errorFile == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(3);
        }
        SimulatedSyncErrors.registerSyncErrorToSimulate(new Throwable(errorMessage), errorFile);
    }

    public static void registerSyncErrorToSimulate(@NotNull Throwable cause, @NotNull File errorFile) {
        if (cause == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(4);
        }
        if (errorFile == null) {
            SimulatedSyncErrors.$$$reportNull$$$0(5);
        }
        SimulatedSyncErrors.verifyIsTestMode();
        LocationAwareExternalSystemException exception = new LocationAwareExternalSystemException(cause.getMessage(), errorFile.getPath(), new String[0]);
        exception.initCause(cause);
        SimulatedSyncErrors.store((RuntimeException)exception);
    }

    private static void store(@Nullable RuntimeException exception) {
        ApplicationManager.getApplication().putUserData(SIMULATED_ERROR_KEY, (Object)exception);
    }

    public static void simulateRegisteredSyncError() {
        Application application = ApplicationManager.getApplication();
        RuntimeException error = (RuntimeException)application.getUserData(SIMULATED_ERROR_KEY);
        if (error != null) {
            SimulatedSyncErrors.verifyIsTestMode();
            application.putUserData(SIMULATED_ERROR_KEY, null);
            throw error;
        }
    }

    private static void verifyIsTestMode() {
        if (!SimulatedSyncErrors.isTestMode()) {
            throw new IllegalStateException("Not in unit or UI test mode");
        }
    }

    private static boolean isTestMode() {
        return GuiTestingService.getInstance().isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "errorMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "exception";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "errorFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "cause";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/gradle/project/sync/SimulatedSyncErrors";
        objectArray[2] = "registerSyncErrorToSimulate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

