/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.GradleSyncExecutor;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleSyncInvoker {
    private static final Logger LOG = Logger.getInstance(GradleSyncInvoker.class);

    @NotNull
    public static GradleSyncInvoker getInstance() {
        GradleSyncInvoker gradleSyncInvoker = (GradleSyncInvoker)ApplicationManager.getApplication().getService(GradleSyncInvoker.class);
        if (gradleSyncInvoker == null) {
            GradleSyncInvoker.$$$reportNull$$$0(0);
        }
        return gradleSyncInvoker;
    }

    public void requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(1);
        }
        if (trigger == null) {
            GradleSyncInvoker.$$$reportNull$$$0(2);
        }
        this.requestProjectSync(project, trigger, null);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger, @Nullable GradleSyncListener listener2) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(3);
        }
        if (trigger == null) {
            GradleSyncInvoker.$$$reportNull$$$0(4);
        }
        Request request = new Request(trigger);
        this.requestProjectSync(project, request, listener2);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(5);
        }
        if (request == null) {
            GradleSyncInvoker.$$$reportNull$$$0(6);
        }
        this.requestProjectSync(project, request, null);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener2) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(7);
        }
        if (request == null) {
            GradleSyncInvoker.$$$reportNull$$$0(8);
        }
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        if (GradleSyncInvoker.isBuildInProgress(project)) {
            GradleProjects.setSyncRequestedDuringBuild(project, true);
            return;
        }
        Runnable syncTask = () -> {
            ExternalSystemUtil.ensureToolWindowContentInitialized((Project)project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
            if (GradleSyncInvoker.prepareProject(project, listener2)) {
                GradleSyncInvoker.sync(project, request, listener2);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.invokeAndWait(syncTask);
        } else if (request.runInBackground) {
            ApplicationManager.getApplication().invokeLater(syncTask);
        } else {
            ApplicationManager.getApplication().invokeAndWait(syncTask);
        }
    }

    private static boolean isBuildInProgress(@NotNull Project project) {
        IdeFrame frame;
        StatusBarEx statusBar;
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(9);
        }
        StatusBarEx statusBarEx = statusBar = (frame = WindowManagerEx.getInstanceEx().findFrameFor(project)) == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            return false;
        }
        for (Pair backgroundProcess : statusBar.getBackgroundProcesses()) {
            ProgressIndicator second;
            TaskInfo task2 = (TaskInfo)backgroundProcess.getFirst();
            if (!(task2 instanceof GradleTasksExecutor) || !(second = (ProgressIndicator)backgroundProcess.getSecond()).isRunning()) continue;
            return true;
        }
        return false;
    }

    private static boolean prepareProject(@NotNull Project project, @Nullable GradleSyncListener listener2) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(10);
        }
        GradleProjectInfo projectInfo = GradleProjectInfo.getInstance(project);
        if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() || projectInfo.hasTopLevelGradleFile()) {
            boolean isImportedProject = projectInfo.isImportedProject();
            if (!isImportedProject) {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
            return true;
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> {
            String msg = String.format("The project '%s' is not a Gradle-based project", project.getName());
            LOG.error(msg);
            AndroidNotification.getInstance(project).showBalloon("Project Sync", msg, NotificationType.ERROR, new OpenMigrationToGradleUrlHyperlink());
            if (listener2 != null) {
                listener2.syncFailed(project, msg);
            }
        });
        return false;
    }

    @WorkerThread
    private static void sync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener2) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(11);
        }
        if (request == null) {
            GradleSyncInvoker.$$$reportNull$$$0(12);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> GradleSyncMessages.getInstance(project).removeAllMessages());
        new GradleSyncExecutor(project).sync(request, listener2);
    }

    @WorkerThread
    public void fetchAndMergeNativeVariants(@NotNull Project project, @NotNull @NotNull Set<@NotNull String> requestedAbis) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(13);
        }
        if (requestedAbis == null) {
            GradleSyncInvoker.$$$reportNull$$$0(14);
        }
        new GradleSyncExecutor(project).fetchAndMergeNativeVariants(requestedAbis);
    }

    @WorkerThread
    @NotNull
    public List<GradleModuleModels> fetchGradleModels(@NotNull Project project) {
        if (project == null) {
            GradleSyncInvoker.$$$reportNull$$$0(15);
        }
        List<GradleModuleModels> list = new GradleSyncExecutor(project).fetchGradleModels();
        if (list == null) {
            GradleSyncInvoker.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedAbis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchGradleModels";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "requestProjectSync";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isBuildInProgress";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareProject";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sync";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fetchAndMergeNativeVariants";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fetchGradleModels";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @TestOnly
    public static class FakeInvoker
    extends GradleSyncInvoker {
        @Override
        public void requestProjectSync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener2) {
            if (project == null) {
                FakeInvoker.$$$reportNull$$$0(0);
            }
            if (request == null) {
                FakeInvoker.$$$reportNull$$$0(1);
            }
            if (listener2 != null) {
                listener2.syncSkipped(project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$FakeInvoker";
            objectArray[2] = "requestProjectSync";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Request {
        public final GradleSyncStats.Trigger trigger;
        public boolean runInBackground;
        public boolean forceFullVariantsSync;
        public boolean skipPreSyncChecks;

        @VisibleForTesting
        @NotNull
        public static Request testRequest() {
            return new Request(GradleSyncStats.Trigger.TRIGGER_TEST_REQUESTED);
        }

        public Request(@NotNull GradleSyncStats.Trigger trigger) {
            if (trigger == null) {
                Request.$$$reportNull$$$0(0);
            }
            this.runInBackground = true;
            this.trigger = trigger;
        }

        @NotNull
        public ProgressExecutionMode getProgressExecutionMode() {
            ProgressExecutionMode progressExecutionMode = this.runInBackground ? ProgressExecutionMode.IN_BACKGROUND_ASYNC : ProgressExecutionMode.MODAL_SYNC;
            if (progressExecutionMode == null) {
                Request.$$$reportNull$$$0(1);
            }
            return progressExecutionMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.trigger == request.trigger && this.runInBackground == request.runInBackground && this.forceFullVariantsSync == request.forceFullVariantsSync && this.skipPreSyncChecks == request.skipPreSyncChecks;
        }

        public int hashCode() {
            return Objects.hash(this.trigger, this.runInBackground, this.forceFullVariantsSync, this.skipPreSyncChecks);
        }

        public String toString() {
            return "RequestSettings{trigger=" + this.trigger + ", runInBackground=" + this.runInBackground + ", forceFullVariantsSync=" + this.forceFullVariantsSync + ", skipPreSyncChecks=" + this.skipPreSyncChecks + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trigger";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProgressExecutionMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

