/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.utils.BuildScriptUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectFolder {
    public abstract void createTopLevelBuildFile() throws IOException;

    public abstract void createIdeaProjectFolder() throws IOException;

    public static void deleteLibrariesFolder(@NotNull File projectFolder) {
        File librariesFolderPath;
        File ideaFolderPath;
        if (projectFolder == null) {
            ProjectFolder.$$$reportNull$$$0(0);
        }
        if ((ideaFolderPath = new File(projectFolder, ".idea")).isDirectory() && (librariesFolderPath = new File(ideaFolderPath, "libraries")).exists() && !FileUtil.delete((File)librariesFolderPath)) {
            Logger.getInstance(ProjectFolder.class).info(String.format("Failed to delete %1$s'", librariesFolderPath.getPath()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolder", "com/android/tools/idea/gradle/project/importing/ProjectFolder", "deleteLibrariesFolder"));
    }

    @VisibleForTesting
    static class ProjectFolderImpl
    extends ProjectFolder {
        @NotNull
        private final File myPath;

        ProjectFolderImpl(@NotNull File path2) {
            if (path2 == null) {
                ProjectFolderImpl.$$$reportNull$$$0(0);
            }
            this.myPath = path2;
        }

        @Override
        public void createTopLevelBuildFile() throws IOException {
            File buildFile = BuildScriptUtil.findGradleBuildFile((File)this.myPath);
            if (buildFile.isFile()) {
                return;
            }
            FileUtil.createIfNotExists((File)buildFile);
            String contents = "// Top-level build file where you can add configuration options common to all sub-projects/modules." + System.lineSeparator();
            FileUtil.writeToFile((File)buildFile, (String)contents);
        }

        @Override
        public void createIdeaProjectFolder() throws IOException {
            ProjectFolderImpl.deleteLibrariesFolder(this.myPath);
            File ideaFolderPath = new File(this.myPath, ".idea");
            FileUtil.ensureExists((File)ideaFolderPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/project/importing/ProjectFolder$ProjectFolderImpl", "<init>"));
        }
    }

    public static class Factory {
        @NotNull
        public ProjectFolder create(@NotNull File projectFolderPath) {
            if (projectFolderPath == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return new ProjectFolderImpl(projectFolderPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolderPath", "com/android/tools/idea/gradle/project/importing/ProjectFolder$Factory", "create"));
        }
    }
}

