/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildOutputParser
implements BuildOutputParser {
    @NotNull
    private static final String DEFAULT_MESSAGE_GROUP = "Android Gradle Plugin warnings";
    @NotNull
    private final Map<Object, Set<String>> futureOutputMap = new HashMap<Object, Set<String>>();
    @NotNull
    private final Gson myGson;

    public GradleBuildOutputParser() {
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping();
        MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gsonBuilder);
        this.myGson = gsonBuilder.create();
    }

    public boolean parse(@NotNull String line2, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        String currentLine;
        if (line2 == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(1);
        }
        if (messageConsumer == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(2);
        }
        if ((currentLine = line2.trim()).startsWith("AGPBI: ")) {
            this.processMessage(currentLine, reader.getParentEventId(), messageConsumer);
            return true;
        }
        if (this.futureOutputMap.getOrDefault(reader.getParentEventId(), Collections.emptySet()).contains(currentLine)) {
            this.futureOutputMap.get(reader.getParentEventId()).remove(currentLine);
            return true;
        }
        return false;
    }

    private void processMessage(String line2, Object buildId, @NotNull Consumer<? super MessageEvent> messageConsumer) {
        String jsonString;
        if (messageConsumer == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(3);
        }
        if ((jsonString = line2.substring("AGPBI: ".length()).trim()).isEmpty()) {
            return;
        }
        try {
            Message msg = (Message)this.myGson.fromJson(jsonString, Message.class);
            Set<String> futureOutput = this.futureOutputMap.get(buildId);
            if (futureOutput == null) {
                futureOutput = new HashSet<String>();
                this.futureOutputMap.put(buildId, futureOutput);
            }
            futureOutput.addAll(Arrays.asList(msg.getRawMessage().split("\\n")));
            boolean validPosition = false;
            for (SourceFilePosition sourceFilePosition : msg.getSourceFilePositions()) {
                FilePosition filePosition = GradleBuildOutputParser.convertToFilePosition(sourceFilePosition);
                if (filePosition == null) continue;
                validPosition = true;
                messageConsumer.accept((MessageEvent)new FileMessageEventImpl(buildId, GradleBuildOutputParser.convertKind(msg.getKind()), GradleBuildOutputParser.getMessageGroup(msg), msg.getText(), msg.getRawMessage().isEmpty() ? msg.getText() : msg.getRawMessage(), filePosition));
            }
            if (!validPosition) {
                messageConsumer.accept((MessageEvent)new MessageEventImpl(buildId, GradleBuildOutputParser.convertKind(msg.getKind()), GradleBuildOutputParser.getMessageGroup(msg), msg.getText(), msg.getRawMessage().isEmpty() ? msg.getText() : msg.getRawMessage()));
            }
        }
        catch (JsonParseException ignored) {
            messageConsumer.accept((MessageEvent)new MessageEventImpl(buildId, MessageEvent.Kind.WARNING, GradleBuildOutputParser.getMessageGroup(null), line2, ""));
        }
    }

    @NotNull
    private static String getMessageGroup(@Nullable Message msg) {
        if (msg == null) {
            return DEFAULT_MESSAGE_GROUP;
        }
        String messageGroup = msg.getToolName() == null ? "Android Gradle Plugin" : msg.getToolName();
        switch (msg.getKind()) {
            case WARNING: {
                String string = messageGroup + " warnings";
                if (string == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(4);
                }
                return string;
            }
            case STATISTICS: {
                String string = messageGroup + " statistics";
                if (string == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(5);
                }
                return string;
            }
            case SIMPLE: 
            case INFO: {
                String string = messageGroup + " info";
                if (string == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(6);
                }
                return string;
            }
        }
        String string = messageGroup + " errors";
        if (string == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    private static MessageEvent.Kind convertKind(@NotNull Message.Kind kind) {
        if (kind == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(8);
        }
        switch (kind) {
            case WARNING: {
                MessageEvent.Kind kind2 = MessageEvent.Kind.WARNING;
                if (kind2 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(9);
                }
                return kind2;
            }
            case INFO: {
                MessageEvent.Kind kind3 = MessageEvent.Kind.INFO;
                if (kind3 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(10);
                }
                return kind3;
            }
            case STATISTICS: {
                MessageEvent.Kind kind4 = MessageEvent.Kind.STATISTICS;
                if (kind4 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(11);
                }
                return kind4;
            }
            case SIMPLE: {
                MessageEvent.Kind kind5 = MessageEvent.Kind.SIMPLE;
                if (kind5 == null) {
                    GradleBuildOutputParser.$$$reportNull$$$0(12);
                }
                return kind5;
            }
        }
        MessageEvent.Kind kind6 = MessageEvent.Kind.ERROR;
        if (kind6 == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(13);
        }
        return kind6;
    }

    @Nullable
    private static FilePosition convertToFilePosition(@NotNull SourceFilePosition sourceFilePosition) {
        File sourceFile;
        if (sourceFilePosition == null) {
            GradleBuildOutputParser.$$$reportNull$$$0(14);
        }
        if ((sourceFile = sourceFilePosition.getFile().getSourceFile()) == null) {
            return null;
        }
        SourcePosition position = sourceFilePosition.getPosition();
        int startLine = position.getStartLine();
        int endLine = position.getEndLine();
        int startColumn = position.getStartColumn();
        int endColumn = position.getEndColumn();
        return new FilePosition(sourceFile, startLine, startColumn, endLine, endColumn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/output/GradleBuildOutputParser";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/output/GradleBuildOutputParser";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageGroup";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processMessage";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertKind";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertToFilePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

