/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.android.tools.idea.gradle.project.build.output.EncodedMessage;
import com.android.tools.idea.gradle.project.build.output.FileLocation;
import com.google.gson.Gson;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.io.File;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000f\u0018\u00010\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "jsonFormatter", "Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser;", "legacyFormatter", "Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$LegacyDataBindingOutputParser;", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "JsonDataBindingOutputParser", "LegacyDataBindingOutputParser", "intellij.android.core"})
public final class DataBindingOutputParser
implements BuildOutputParser {
    private final JsonDataBindingOutputParser jsonFormatter = new JsonDataBindingOutputParser();
    private final LegacyDataBindingOutputParser legacyFormatter = new LegacyDataBindingOutputParser();

    public boolean parse(@Nullable String line2, @Nullable BuildOutputInstantReader reader, @Nullable Consumer<? super BuildEvent> messageConsumer) {
        return this.jsonFormatter.parse(line2, reader, messageConsumer) || this.legacyFormatter.parse(line2, reader, messageConsumer);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0000\u0012\u00020\r\u0018\u00010\fH\u0016J(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "gson", "Lcom/google/gson/Gson;", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parseErrorIn", "output", "Lcom/intellij/build/events/MessageEvent;", "Companion", "intellij.android.core"})
    private static final class JsonDataBindingOutputParser
    implements BuildOutputParser {
        private final Gson gson = new Gson();
        private static final String ERROR_LOG_HEADER = "Found data binding error(s):";
        @NotNull
        public static final Companion Companion = new Companion(null);

        public boolean parse(@Nullable String line2, @Nullable BuildOutputInstantReader reader, @Nullable Consumer<? super BuildEvent> messageConsumer) {
            if (line2 == null || reader == null || messageConsumer == null) {
                return false;
            }
            if (StringsKt.contains$default((CharSequence)line2, (CharSequence)ERROR_LOG_HEADER, (boolean)false, (int)2, null)) {
                return true;
            }
            int errorPrefix = StringsKt.indexOf$default((CharSequence)line2, (String)"[databinding] ", (int)0, (boolean)false, (int)6, null);
            if (errorPrefix >= 0) {
                int errorStart = errorPrefix + "[databinding] ".length();
                String string = line2;
                boolean bl = false;
                String string2 = string.substring(errorStart);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                return this.parseErrorIn(string2, reader, messageConsumer);
            }
            return false;
        }

        private final boolean parseErrorIn(String output, BuildOutputInstantReader reader, Consumer<? super MessageEvent> messageConsumer) {
            try {
                EncodedMessage msg = (EncodedMessage)this.gson.fromJson(output, EncodedMessage.class);
                String summary = StringsKt.substringBefore$default((String)msg.getMessage(), (char)'\n', null, (int)2, null);
                if (msg.getLocations().isEmpty()) {
                    messageConsumer.accept((MessageEvent)new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, "Data Binding compiler", summary, msg.getMessage()));
                } else {
                    File sourceFile = new File(msg.getFilePath()).getAbsoluteFile();
                    FileLocation location = (FileLocation)CollectionsKt.first(msg.getLocations());
                    FilePosition filePosition = new FilePosition(sourceFile, location.getStartLine(), location.getStartCol(), location.getEndLine(), location.getEndCol());
                    messageConsumer.accept((MessageEvent)new FileMessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, "Data Binding compiler", summary, msg.getMessage(), filePosition));
                }
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$JsonDataBindingOutputParser$Companion;", "", "()V", "ERROR_LOG_HEADER", "", "intellij.android.core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000b\u0018\u00010\nH\u0016J(\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\nH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$LegacyDataBindingOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parseErrorIn", "output", "Lcom/intellij/build/events/MessageEvent;", "Companion", "intellij.android.core"})
    private static final class LegacyDataBindingOutputParser
    implements BuildOutputParser {
        private static final String ERROR_LOG_HEADER = "Found data binding errors.";
        private static final Regex ERROR_LOG_REGEX;
        private static final Regex ERROR_MESSAGE_REGEX;
        private static final Regex LOCATION_REGEX;
        @NotNull
        public static final Companion Companion;

        public boolean parse(@Nullable String line2, @Nullable BuildOutputInstantReader reader, @Nullable Consumer<? super BuildEvent> messageConsumer) {
            if (line2 == null || reader == null || messageConsumer == null) {
                return false;
            }
            if (StringsKt.contains$default((CharSequence)line2, (CharSequence)ERROR_LOG_HEADER, (boolean)false, (int)2, null)) {
                return true;
            }
            String string = line2;
            boolean bl = false;
            MatchResult matchResult = ERROR_LOG_REGEX.matchEntire((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString());
            if (matchResult == null) {
                return false;
            }
            MatchResult match2 = matchResult;
            String message2 = (String)match2.getGroupValues().get(1);
            return this.parseErrorIn(message2, reader, messageConsumer);
        }

        private final boolean parseErrorIn(String output, BuildOutputInstantReader reader, Consumer<? super MessageEvent> messageConsumer) {
            try {
                MatchResult matchResult = ERROR_MESSAGE_REGEX.matchEntire((CharSequence)output);
                if (matchResult == null) {
                    return false;
                }
                MatchResult messageMatch = matchResult;
                String msg = (String)messageMatch.getGroupValues().get(1);
                String file2 = (String)messageMatch.getGroupValues().get(2);
                String loc = (String)messageMatch.getGroupValues().get(3);
                MatchResult matchResult2 = LOCATION_REGEX.matchEntire((CharSequence)loc);
                if (matchResult2 == null) {
                    return false;
                }
                MatchResult locMatch = matchResult2;
                String string = (String)locMatch.getGroupValues().get(1);
                boolean bl = false;
                int startLine = Integer.parseInt(string);
                String string2 = (String)locMatch.getGroupValues().get(2);
                boolean bl2 = false;
                int startCol = Integer.parseInt(string2);
                String string3 = (String)locMatch.getGroupValues().get(3);
                boolean bl3 = false;
                int endLine = Integer.parseInt(string3);
                String string4 = (String)locMatch.getGroupValues().get(4);
                boolean bl4 = false;
                int endCol = Integer.parseInt(string4);
                File sourceFile = new File(file2);
                FilePosition filePosition = new FilePosition(sourceFile, startLine, startCol, endLine, endCol);
                messageConsumer.accept((MessageEvent)new FileMessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, "Data Binding compiler", msg, null, filePosition));
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        static {
            Companion = new Companion(null);
            ERROR_LOG_REGEX = new Regex("\\*\\*\\*\\*/ data binding error \\*\\*\\*\\*(.+)\\*\\*\\*\\*\\\\ data binding error \\*\\*\\*\\*");
            ERROR_MESSAGE_REGEX = new Regex("msg:(.+) file:(.+) loc:(.+) ");
            LOCATION_REGEX = new Regex("(\\d+):(\\d+) - (\\d+):(\\d+)");
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/DataBindingOutputParser$LegacyDataBindingOutputParser$Companion;", "", "()V", "ERROR_LOG_HEADER", "", "ERROR_LOG_REGEX", "Lkotlin/text/Regex;", "ERROR_MESSAGE_REGEX", "LOCATION_REGEX", "intellij.android.core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

