/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeTestedTargetVariant;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.build.invoker.GradleRootPathFinder;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleTaskFinder {
    private final GradleRootPathFinder myRootPathFinder;

    @NotNull
    public static GradleTaskFinder getInstance() {
        GradleTaskFinder gradleTaskFinder = (GradleTaskFinder)ApplicationManager.getApplication().getService(GradleTaskFinder.class);
        if (gradleTaskFinder == null) {
            GradleTaskFinder.$$$reportNull$$$0(0);
        }
        return gradleTaskFinder;
    }

    public GradleTaskFinder() {
        this(new GradleRootPathFinder());
    }

    @NonInjectable
    @VisibleForTesting
    GradleTaskFinder(GradleRootPathFinder rootPathFinder) {
        this.myRootPathFinder = rootPathFinder;
    }

    @NotNull
    public ListMultimap<Path, String> findTasksToExecuteForTest(@NotNull Module[] modules, @NotNull Module[] testModules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        if (buildMode == null) {
            GradleTaskFinder.$$$reportNull$$$0(1);
        }
        if (testCompileType == null) {
            GradleTaskFinder.$$$reportNull$$$0(2);
        }
        if (modules == null) {
            GradleTaskFinder.$$$reportNull$$$0(3);
        }
        if (testModules == null) {
            GradleTaskFinder.$$$reportNull$$$0(4);
        }
        ListMultimap<Path, String> allTasks = this.findTasksToExecute(modules, buildMode, TestCompileType.NONE);
        ListMultimap<Path, String> testedModulesTasks = this.findTasksToExecute(testModules, buildMode, testCompileType);
        for (Map.Entry task2 : testedModulesTasks.entries()) {
            if (allTasks.values().contains(task2.getValue())) continue;
            allTasks.put((Object)((Path)task2.getKey()), (Object)((String)task2.getValue()));
        }
        ListMultimap<Path, String> listMultimap = allTasks;
        if (listMultimap == null) {
            GradleTaskFinder.$$$reportNull$$$0(5);
        }
        return listMultimap;
    }

    @NotNull
    public ListMultimap<Path, String> findTasksToExecute(@NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        if (buildMode == null) {
            GradleTaskFinder.$$$reportNull$$$0(6);
        }
        if (testCompileType == null) {
            GradleTaskFinder.$$$reportNull$$$0(7);
        }
        if (modules == null) {
            GradleTaskFinder.$$$reportNull$$$0(8);
        }
        LinkedHashMultimap tasks = LinkedHashMultimap.create();
        if (BuildMode.ASSEMBLE == buildMode && !GradleTaskFinder.canAssembleModules(modules)) {
            for (Module module2 : modules) {
                Path projectRootPath = this.myRootPathFinder.getProjectRootPath(module2);
                tasks.put((Object)projectRootPath, (Object)"assemble");
            }
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create((Multimap)tasks);
            if (arrayListMultimap == null) {
                GradleTaskFinder.$$$reportNull$$$0(9);
            }
            return arrayListMultimap;
        }
        LinkedHashSet<Module> allModules = new LinkedHashSet<Module>();
        for (Object module3 : modules) {
            allModules.addAll(DynamicAppUtils.getModulesToBuild(module3));
        }
        if (testCompileType == TestCompileType.ANDROID_TESTS) {
            for (Object module3 : modules) {
                Module baseAppModule = DynamicAppUtils.getBaseFeature(module3);
                if (baseAppModule == null) continue;
                allModules.add(baseAppModule);
            }
        }
        for (Module module4 : allModules) {
            String modulePath = ExternalSystemModulePropertyManager.getInstance((Module)module4).getLinkedProjectId();
            if (modulePath != null && modulePath.endsWith(":buildSrc")) continue;
            LinkedHashSet<String> moduleTasks = new LinkedHashSet<String>();
            this.findAndAddGradleBuildTasks(module4, buildMode, moduleTasks, testCompileType);
            Path keyPath = this.myRootPathFinder.getProjectRootPath(module4);
            moduleTasks.addAll(tasks.get((Object)keyPath));
            tasks.removeAll((Object)keyPath);
            if (buildMode == BuildMode.REBUILD && !moduleTasks.isEmpty()) {
                tasks.put((Object)keyPath, (Object)"clean");
            }
            tasks.putAll((Object)keyPath, moduleTasks);
        }
        if (tasks.isEmpty()) {
            String format2 = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            GradleTaskFinder.getLogger().info(String.format(format2, modules[0].getProject().getName(), buildMode.name()));
        }
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create((Multimap)tasks);
        if (arrayListMultimap == null) {
            GradleTaskFinder.$$$reportNull$$$0(10);
        }
        return arrayListMultimap;
    }

    private static boolean canAssembleModules(@NotNull Module[] modules) {
        if (modules == null) {
            GradleTaskFinder.$$$reportNull$$$0(11);
        }
        if (modules.length == 0) {
            return false;
        }
        Project project = modules[0].getProject();
        return !GradleSyncState.getInstance(project).lastSyncFailed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findAndAddGradleBuildTasks(@NotNull Module module2, @NotNull BuildMode buildMode, @NotNull Set<String> tasks, @NotNull TestCompileType testCompileType) {
        GradleFacet gradleFacet;
        if (module2 == null) {
            GradleTaskFinder.$$$reportNull$$$0(12);
        }
        if (buildMode == null) {
            GradleTaskFinder.$$$reportNull$$$0(13);
        }
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(14);
        }
        if (testCompileType == null) {
            GradleTaskFinder.$$$reportNull$$$0(15);
        }
        if ((gradleFacet = GradleFacet.getInstance(module2)) == null) {
            return;
        }
        String gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
        if (StringUtil.isEmpty((String)gradlePath)) {
            String msg = String.format("Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.", module2.getName());
            GradleTaskFinder.getLogger().info(msg);
            return;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet != null) {
            AndroidFacetProperties properties2 = androidFacet.getProperties();
            AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
            switch (buildMode) {
                case CLEAN: 
                case SOURCE_GEN: {
                    this.addAfterSyncTasks(tasks, gradlePath, properties2);
                    if (androidModel == null) return;
                    this.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                    return;
                }
                case ASSEMBLE: 
                case REBUILD: {
                    this.addTaskIfSpecified(tasks, gradlePath, properties2.ASSEMBLE_TASK_NAME);
                    if (testCompileType != TestCompileType.ALL && androidModel != null) {
                        for (IdeBaseArtifact artifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                            this.addTaskIfSpecified(tasks, gradlePath, artifact.getAssembleTaskName());
                        }
                    }
                    this.addAssembleTasksForTargetVariants(tasks, module2);
                    return;
                }
                case BUNDLE: {
                    if (androidModel == null || androidModel.getAndroidProject().getProjectType() != 0) return;
                    String taskName = androidModel.getSelectedVariant().getMainArtifact().getBundleTaskName();
                    this.addTaskIfSpecified(tasks, gradlePath, taskName);
                    return;
                }
                case APK_FROM_BUNDLE: {
                    if (androidModel != null && androidModel.getAndroidProject().getProjectType() == 0) {
                        String taskName = androidModel.getSelectedVariant().getMainArtifact().getApkFromBundleTaskName();
                        this.addTaskIfSpecified(tasks, gradlePath, taskName);
                        return;
                    }
                    if (androidModel == null || androidModel.getAndroidProject().getProjectType() != 6 || testCompileType != TestCompileType.ANDROID_TESTS) return;
                    for (IdeBaseArtifact artifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                        this.addTaskIfSpecified(tasks, gradlePath, artifact.getAssembleTaskName());
                    }
                    return;
                }
                default: {
                    this.addAfterSyncTasks(tasks, gradlePath, properties2);
                    if (androidModel != null) {
                        this.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                        for (IdeBaseArtifact artifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                            this.addTaskIfSpecified(tasks, gradlePath, artifact.getCompileTaskName());
                        }
                    }
                    if (testCompileType == TestCompileType.UNIT_TESTS) return;
                    this.addTaskIfSpecified(tasks, gradlePath, properties2.COMPILE_JAVA_TASK_NAME);
                }
            }
            return;
        }
        JavaFacet javaFacet = JavaFacet.getInstance(module2);
        if (javaFacet == null || !((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) return;
        String gradleTaskName = javaFacet.getGradleTaskName(buildMode);
        if (gradleTaskName != null) {
            tasks.add(this.createBuildTask(gradlePath, gradleTaskName));
        }
        if (!TestCompileType.UNIT_TESTS.equals(testCompileType) && !TestCompileType.ALL.equals(testCompileType)) return;
        tasks.add(this.createBuildTask(gradlePath, "testClasses"));
    }

    private void addAssembleTasksForTargetVariants(@NotNull Set<String> tasks, @NotNull Module testOnlyModule) {
        AndroidModuleModel testAndroidModel;
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(16);
        }
        if (testOnlyModule == null) {
            GradleTaskFinder.$$$reportNull$$$0(17);
        }
        if ((testAndroidModel = AndroidModuleModel.get(testOnlyModule)) == null || !testAndroidModel.getFeatures().isTestedTargetVariantsSupported() || testAndroidModel.getAndroidProject().getProjectType() != 2) {
            return;
        }
        for (IdeTestedTargetVariant testedTargetVariant : testAndroidModel.getSelectedVariant().getTestedTargetVariants()) {
            String targetVariantName;
            IdeVariant targetVariant;
            AndroidModuleModel targetAndroidModel;
            String targetProjectGradlePath = testedTargetVariant.getTargetProjectPath();
            Module targetModule = GradleUtil.findModuleByGradlePath(testOnlyModule.getProject(), targetProjectGradlePath);
            if (targetModule == null || (targetAndroidModel = AndroidModuleModel.get(targetModule)) == null || (targetVariant = targetAndroidModel.findVariantByName(targetVariantName = testedTargetVariant.getTargetVariant())) == null) continue;
            this.addTaskIfSpecified(tasks, targetProjectGradlePath, targetVariant.getMainArtifact().getAssembleTaskName());
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(GradleTaskFinder.class);
        if (logger2 == null) {
            GradleTaskFinder.$$$reportNull$$$0(18);
        }
        return logger2;
    }

    private void addAfterSyncTasksForTestArtifacts(@NotNull Set<String> tasks, @NotNull String gradlePath, @NotNull TestCompileType testCompileType, @NotNull AndroidModuleModel androidModel) {
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(19);
        }
        if (gradlePath == null) {
            GradleTaskFinder.$$$reportNull$$$0(20);
        }
        if (testCompileType == null) {
            GradleTaskFinder.$$$reportNull$$$0(21);
        }
        if (androidModel == null) {
            GradleTaskFinder.$$$reportNull$$$0(22);
        }
        IdeVariant variant2 = androidModel.getSelectedVariant();
        Collection<IdeBaseArtifact> testArtifacts = testCompileType.getArtifacts(variant2);
        for (IdeBaseArtifact artifact : testArtifacts) {
            for (String taskName : artifact.getIdeSetupTaskNames()) {
                this.addTaskIfSpecified(tasks, gradlePath, taskName);
            }
        }
    }

    private void addAfterSyncTasks(@NotNull Set<String> tasks, @NotNull String gradlePath, @NotNull AndroidFacetProperties properties2) {
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(23);
        }
        if (gradlePath == null) {
            GradleTaskFinder.$$$reportNull$$$0(24);
        }
        if (properties2 == null) {
            GradleTaskFinder.$$$reportNull$$$0(25);
        }
        for (String taskName : properties2.AFTER_SYNC_TASK_NAMES) {
            this.addTaskIfSpecified(tasks, gradlePath, taskName);
        }
    }

    private void addTaskIfSpecified(@NotNull Set<String> tasks, @NotNull String gradlePath, @Nullable String gradleTaskName) {
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(26);
        }
        if (gradlePath == null) {
            GradleTaskFinder.$$$reportNull$$$0(27);
        }
        if (StringUtil.isNotEmpty((String)gradleTaskName)) {
            String buildTask = this.createBuildTask(gradlePath, gradleTaskName);
            tasks.add(buildTask);
        }
    }

    @NotNull
    public String createBuildTask(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath == null) {
            GradleTaskFinder.$$$reportNull$$$0(28);
        }
        if (taskName == null) {
            GradleTaskFinder.$$$reportNull$$$0(29);
        }
        if (gradleProjectPath.endsWith(":")) {
            String string = gradleProjectPath + taskName;
            if (string == null) {
                GradleTaskFinder.$$$reportNull$$$0(30);
            }
            return string;
        }
        String string = gradleProjectPath + ":" + taskName;
        if (string == null) {
            GradleTaskFinder.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleTaskFinder";
                break;
            }
            case 1: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCompileType";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testModules";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testOnlyModule";
                break;
            }
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectPath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTaskFinder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksToExecuteForTest";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksToExecute";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildTask";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTasksToExecuteForTest";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTasksToExecute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canAssembleModules";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAndAddGradleBuildTasks";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addAssembleTasksForTargetVariants";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addAfterSyncTasksForTestArtifacts";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addAfterSyncTasks";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addTaskIfSpecified";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

