/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.filters.AndroidReRunBuildFilter;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionOutputLinkFilter;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionUtil;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleRootPathFinder;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutorFactory;
import com.android.tools.idea.gradle.project.build.invoker.NativeDebugSessionFinder;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.build.output.BuildOutputParserManager;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.tracer.Trace;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildEventDispatcher;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.execution.filters.Filter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEventDispatcher;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.xdebugger.XDebugSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleBuildInvoker {
    @NotNull
    private final Project myProject;
    private final FileDocumentManager myDocumentManager;
    @NotNull
    private final GradleTasksExecutorFactory myTaskExecutorFactory;
    @NotNull
    private final Set<AfterGradleInvocationTask> myAfterTasks;
    @NotNull
    private final List<String> myOneTimeGradleOptions;
    @NotNull
    private final Multimap<String, String> myLastBuildTasks;
    @NotNull
    private final BuildStopper myBuildStopper;
    @NotNull
    private final NativeDebugSessionFinder myNativeDebugSessionFinder;

    @NotNull
    public static GradleBuildInvoker getInstance(@NotNull Project project) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(0);
        }
        GradleBuildInvoker gradleBuildInvoker = (GradleBuildInvoker)project.getService(GradleBuildInvoker.class);
        if (gradleBuildInvoker == null) {
            GradleBuildInvoker.$$$reportNull$$$0(1);
        }
        return gradleBuildInvoker;
    }

    public GradleBuildInvoker(@NotNull Project project) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(2);
        }
        this(project, null, new GradleTasksExecutorFactory(), new NativeDebugSessionFinder(project));
    }

    @NonInjectable
    @VisibleForTesting
    public GradleBuildInvoker(@NotNull Project project, @NotNull FileDocumentManager documentManager) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(3);
        }
        if (documentManager == null) {
            GradleBuildInvoker.$$$reportNull$$$0(4);
        }
        this(project, documentManager, new GradleTasksExecutorFactory(), new NativeDebugSessionFinder(project));
    }

    @NonInjectable
    @VisibleForTesting
    protected GradleBuildInvoker(@NotNull Project project, @Nullable FileDocumentManager documentManager, @NotNull GradleTasksExecutorFactory tasksExecutorFactory, @NotNull NativeDebugSessionFinder nativeDebugSessionFinder) {
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(5);
        }
        if (tasksExecutorFactory == null) {
            GradleBuildInvoker.$$$reportNull$$$0(6);
        }
        if (nativeDebugSessionFinder == null) {
            GradleBuildInvoker.$$$reportNull$$$0(7);
        }
        this.myAfterTasks = new LinkedHashSet<AfterGradleInvocationTask>();
        this.myOneTimeGradleOptions = new ArrayList<String>();
        this.myLastBuildTasks = ArrayListMultimap.create();
        this.myBuildStopper = new BuildStopper();
        this.myProject = project;
        this.myDocumentManager = documentManager;
        this.myTaskExecutorFactory = tasksExecutorFactory;
        this.myNativeDebugSessionFinder = nativeDebugSessionFinder;
    }

    protected FileDocumentManager getFileDocumentManager() {
        if (this.myDocumentManager != null) {
            return this.myDocumentManager;
        }
        return FileDocumentManager.getInstance();
    }

    public void cleanProject() {
        if (this.stopNativeDebugSessionOrStopBuild()) {
            return;
        }
        this.setProjectBuildMode(BuildMode.CLEAN);
        GradleRootPathFinder pathFinder = new GradleRootPathFinder();
        Set projectRootPaths = Arrays.stream(ModuleManager.getInstance((Project)this.getProject()).getModules()).map(module2 -> pathFinder.getProjectRootPath((Module)module2).toFile()).collect(Collectors.toSet());
        for (File projectRootPath : projectRootPaths) {
            this.executeTasks(projectRootPath, Collections.singletonList("clean"));
        }
    }

    @TestOnly
    public void generateSources() {
        this.generateSources(false, ModuleManager.getInstance((Project)this.myProject).getModules());
    }

    public void generateSourcesForModules(@NotNull Module[] modules) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(8);
        }
        this.generateSources(false, modules);
    }

    private void generateSources(boolean cleanProject, @NotNull Module[] modules) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(9);
        }
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        GradleTaskFinder gradleTaskFinder = GradleTaskFinder.getInstance();
        ListMultimap<Path, String> tasks = gradleTaskFinder.findTasksToExecute(modules, buildMode, TestCompileType.NONE);
        if (cleanProject) {
            if (this.stopNativeDebugSessionOrStopBuild()) {
                return;
            }
            tasks.keys().elementSet().forEach(key -> tasks.get(key).add(0, "clean"));
        }
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
        }
    }

    private boolean stopNativeDebugSessionOrStopBuild() {
        XDebugSession nativeDebugSession = this.myNativeDebugSessionFinder.findNativeDebugSession();
        if (nativeDebugSession != null) {
            Ref yesNoCancelRef = new Ref();
            Application application = ApplicationManager.getApplication();
            application.invokeAndWait(() -> yesNoCancelRef.set((Object)this.promptUserToStopNativeDebugSession()), ModalityState.NON_MODAL);
            int yesNoCancel = (Integer)yesNoCancelRef.get();
            switch (yesNoCancel) {
                case 0: {
                    nativeDebugSession.stop();
                    break;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    @Messages.YesNoCancelResult
    private int promptUserToStopNativeDebugSession() {
        final String propKey = "gradle.project.build.invoker.clean-terminates-debugger";
        String value2 = PropertiesComponent.getInstance().getValue(propKey);
        if (value2 == null) {
            Ref yesNoCancelRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                String message2 = "Cleaning or rebuilding your project while debugging can lead to unexpected behavior.\nYou can choose to either terminate the debugger before cleaning your project or keep debugging while cleaning.\nClicking \"Cancel\" stops Gradle from cleaning or rebuilding your project, and preserves your debug process.";
                MessageDialogBuilder.YesNoCancel dialogBuilder = MessageDialogBuilder.yesNoCancel((String)"Terminate debugging", (String)message2);
                int answer = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)dialogBuilder.yesText("Terminate")).noText("Do not terminate")).cancelText("Cancel").doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                    public void rememberChoice(boolean isSelected, int exitCode) {
                        if (isSelected) {
                            PropertiesComponent.getInstance().setValue(propKey, Boolean.toString(exitCode == 0));
                        }
                    }
                })).show(this.myProject);
                yesNoCancelRef.set((Object)answer);
            }, ModalityState.NON_MODAL);
            int answer = (Integer)yesNoCancelRef.get();
            return answer;
        }
        GradleBuildInvoker.getLogger().debug(propKey + ": " + value2);
        return value2.equals("true") ? 0 : 1;
    }

    @NotNull
    private static String createGenerateSourcesOnlyProperty() {
        String string = AndroidGradleSettings.createProjectProperty((String)"android.injected.generateSourcesOnly", (boolean)true);
        if (string == null) {
            GradleBuildInvoker.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void compileJava(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(11);
        }
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(12);
        }
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, testCompileType);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath));
        }
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(13);
        }
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(14);
        }
        this.assemble(modules, testCompileType, null);
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @Nullable BuildAction<?> buildAction) {
        if (testCompileType == null) {
            GradleBuildInvoker.$$$reportNull$$$0(15);
        }
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(16);
        }
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, testCompileType);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.emptyList(), buildAction);
        }
    }

    public void bundle(@NotNull Module[] modules, @Nullable BuildAction<?> buildAction) {
        if (modules == null) {
            GradleBuildInvoker.$$$reportNull$$$0(17);
        }
        BuildMode buildMode = BuildMode.BUNDLE;
        this.setProjectBuildMode(buildMode);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, TestCompileType.NONE);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath), Collections.emptyList(), buildAction);
        }
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ListMultimap<Path, String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        for (Path rootPath : tasks.keySet()) {
            this.executeTasks(rootPath.toFile(), tasks.get((Object)rootPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildWithTempOptions(@NotNull File buildFilePath, @NotNull List<String> options2) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(18);
        }
        if (options2 == null) {
            GradleBuildInvoker.$$$reportNull$$$0(19);
        }
        this.myOneTimeGradleOptions.addAll(options2);
        try {
            Collection tasks = this.myLastBuildTasks.get((Object)buildFilePath.getPath());
            if (tasks.isEmpty()) {
                this.rebuild();
            } else {
                ArrayList<String> tasksFromLastBuild = new ArrayList<String>(tasks);
                this.executeTasks(buildFilePath, tasksFromLastBuild);
            }
        }
        finally {
            this.myOneTimeGradleOptions.clear();
        }
    }

    private void setProjectBuildMode(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            GradleBuildInvoker.$$$reportNull$$$0(20);
        }
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    @Deprecated
    public void executeTasks(@NotNull List<String> gradleTasks) {
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(21);
        }
        File path2 = Projects.getBaseDirPath((Project)this.myProject);
        this.executeTasks(path2, gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(22);
        }
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(23);
        }
        this.executeTasks(buildFilePath, gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull ListMultimap<Path, String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments, @Nullable BuildAction buildAction) {
        if (tasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(24);
        }
        if (commandLineArguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(25);
        }
        if (buildMode != null) {
            this.setProjectBuildMode(buildMode);
        }
        tasks.keys().elementSet().forEach(path2 -> this.executeTasks(path2.toFile(), tasks.get(path2), commandLineArguments, buildAction));
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(26);
        }
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(27);
        }
        if (commandLineArguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(28);
        }
        this.executeTasks(buildFilePath, gradleTasks, commandLineArguments, null);
    }

    public void executeTasks(@NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments, @Nullable BuildAction buildAction) {
        if (buildFilePath == null) {
            GradleBuildInvoker.$$$reportNull$$$0(29);
        }
        if (gradleTasks == null) {
            GradleBuildInvoker.$$$reportNull$$$0(30);
        }
        if (commandLineArguments == null) {
            GradleBuildInvoker.$$$reportNull$$$0(31);
        }
        ArrayList<String> jvmArguments = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            File androidHomePath;
            LocalProperties localProperties;
            try {
                localProperties = new LocalProperties(this.myProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (localProperties.getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                jvmArguments.add(AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHomePath.getPath()));
            }
        }
        Trace.addVmArgs(jvmArguments);
        Request request = new Request(this.myProject, buildFilePath, gradleTasks);
        ExternalSystemTaskNotificationListener buildTaskListener = this.createBuildTaskListener(request, "Build");
        request.setJvmArguments(jvmArguments).setCommandLineArguments(commandLineArguments).setBuildAction(buildAction).setTaskListener(buildTaskListener);
        this.executeTasks(request);
    }

    @NotNull
    public ExternalSystemTaskNotificationListener createBuildTaskListener(@NotNull Request request, String executionName) {
        if (request == null) {
            GradleBuildInvoker.$$$reportNull$$$0(32);
        }
        BuildViewManager buildViewManager = (BuildViewManager)this.myProject.getService(BuildViewManager.class);
        ExternalSystemEventDispatcher eventDispatcher = new ExternalSystemEventDispatcher(request.myTaskId, (BuildProgressListener)buildViewManager);
        try {
            return new ExternalSystemTaskNotificationListenerAdapter((BuildEventDispatcher)eventDispatcher, request, buildViewManager, executionName){
                @NotNull
                private BuildEventDispatcher myBuildEventDispatcher;
                private boolean myBuildFailed;
                final /* synthetic */ BuildEventDispatcher val$eventDispatcher;
                final /* synthetic */ Request val$request;
                final /* synthetic */ BuildViewManager val$buildViewManager;
                final /* synthetic */ String val$executionName;
                {
                    this.val$eventDispatcher = buildEventDispatcher;
                    this.val$request = request;
                    this.val$buildViewManager = buildViewManager;
                    this.val$executionName = string;
                    this.myBuildEventDispatcher = this.val$eventDispatcher;
                    this.myBuildFailed = false;
                }

                public void onStart(final @NotNull ExternalSystemTaskId id, String workingDir) {
                    if (id == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    AnAction restartAction = new AnAction(){

                        public void update(@NotNull AnActionEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            e.getPresentation().setEnabled(!GradleBuildInvoker.this.myBuildStopper.contains(id));
                        }

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            myBuildFailed = false;
                            myBuildEventDispatcher.close();
                            myBuildEventDispatcher = new ExternalSystemEventDispatcher(val$request.myTaskId, (BuildProgressListener)val$buildViewManager);
                            GradleBuildInvoker.this.executeTasks(val$request);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = "e";
                            objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$2$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "update";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "actionPerformed";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    this.myBuildFailed = false;
                    Presentation presentation = restartAction.getTemplatePresentation();
                    presentation.setText("Restart");
                    presentation.setDescription("Restart");
                    presentation.setIcon(AllIcons.Actions.Compile);
                    long eventTime = System.currentTimeMillis();
                    StartBuildEventImpl event = new StartBuildEventImpl((BuildDescriptor)new DefaultBuildDescriptor((Object)id, this.val$executionName, workingDir, eventTime), "running...");
                    event.withRestartAction(restartAction).withExecutionFilter((Filter)new AndroidReRunBuildFilter(workingDir));
                    if (BuildAttributionUtil.isBuildAttributionEnabledForProject(GradleBuildInvoker.this.myProject)) {
                        event.withExecutionFilter((Filter)new BuildAttributionOutputLinkFilter());
                    }
                    this.myBuildEventDispatcher.onEvent((Object)id, (BuildEvent)event);
                }

                public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (event instanceof ExternalSystemBuildEvent) {
                        BuildEvent buildEvent = ((ExternalSystemBuildEvent)event).getBuildEvent();
                        this.myBuildEventDispatcher.onEvent((Object)event.getId(), buildEvent);
                    } else if (event instanceof ExternalSystemTaskExecutionEvent) {
                        BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)((ExternalSystemTaskExecutionEvent)event));
                        this.myBuildEventDispatcher.onEvent((Object)event.getId(), buildEvent);
                    }
                }

                public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text2, boolean stdOut) {
                    if (id == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (text2 == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    this.myBuildEventDispatcher.setStdOut(stdOut);
                    this.myBuildEventDispatcher.append((CharSequence)text2);
                }

                public void onEnd(@NotNull ExternalSystemTaskId id) {
                    if (id == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    CountDownLatch eventDispatcherFinished = new CountDownLatch(1);
                    this.myBuildEventDispatcher.invokeOnCompletion(t -> {
                        if (this.myBuildFailed) {
                            ((BuildOutputParserManager)GradleBuildInvoker.this.myProject.getService(BuildOutputParserManager.class)).sendBuildFailureMetrics();
                        }
                        eventDispatcherFinished.countDown();
                    });
                    this.myBuildEventDispatcher.close();
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        try {
                            eventDispatcherFinished.await(10L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException("Timeout waiting for event dispatcher to finish.", ex);
                        }
                    }
                }

                public void onSuccess(@NotNull ExternalSystemTaskId id) {
                    if (id == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    this.addBuildAttributionLinkToTheOutput(id);
                    FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "finished", (EventResult)new SuccessResultImpl());
                    this.myBuildEventDispatcher.onEvent((Object)id, (BuildEvent)event);
                }

                private void addBuildAttributionLinkToTheOutput(@NotNull ExternalSystemTaskId id) {
                    if (id == null) {
                        2.$$$reportNull$$$0(6);
                    }
                    if (BuildAttributionUtil.isBuildAttributionEnabledForProject(GradleBuildInvoker.this.myProject)) {
                        String buildAttributionTabLinkLine = BuildAttributionUtil.buildOutputLine();
                        this.onTaskOutput(id, "\n" + buildAttributionTabLinkLine, true);
                    }
                }

                public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                    if (id == null) {
                        2.$$$reportNull$$$0(7);
                    }
                    if (e == null) {
                        2.$$$reportNull$$$0(8);
                    }
                    String title = this.val$executionName + " failed";
                    DataContext dataContext = BuildConsoleUtils.getDataContext((Object)id, (AbstractViewManager)this.val$buildViewManager);
                    FailureResultImpl failureResult = ExternalSystemUtil.createFailureResult((String)title, (Exception)e, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (Project)GradleBuildInvoker.this.myProject, (DataContext)dataContext);
                    this.myBuildEventDispatcher.onEvent((Object)id, (BuildEvent)new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "failed", (EventResult)failureResult));
                }

                public void onCancel(@NotNull ExternalSystemTaskId id) {
                    if (id == null) {
                        2.$$$reportNull$$$0(9);
                    }
                    super.onCancel(id);
                    FinishBuildEventImpl event = new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), "cancelled", (EventResult)new SkippedResultImpl());
                    this.myBuildEventDispatcher.onEvent((Object)id, (BuildEvent)event);
                    this.myBuildEventDispatcher.close();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "id";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                        case 8: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onStart";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onStatusChange";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTaskOutput";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onEnd";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccess";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "addBuildAttributionLinkToTheOutput";
                            break;
                        }
                        case 7: 
                        case 8: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onFailure";
                            break;
                        }
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCancel";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        catch (Exception exception) {
            eventDispatcher.close();
            throw exception;
        }
    }

    public void executeTasks(@NotNull Request request) {
        if (request == null) {
            GradleBuildInvoker.$$$reportNull$$$0(33);
        }
        String buildFilePath = request.getBuildFilePath().getPath();
        this.myLastBuildTasks.removeAll((Object)buildFilePath);
        List<String> gradleTasks = request.getGradleTasks();
        this.myLastBuildTasks.putAll((Object)buildFilePath, gradleTasks);
        GradleBuildInvoker.getLogger().info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        GradleTasksExecutor executor = this.myTaskExecutorFactory.create(request, this.myBuildStopper);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.getFileDocumentManager().saveAllDocuments();
            executor.queue();
        } else if (request.isWaitForCompletion()) {
            ApplicationManager.getApplication().invokeAndWait(() -> ((FileDocumentManager)this.getFileDocumentManager()).saveAllDocuments());
            executor.queueAndWaitForCompletion();
        } else {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                this.getFileDocumentManager().saveAllDocuments();
                executor.queue();
            });
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(GradleBuildInvoker.class);
        if (logger2 == null) {
            GradleBuildInvoker.$$$reportNull$$$0(34);
        }
        return logger2;
    }

    public boolean stopBuild(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            GradleBuildInvoker.$$$reportNull$$$0(35);
        }
        if (this.myBuildStopper.contains(id)) {
            this.myBuildStopper.attemptToStopBuild(id, null);
            return true;
        }
        return false;
    }

    public void add(@NotNull AfterGradleInvocationTask task2) {
        if (task2 == null) {
            GradleBuildInvoker.$$$reportNull$$$0(36);
        }
        this.myAfterTasks.add(task2);
    }

    @VisibleForTesting
    @NotNull
    protected AfterGradleInvocationTask[] getAfterInvocationTasks() {
        AfterGradleInvocationTask[] afterGradleInvocationTaskArray = this.myAfterTasks.toArray(new AfterGradleInvocationTask[0]);
        if (afterGradleInvocationTaskArray == null) {
            GradleBuildInvoker.$$$reportNull$$$0(37);
        }
        return afterGradleInvocationTaskArray;
    }

    public void remove(@NotNull AfterGradleInvocationTask task2) {
        if (task2 == null) {
            GradleBuildInvoker.$$$reportNull$$$0(38);
        }
        this.myAfterTasks.remove(task2);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleBuildInvoker.$$$reportNull$$$0(39);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: 
            case 34: 
            case 37: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: 
            case 34: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 34: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksExecutorFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeDebugSessionFinder";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCompileType";
                break;
            }
            case 18: 
            case 22: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFilePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
            case 21: 
            case 23: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleTasks";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerateSourcesOnlyProperty";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterInvocationTasks";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 10: 
            case 34: 
            case 37: 
            case 39: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateSourcesForModules";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateSources";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compileJava";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "assemble";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "bundle";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "rebuildWithTempOptions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setProjectBuildMode";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "executeTasks";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTaskListener";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "stopBuild";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: 
            case 34: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        @NotNull
        private final Project myProject;
        @NotNull
        private final File myBuildFilePath;
        @NotNull
        private final List<String> myGradleTasks;
        @NotNull
        private final List<String> myJvmArguments;
        @NotNull
        private final List<String> myCommandLineArguments;
        @NotNull
        private final Map<String, String> myEnv;
        private boolean myPassParentEnvs;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @Nullable
        private ExternalSystemTaskNotificationListener myTaskListener;
        @Nullable
        private BuildAction myBuildAction;
        private boolean myWaitForCompletion;

        public Request(@NotNull Project project, @NotNull File buildFilePath, String ... gradleTasks) {
            if (project == null) {
                Request.$$$reportNull$$$0(0);
            }
            if (buildFilePath == null) {
                Request.$$$reportNull$$$0(1);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(2);
            }
            this(project, buildFilePath, Arrays.asList(gradleTasks));
        }

        public Request(@NotNull Project project, @NotNull File buildFilePath, @NotNull List<String> gradleTasks) {
            if (project == null) {
                Request.$$$reportNull$$$0(3);
            }
            if (buildFilePath == null) {
                Request.$$$reportNull$$$0(4);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(5);
            }
            this(project, buildFilePath, gradleTasks, ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project));
        }

        public Request(@NotNull Project project, @NotNull File buildFilePath, @NotNull List<String> gradleTasks, @NotNull ExternalSystemTaskId taskId) {
            if (project == null) {
                Request.$$$reportNull$$$0(6);
            }
            if (buildFilePath == null) {
                Request.$$$reportNull$$$0(7);
            }
            if (gradleTasks == null) {
                Request.$$$reportNull$$$0(8);
            }
            if (taskId == null) {
                Request.$$$reportNull$$$0(9);
            }
            this.myPassParentEnvs = true;
            this.myProject = project;
            this.myBuildFilePath = buildFilePath;
            this.myGradleTasks = new ArrayList<String>(gradleTasks);
            this.myJvmArguments = new ArrayList<String>();
            this.myCommandLineArguments = new ArrayList<String>();
            this.myTaskId = taskId;
            this.myEnv = new LinkedHashMap<String, String>();
        }

        @NotNull
        Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                Request.$$$reportNull$$$0(10);
            }
            return project;
        }

        @NotNull
        List<String> getGradleTasks() {
            List<String> list = this.myGradleTasks;
            if (list == null) {
                Request.$$$reportNull$$$0(11);
            }
            return list;
        }

        @NotNull
        List<String> getJvmArguments() {
            List<String> list = this.myJvmArguments;
            if (list == null) {
                Request.$$$reportNull$$$0(12);
            }
            return list;
        }

        @NotNull
        public Request setJvmArguments(@NotNull List<String> jvmArguments) {
            if (jvmArguments == null) {
                Request.$$$reportNull$$$0(13);
            }
            this.myJvmArguments.clear();
            this.myJvmArguments.addAll(jvmArguments);
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(14);
            }
            return request;
        }

        @NotNull
        List<String> getCommandLineArguments() {
            List<String> list = this.myCommandLineArguments;
            if (list == null) {
                Request.$$$reportNull$$$0(15);
            }
            return list;
        }

        @NotNull
        public Request setCommandLineArguments(@NotNull List<String> commandLineArguments) {
            if (commandLineArguments == null) {
                Request.$$$reportNull$$$0(16);
            }
            this.myCommandLineArguments.clear();
            this.myCommandLineArguments.addAll(commandLineArguments);
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(17);
            }
            return request;
        }

        public Request withEnvironmentVariables(Map<String, String> envs) {
            this.myEnv.putAll(envs);
            return this;
        }

        public Map<String, String> getEnv() {
            return Collections.unmodifiableMap(this.myEnv);
        }

        public Request passParentEnvs(boolean passParentEnvs) {
            this.myPassParentEnvs = passParentEnvs;
            return this;
        }

        public boolean isPassParentEnvs() {
            return this.myPassParentEnvs;
        }

        @Nullable
        public ExternalSystemTaskNotificationListener getTaskListener() {
            return this.myTaskListener;
        }

        @NotNull
        public Request setTaskListener(@Nullable ExternalSystemTaskNotificationListener taskListener) {
            this.myTaskListener = taskListener;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(18);
            }
            return request;
        }

        @NotNull
        ExternalSystemTaskId getTaskId() {
            ExternalSystemTaskId externalSystemTaskId = this.myTaskId;
            if (externalSystemTaskId == null) {
                Request.$$$reportNull$$$0(19);
            }
            return externalSystemTaskId;
        }

        @NotNull
        File getBuildFilePath() {
            File file2 = this.myBuildFilePath;
            if (file2 == null) {
                Request.$$$reportNull$$$0(20);
            }
            return file2;
        }

        boolean isWaitForCompletion() {
            return this.myWaitForCompletion;
        }

        @NotNull
        public Request waitForCompletion() {
            this.myWaitForCompletion = true;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(21);
            }
            return request;
        }

        @Nullable
        public BuildAction getBuildAction() {
            return this.myBuildAction;
        }

        @NotNull
        public Request setBuildAction(@Nullable BuildAction buildAction) {
            this.myBuildAction = buildAction;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(22);
            }
            return request;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.myBuildFilePath, that.myBuildFilePath) && Objects.equals(this.myGradleTasks, that.myGradleTasks) && Objects.equals(this.myJvmArguments, that.myJvmArguments) && Objects.equals(this.myCommandLineArguments, that.myCommandLineArguments);
        }

        public int hashCode() {
            return Objects.hash(this.myBuildFilePath, this.myGradleTasks, this.myJvmArguments, this.myCommandLineArguments);
        }

        public String toString() {
            return "RequestSettings{myBuildFilePath=" + this.myBuildFilePath + ", myGradleTasks=" + this.myGradleTasks + ", myJvmArguments=" + this.myJvmArguments + ", myCommandLineArguments=" + this.myCommandLineArguments + ", myBuildAction=" + this.myBuildAction + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildFilePath";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleTasks";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jvmArguments";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLineArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleTasks";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJvmArguments";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setJvmArguments";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandLineArguments";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCommandLineArguments";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTaskListener";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTaskId";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildFilePath";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "waitForCompletion";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setBuildAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setJvmArguments";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "setCommandLineArguments";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface AfterGradleInvocationTask {
        public void execute(@NotNull GradleInvocationResult var1);
    }
}

