/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.compiler;

import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.actionsOnSave.ActionOnSaveBackedByOwnConfigurable;
import com.intellij.ide.actionsOnSave.ActionOnSaveComment;
import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfo;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfoProvider;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleCompilerSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final String CONFIGURABLE_ID = "gradle.compiler";
    private final CompilerWorkspaceConfiguration myCompilerWorkspaceConfiguration;
    private final CompilerConfiguration myCompilerConfiguration;
    private final AndroidGradleBuildConfiguration myBuildConfiguration;
    private JPanel myContentPanel;
    private JCheckBox myParallelBuildCheckBox;
    private HyperlinkLabel myParallelBuildDocHyperlinkLabel;
    private JCheckBox myAutoMakeCheckBox;
    private RawCommandLineEditor myCommandLineOptionsEditor;
    private HyperlinkLabel myCommandLineOptionsDocHyperlinkLabel;
    private final String myDisplayName;

    public GradleCompilerSettingsConfigurable(@NotNull Project project, @NotNull String displayName) {
        if (project == null) {
            GradleCompilerSettingsConfigurable.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            GradleCompilerSettingsConfigurable.$$$reportNull$$$0(1);
        }
        this.myDisplayName = displayName;
        this.$$$setupUI$$$();
        this.myCompilerWorkspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)project);
        this.myCompilerConfiguration = CompilerConfiguration.getInstance((Project)project);
        this.myBuildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
    }

    @NotNull
    public String getId() {
        return CONFIGURABLE_ID;
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.projectsettings.compiler.gradle";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        return this.myCompilerConfiguration.isParallelCompilationEnabled() != this.isParallelBuildsEnabled() || this.myCompilerWorkspaceConfiguration.MAKE_PROJECT_ON_SAVE != this.isAutoMakeEnabled() || !Objects.equal((Object)this.getCommandLineOptions(), (Object)this.myBuildConfiguration.COMMAND_LINE_OPTIONS);
    }

    public void apply() {
        if (this.myCompilerConfiguration.isParallelCompilationEnabled() != this.isParallelBuildsEnabled()) {
            this.myCompilerConfiguration.setParallelCompilationEnabled(this.isParallelBuildsEnabled());
        }
        this.myCompilerWorkspaceConfiguration.MAKE_PROJECT_ON_SAVE = this.isAutoMakeEnabled();
        this.myBuildConfiguration.COMMAND_LINE_OPTIONS = this.getCommandLineOptions();
    }

    private boolean isParallelBuildsEnabled() {
        return this.myParallelBuildCheckBox.isSelected();
    }

    private boolean isAutoMakeEnabled() {
        return this.myAutoMakeCheckBox.isSelected();
    }

    @NotNull
    private String getCommandLineOptions() {
        String string = this.myCommandLineOptionsEditor.getText().trim();
        if (string == null) {
            GradleCompilerSettingsConfigurable.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void reset() {
        this.myParallelBuildCheckBox.setSelected(this.myCompilerConfiguration.isParallelCompilationEnabled());
        this.myAutoMakeCheckBox.setSelected(this.myCompilerWorkspaceConfiguration.MAKE_PROJECT_ON_SAVE);
        this.myAutoMakeCheckBox.setText("Make project automatically (only works while not running / debugging" + (PowerSaveMode.isEnabled() ? ", disabled in Power Save mode" : "") + ")");
        String commandLineOptions = Strings.nullToEmpty((String)this.myBuildConfiguration.COMMAND_LINE_OPTIONS);
        this.myCommandLineOptionsEditor.setText(commandLineOptions);
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.myParallelBuildDocHyperlinkLabel = GradleCompilerSettingsConfigurable.createHyperlinkLabel("This option is in \"incubation\" and should only be used with ", "decoupled projects", ".", "http://www.gradle.org/docs/current/userguide/multi_project_builds.html#sec:decoupled_projects");
        this.myCommandLineOptionsDocHyperlinkLabel = GradleCompilerSettingsConfigurable.createHyperlinkLabel("Example: --stacktrace --debug (for more information, please read Gradle's ", "documentation", ".)", "http://www.gradle.org/docs/current/userguide/gradle_command_line.html");
        this.myCommandLineOptionsEditor = new RawCommandLineEditor();
        this.myCommandLineOptionsEditor.setDialogCaption("Command-line Options");
    }

    @NotNull
    private static HyperlinkLabel createHyperlinkLabel(@NotNull String beforeLinkText, @NotNull String linkText, @NotNull String afterLinkText, @NotNull String target) {
        if (beforeLinkText == null) {
            GradleCompilerSettingsConfigurable.$$$reportNull$$$0(3);
        }
        if (linkText == null) {
            GradleCompilerSettingsConfigurable.$$$reportNull$$$0(4);
        }
        if (afterLinkText == null) {
            GradleCompilerSettingsConfigurable.$$$reportNull$$$0(5);
        }
        if (target == null) {
            GradleCompilerSettingsConfigurable.$$$reportNull$$$0(6);
        }
        HyperlinkLabel label = new HyperlinkLabel();
        label.setHyperlinkText(beforeLinkText, linkText, afterLinkText);
        label.setHyperlinkTarget(target);
        HyperlinkLabel hyperlinkLabel = label;
        if (hyperlinkLabel == null) {
            GradleCompilerSettingsConfigurable.$$$reportNull$$$0(7);
        }
        return hyperlinkLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/compiler/GradleCompilerSettingsConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeLinkText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterLinkText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/compiler/GradleCompilerSettingsConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineOptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createHyperlinkLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createHyperlinkLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myParallelBuildCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Compile independent modules in parallel (may require larger heap size)");
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myParallelBuildDocHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(3, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html><br></html>");
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><b>Note:</b> These settings are used for <b>compiling</b> Gradle-based Android projects.</html>");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("<html><br></html>");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        this.myAutoMakeCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Make project automatically (only works while not running / debugging)");
        jPanel.add((Component)jCheckBox, new GridConstraints(8, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("<html><br></html>");
        jPanel.add((Component)jBLabel4, new GridConstraints(9, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("<html><br></html>");
        jPanel.add((Component)jBLabel5, new GridConstraints(7, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Command-line Options:");
        jPanel.add((Component)jBLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myCommandLineOptionsEditor;
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(5, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel2 = this.myCommandLineOptionsDocHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel2, new GridConstraints(6, 0, 1, 3, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static class BuildOnSaveInfo
    extends ActionOnSaveBackedByOwnConfigurable<GradleCompilerSettingsConfigurable> {
        private BuildOnSaveInfo(@NotNull ActionOnSaveContext context) {
            if (context == null) {
                BuildOnSaveInfo.$$$reportNull$$$0(0);
            }
            super(context, GradleCompilerSettingsConfigurable.CONFIGURABLE_ID, GradleCompilerSettingsConfigurable.class);
        }

        @NotNull
        public String getActionOnSaveName() {
            String string = JavaCompilerBundle.message((String)"settings.actions.on.save.page.build.project.on.save.checkbox", (Object[])new Object[0]);
            if (string == null) {
                BuildOnSaveInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        protected ActionOnSaveComment getCommentAccordingToStoredState() {
            return ActionOnSaveComment.info((String)JavaCompilerBundle.message((String)"settings.actions.on.save.page.build.project.on.save.checkbox.comment", (Object[])new Object[0]));
        }

        @Nullable
        protected ActionOnSaveComment getCommentAccordingToUiState(@NotNull GradleCompilerSettingsConfigurable configurable) {
            if (configurable == null) {
                BuildOnSaveInfo.$$$reportNull$$$0(2);
            }
            return ActionOnSaveComment.info((String)JavaCompilerBundle.message((String)"settings.actions.on.save.page.build.project.on.save.checkbox.comment", (Object[])new Object[0]));
        }

        protected boolean isActionOnSaveEnabledAccordingToStoredState() {
            return CompilerWorkspaceConfiguration.getInstance((Project)this.getProject()).MAKE_PROJECT_ON_SAVE;
        }

        protected boolean isActionOnSaveEnabledAccordingToUiState(@NotNull GradleCompilerSettingsConfigurable configurable) {
            if (configurable == null) {
                BuildOnSaveInfo.$$$reportNull$$$0(3);
            }
            return configurable.myAutoMakeCheckBox.isSelected();
        }

        protected void setActionOnSaveEnabled(@NotNull GradleCompilerSettingsConfigurable configurable, boolean enabled) {
            if (configurable == null) {
                BuildOnSaveInfo.$$$reportNull$$$0(4);
            }
            configurable.myAutoMakeCheckBox.setSelected(enabled);
        }

        @NotNull
        public List<? extends ActionLink> getActionLinks() {
            String linkText = JavaCompilerBundle.message((String)"settings.actions.on.save.page.compiler.settings.link", (Object[])new Object[0]);
            List<ActionLink> list = List.of(this.createGoToPageInSettingsLink(linkText, GradleCompilerSettingsConfigurable.CONFIGURABLE_ID));
            if (list == null) {
                BuildOnSaveInfo.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        protected String getActivatedOnDefaultText() {
            String string = BuildOnSaveInfo.getAnySaveAndExternalChangeText();
            if (string == null) {
                BuildOnSaveInfo.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/build/compiler/GradleCompilerSettingsConfigurable$BuildOnSaveInfo";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/compiler/GradleCompilerSettingsConfigurable$BuildOnSaveInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionOnSaveName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionLinks";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActivatedOnDefaultText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommentAccordingToUiState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isActionOnSaveEnabledAccordingToUiState";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setActionOnSaveEnabled";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BuildOnSaveInfoProvider
    extends ActionOnSaveInfoProvider {
        @NotNull
        protected Collection<? extends ActionOnSaveInfo> getActionOnSaveInfos(@NotNull ActionOnSaveContext context) {
            if (context == null) {
                BuildOnSaveInfoProvider.$$$reportNull$$$0(0);
            }
            if (context.getSettings().find(GradleCompilerSettingsConfigurable.CONFIGURABLE_ID) == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    BuildOnSaveInfoProvider.$$$reportNull$$$0(1);
                }
                return list;
            }
            List<Object> list = AndroidProjectInfo.getInstance(context.getProject()).requiresAndroidModel() ? List.of(new BuildOnSaveInfo(context)) : Collections.emptyList();
            if (list == null) {
                BuildOnSaveInfoProvider.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/build/compiler/GradleCompilerSettingsConfigurable$BuildOnSaveInfoProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/build/compiler/GradleCompilerSettingsConfigurable$BuildOnSaveInfoProvider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionOnSaveInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionOnSaveInfos";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

