/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.ide.common.blame.Message;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class PostProjectBuildTasksExecutor {
    private static final Key<Long> PROJECT_LAST_BUILD_TIMESTAMP_KEY = Key.create((String)"android.gradle.project.last.build.timestamp");
    @NotNull
    private final Project myProject;

    @NotNull
    public static PostProjectBuildTasksExecutor getInstance(@NotNull Project project) {
        if (project == null) {
            PostProjectBuildTasksExecutor.$$$reportNull$$$0(0);
        }
        PostProjectBuildTasksExecutor postProjectBuildTasksExecutor = (PostProjectBuildTasksExecutor)project.getService(PostProjectBuildTasksExecutor.class);
        if (postProjectBuildTasksExecutor == null) {
            PostProjectBuildTasksExecutor.$$$reportNull$$$0(1);
        }
        return postProjectBuildTasksExecutor;
    }

    public PostProjectBuildTasksExecutor(@NotNull Project project) {
        if (project == null) {
            PostProjectBuildTasksExecutor.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    public void onBuildCompletion(@NotNull CompileContext context) {
        if (context == null) {
            PostProjectBuildTasksExecutor.$$$reportNull$$$0(3);
        }
        Object errors2 = Collections.emptyIterator();
        CompilerMessage[] errorMessages = context.getMessages(CompilerMessageCategory.ERROR);
        if (errorMessages.length > 0) {
            errors2 = new CompilerMessageIterator(errorMessages);
        }
        this.onBuildCompletion((Iterator<String>)errors2, errorMessages.length);
    }

    @Nullable
    public Long getLastBuildTimestamp() {
        return (Long)this.myProject.getUserData(PROJECT_LAST_BUILD_TIMESTAMP_KEY);
    }

    public void onBuildCompletion(@NotNull GradleInvocationResult result2) {
        if (result2 == null) {
            PostProjectBuildTasksExecutor.$$$reportNull$$$0(4);
        }
        Object errors2 = Collections.emptyIterator();
        List<Message> errorMessages = result2.getCompilerMessages(Message.Kind.ERROR);
        if (!errorMessages.isEmpty()) {
            errors2 = new MessageIterator(errorMessages);
        }
        this.onBuildCompletion((Iterator<String>)errors2, errorMessages.size());
    }

    @VisibleForTesting
    void onBuildCompletion(Iterator<String> errorMessages, int errorCount) {
        if (AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel()) {
            if (GradleProjects.isOfflineBuildModeEnabled(this.myProject)) {
                while (errorMessages.hasNext()) {
                    String error = errorMessages.next();
                    if (error == null || !PostProjectBuildTasksExecutor.unresolvedDependenciesFound(error)) continue;
                    this.notifyUnresolvedDependenciesInOfflineMode();
                    break;
                }
            }
            BuildSettings buildSettings = BuildSettings.getInstance(this.myProject);
            BuildMode buildMode = buildSettings.getBuildMode();
            String runConfigurationTypeId = buildSettings.getRunConfigurationTypeId();
            buildSettings.clear();
            this.refreshProject(runConfigurationTypeId == null);
            this.myProject.putUserData(PROJECT_LAST_BUILD_TIMESTAMP_KEY, (Object)System.currentTimeMillis());
            if (runConfigurationTypeId != null) {
                return;
            }
            if (this.isSyncNeeded(buildMode, errorCount)) {
                this.requestSyncAfterBuild(GradleSyncStats.Trigger.TRIGGER_BUILD_SYNC_NEEDED_AFTER_BUILD);
            }
            if (GradleProjects.isSyncRequestedDuringBuild(this.myProject)) {
                GradleProjects.setSyncRequestedDuringBuild(this.myProject, null);
                this.requestSyncAfterBuild(GradleSyncStats.Trigger.TRIGGER_USER_REQUEST_WHILE_BUILDING);
            }
        }
    }

    private void requestSyncAfterBuild(GradleSyncStats.Trigger trigger) {
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(trigger);
        PostProjectBuildTasksExecutor.runWhenEventsFinished(() -> {
            if (!this.myProject.isDisposed()) {
                GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request);
            }
        });
    }

    private boolean isSyncNeeded(@Nullable BuildMode buildMode, int errorCount) {
        if (errorCount != 0) {
            return false;
        }
        if (BuildMode.DEFAULT_BUILD_MODE.equals((Object)buildMode) && GradleSyncState.getInstance(this.myProject).lastSyncFailed()) {
            return true;
        }
        return !BuildMode.SOURCE_GEN.equals((Object)buildMode) && GradleSyncState.getInstance(this.myProject).isSyncNeeded().equals((Object)ThreeState.YES);
    }

    private static void runWhenEventsFinished(@NotNull Runnable task2) {
        Application application;
        if (task2 == null) {
            PostProjectBuildTasksExecutor.$$$reportNull$$$0(5);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            application.invokeAndWait(task2);
        } else {
            application.invokeLater(task2);
        }
    }

    private static boolean unresolvedDependenciesFound(@NotNull String errorMessage) {
        if (errorMessage == null) {
            PostProjectBuildTasksExecutor.$$$reportNull$$$0(6);
        }
        return errorMessage.contains("Could not resolve all dependencies");
    }

    private void notifyUnresolvedDependenciesInOfflineMode() {
        NotificationHyperlink disableOfflineModeHyperlink = new NotificationHyperlink("disable.gradle.offline.mode", "Disable offline mode"){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleSettings.getInstance((Project)PostProjectBuildTasksExecutor.this.myProject).setOfflineWork(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/PostProjectBuildTasksExecutor$1", "execute"));
            }
        };
        String title = "Unresolved Dependencies";
        String text2 = "Unresolved dependencies detected while building project in offline mode. Please disable offline mode and try again.";
        AndroidNotification.getInstance(this.myProject).showBalloon(title, text2, NotificationType.ERROR, disableOfflineModeHyperlink);
    }

    private void refreshProject(boolean asynchronous) {
        VirtualFile rootDir;
        String projectPath = this.myProject.getBasePath();
        if (projectPath != null && (rootDir = LocalFileSystem.getInstance().findFileByPath(projectPath)) != null && rootDir.isDirectory()) {
            rootDir.refresh(asynchronous, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/PostProjectBuildTasksExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/PostProjectBuildTasksExecutor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onBuildCompletion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runWhenEventsFinished";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unresolvedDependenciesFound";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MessageIterator
    extends AbstractIterator<String> {
        private final Iterator<Message> myIterator;

        MessageIterator(@NotNull Collection<Message> compilerMessages) {
            if (compilerMessages == null) {
                MessageIterator.$$$reportNull$$$0(0);
            }
            this.myIterator = compilerMessages.iterator();
        }

        @Nullable
        protected String computeNext() {
            if (!this.myIterator.hasNext()) {
                return (String)this.endOfData();
            }
            Message msg = this.myIterator.next();
            return msg != null ? msg.getText() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerMessages", "com/android/tools/idea/gradle/project/build/PostProjectBuildTasksExecutor$MessageIterator", "<init>"));
        }
    }

    private static class CompilerMessageIterator
    extends AbstractIterator<String> {
        @NotNull
        private final CompilerMessage[] myErrors;
        private int counter;

        CompilerMessageIterator(@NotNull CompilerMessage[] errors2) {
            if (errors2 == null) {
                CompilerMessageIterator.$$$reportNull$$$0(0);
            }
            this.myErrors = errors2;
        }

        @Nullable
        protected String computeNext() {
            if (this.counter >= this.myErrors.length) {
                return (String)this.endOfData();
            }
            return this.myErrors[this.counter++].getMessage();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/android/tools/idea/gradle/project/build/PostProjectBuildTasksExecutor$CompilerMessageIterator", "<init>"));
        }
    }
}

