/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.BuildSummary;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleBuildState {
    @VisibleForTesting
    static final Topic<GradleBuildListener> GRADLE_BUILD_TOPIC = new Topic("Gradle build", GradleBuildListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final Object myLock;
    @Nullable
    private BuildContext myCurrentContext;
    @Nullable
    private BuildSummary mySummary;

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleBuildListener listener2) {
        if (project == null) {
            GradleBuildState.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            GradleBuildState.$$$reportNull$$$0(1);
        }
        return GradleBuildState.subscribe(project, listener2, (Disposable)project);
    }

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleBuildListener listener2, @NotNull Disposable parentDisposable) {
        if (project == null) {
            GradleBuildState.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            GradleBuildState.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            GradleBuildState.$$$reportNull$$$0(4);
        }
        MessageBusConnection connection = project.getMessageBus().connect(parentDisposable);
        connection.subscribe(GRADLE_BUILD_TOPIC, (Object)listener2);
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            GradleBuildState.$$$reportNull$$$0(5);
        }
        return messageBusConnection;
    }

    @NotNull
    public static GradleBuildState getInstance(@NotNull Project project) {
        if (project == null) {
            GradleBuildState.$$$reportNull$$$0(6);
        }
        GradleBuildState gradleBuildState = (GradleBuildState)project.getService(GradleBuildState.class);
        if (gradleBuildState == null) {
            GradleBuildState.$$$reportNull$$$0(7);
        }
        return gradleBuildState;
    }

    public GradleBuildState(@NotNull Project project, @NotNull MessageBus messageBus) {
        if (project == null) {
            GradleBuildState.$$$reportNull$$$0(8);
        }
        if (messageBus == null) {
            GradleBuildState.$$$reportNull$$$0(9);
        }
        this.myLock = new Object();
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    public void buildExecutorCreated(@NotNull GradleBuildInvoker.Request request) {
        if (request == null) {
            GradleBuildState.$$$reportNull$$$0(10);
        }
        this.syncPublisher((Consumer<GradleBuildListener>)((Consumer)listener2 -> listener2.buildExecutorCreated(request)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildStarted(@NotNull BuildContext context) {
        if (context == null) {
            GradleBuildState.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentContext = context;
        }
        this.syncPublisher((Consumer<GradleBuildListener>)((Consumer)listener2 -> listener2.buildStarted(context)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(@NotNull BuildStatus status) {
        BuildContext context;
        if (status == null) {
            GradleBuildState.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            context = this.myCurrentContext;
            this.myCurrentContext = null;
            this.mySummary = new BuildSummary(status, context);
        }
        this.syncPublisher((Consumer<GradleBuildListener>)((Consumer)listener2 -> listener2.buildFinished(status, context)));
    }

    private void syncPublisher(@NotNull Consumer<GradleBuildListener> consumer) {
        if (consumer == null) {
            GradleBuildState.$$$reportNull$$$0(13);
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> consumer.consume((Object)((GradleBuildListener)this.myMessageBus.syncPublisher(GRADLE_BUILD_TOPIC))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBuildInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentContext != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BuildContext getCurrentContext() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BuildSummary getSummary() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySummary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentContext = null;
            this.mySummary = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/GradleBuildState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/GradleBuildState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribe";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildExecutorCreated";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildStarted";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildFinished";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

