/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.AndroidModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleImporter {
    private static final Logger LOG = Logger.getInstance(ModuleImporter.class);
    private static final Key<ModuleImporter[]> KEY_IMPORTERS = new Key("com.android.tools.importers");
    private static final Key<ModuleImporter> KEY_CURRENT_IMPORTER = new Key("com.android.tools.currentImporter");
    private static final ModuleImporter NONE = new ModuleImporter(){

        @Override
        public boolean isStepVisible(@NotNull ModuleWizardStep step2) {
            if (step2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return false;
        }

        @Override
        @NotNull
        public List<? extends ModuleWizardStep> createWizardSteps() {
            List list = Collections.emptyList();
            if (list == null) {
                1.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        public void importProjects(@Nullable Map<String, VirtualFile> projects2) {
            LOG.error("Unsupported import kind");
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean canImport(@NotNull VirtualFile importSource) {
            if (importSource == null) {
                1.$$$reportNull$$$0(2);
            }
            return false;
        }

        @Override
        @NotNull
        public Set<ModuleToImport> findModules(@NotNull VirtualFile importSource) {
            if (importSource == null) {
                1.$$$reportNull$$$0(3);
            }
            Set<ModuleToImport> set = Collections.emptySet();
            if (set == null) {
                1.$$$reportNull$$$0(4);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/ModuleImporter$1";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/ModuleImporter$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createWizardSteps";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isStepVisible";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canImport";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findModules";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public static synchronized ModuleImporter[] getAllImporters(@NotNull WizardContext context) {
        ModuleImporter[] importers;
        if (context == null) {
            ModuleImporter.$$$reportNull$$$0(0);
        }
        if ((importers = (ModuleImporter[])context.getUserData(KEY_IMPORTERS)) == null) {
            importers = ModuleImporter.createImporters(context);
        }
        if (importers == null) {
            ModuleImporter.$$$reportNull$$$0(1);
        }
        return importers;
    }

    @NotNull
    private static ModuleImporter[] createImporters(@NotNull WizardContext context) {
        if (context == null) {
            ModuleImporter.$$$reportNull$$$0(2);
        }
        ModuleImporter[] importers = ContainerUtil.map((Collection)AndroidModuleImporter.IMPORTER.getExtensionList(), it -> it.create(context)).toArray(new ModuleImporter[0]);
        context.putUserData(KEY_IMPORTERS, (Object)importers);
        if (importers == null) {
            ModuleImporter.$$$reportNull$$$0(3);
        }
        return importers;
    }

    @NotNull
    public static ModuleImporter getImporter(@NotNull WizardContext context) {
        ModuleImporter importer;
        if (context == null) {
            ModuleImporter.$$$reportNull$$$0(4);
        }
        if ((importer = (ModuleImporter)context.getUserData(KEY_CURRENT_IMPORTER)) != null) {
            ModuleImporter moduleImporter = importer;
            if (moduleImporter == null) {
                ModuleImporter.$$$reportNull$$$0(5);
            }
            return moduleImporter;
        }
        ModuleImporter moduleImporter = NONE;
        if (moduleImporter == null) {
            ModuleImporter.$$$reportNull$$$0(6);
        }
        return moduleImporter;
    }

    @NotNull
    public static ModuleImporter importerForLocation(WizardContext context, VirtualFile importSource) {
        for (ModuleImporter importer : ModuleImporter.getAllImporters(context)) {
            if (!importer.canImport(importSource)) continue;
            ModuleImporter moduleImporter = importer;
            if (moduleImporter == null) {
                ModuleImporter.$$$reportNull$$$0(7);
            }
            return moduleImporter;
        }
        ModuleImporter moduleImporter = NONE;
        if (moduleImporter == null) {
            ModuleImporter.$$$reportNull$$$0(8);
        }
        return moduleImporter;
    }

    public static void setImporter(@NotNull WizardContext context, @Nullable ModuleImporter importer) {
        if (context == null) {
            ModuleImporter.$$$reportNull$$$0(9);
        }
        context.putUserData(KEY_CURRENT_IMPORTER, (Object)importer);
    }

    public abstract boolean isStepVisible(@NotNull ModuleWizardStep var1);

    @NotNull
    public abstract List<? extends ModuleWizardStep> createWizardSteps();

    public abstract void importProjects(@Nullable Map<String, VirtualFile> var1);

    public abstract boolean isValid();

    public abstract boolean canImport(@NotNull VirtualFile var1);

    @NotNull
    public abstract Set<ModuleToImport> findModules(@NotNull VirtualFile var1) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/ModuleImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/ModuleImporter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImporters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createImporters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImporter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "importerForLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllImporters";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createImporters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImporter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setImporter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

