/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LegacyAndroidProjects {
    @NonNls
    private static final String SHOW_MIGRATE_TO_GRADLE_POPUP = "show.migrate.to.gradle.popup";
    @NotNull
    private final Project myProject;

    LegacyAndroidProjects(@NotNull Project project) {
        if (project == null) {
            LegacyAndroidProjects.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nullable
    private static String getPackageNameInLegacyIdeaAndroidModule(@NotNull AndroidFacet facet2) {
        Manifest manifest;
        if (facet2 == null) {
            LegacyAndroidProjects.$$$reportNull$$$0(1);
        }
        return (manifest = Manifest.getMainManifest(facet2)) != null ? (String)manifest.getPackage().getValue() : null;
    }

    void showMigrateToGradleWarning() {
        this.trackProject();
        if (!this.shouldShowMigrateToGradleNotification()) {
            return;
        }
        String errMsg = "This project does not use the Gradle build system. We recommend that you migrate to using the Gradle build system.";
        NotificationHyperlink doNotShowAgainHyperlink = new NotificationHyperlink("do.not.show", "Don't show this message again."){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                PropertiesComponent.getInstance((Project)LegacyAndroidProjects.this.myProject).setValue(LegacyAndroidProjects.SHOW_MIGRATE_TO_GRADLE_POPUP, "false");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/LegacyAndroidProjects$1", "execute"));
            }
        };
        AndroidNotification notification = AndroidNotification.getInstance(this.myProject);
        notification.showBalloon("Migrate Project to Gradle?", errMsg, NotificationType.WARNING, new OpenMigrationToGradleUrlHyperlink().setCloseOnClick(true), doNotShowAgainHyperlink);
    }

    void trackProject() {
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            String packageName = null;
            for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
                if (facet2 != null && !AndroidModel.isRequired(facet2)) {
                    String modulePackageName;
                    if (((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) {
                        packageName = LegacyAndroidProjects.getPackageNameInLegacyIdeaAndroidModule(facet2);
                        if (packageName != null) {
                            break;
                        }
                    } else if (packageName == null && (modulePackageName = LegacyAndroidProjects.getPackageNameInLegacyIdeaAndroidModule(facet2)) != null) {
                        packageName = modulePackageName;
                    }
                }
                if (packageName == null) continue;
                AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
                event.setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.LEGACY_IDEA_ANDROID_PROJECT);
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.myProject));
            }
        });
    }

    private boolean shouldShowMigrateToGradleNotification() {
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(SHOW_MIGRATE_TO_GRADLE_POPUP, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/LegacyAndroidProjects";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageNameInLegacyIdeaAndroidModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

