/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleProjectInfo {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;
    private volatile boolean myNewProject;
    private volatile boolean myImportedProject;
    private final ProjectFacetManager myFacetManager;
    private volatile boolean mySkipStartupActivity;
    private static final Key<Set<File>> PROJECTS_BEING_INITIALIZED = Key.create((String)"PROJECTS_BEING_INITIALIZED");

    @NotNull
    public static GradleProjectInfo getInstance(@NotNull Project project) {
        if (project == null) {
            GradleProjectInfo.$$$reportNull$$$0(0);
        }
        GradleProjectInfo gradleProjectInfo = (GradleProjectInfo)project.getService(GradleProjectInfo.class);
        if (gradleProjectInfo == null) {
            GradleProjectInfo.$$$reportNull$$$0(1);
        }
        return gradleProjectInfo;
    }

    public GradleProjectInfo(@NotNull Project project) {
        if (project == null) {
            GradleProjectInfo.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myProjectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        this.myFacetManager = ProjectFacetManager.getInstance((Project)this.myProject);
    }

    public boolean isNewProject() {
        return this.myNewProject;
    }

    public void setNewProject(boolean newProject) {
        this.myNewProject = newProject;
    }

    public boolean isSkipStartupActivity() {
        return this.mySkipStartupActivity;
    }

    public void setSkipStartupActivity(boolean skipStartupActivity) {
        this.mySkipStartupActivity = skipStartupActivity;
    }

    public boolean isImportedProject() {
        return this.myImportedProject;
    }

    public void setImportedProject(boolean importedProject) {
        this.myImportedProject = importedProject;
    }

    public boolean isBuildWithGradle() {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            if (GradleProjectInfo.isBeingInitializedAsGradleProject(this.myProject)) {
                return true;
            }
            if (this.myFacetManager.hasFacets(GradleFacet.getFacetTypeId())) {
                return true;
            }
            if (GradleSyncState.getInstance(this.myProject).getLastSyncFinishedTimeStamp() != -1L) {
                return true;
            }
            if (!GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().isEmpty()) {
                return true;
            }
            return this.hasTopLevelGradleFile();
        });
    }

    public boolean hasGradleFacets() {
        return this.myFacetManager.hasFacets(GradleFacet.getFacetTypeId());
    }

    public boolean hasTopLevelGradleFile() {
        if (this.myProject.isDefault()) {
            return false;
        }
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null) {
            return GradleUtil.findGradleBuildFile(baseDir) != null || GradleUtil.findGradleSettingsFile(baseDir) != null;
        }
        return false;
    }

    @NotNull
    public List<Module> getAndroidModules() {
        ImmutableList.Builder modules = ImmutableList.builder();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (AndroidFacet.getInstance((Module)module2) == null || GradleFacet.getInstance(module2) == null) continue;
                modules.add((Object)module2);
            }
        });
        ImmutableList immutableList = modules.build();
        if (immutableList == null) {
            GradleProjectInfo.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public void forEachAndroidModule(@NotNull Consumer<AndroidFacet> consumer) {
        if (consumer == null) {
            GradleProjectInfo.$$$reportNull$$$0(4);
        }
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
                if (androidFacet == null || GradleFacet.getInstance(module2) == null) continue;
                consumer.consume((Object)androidFacet);
            }
        });
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GradleProjectInfo.$$$reportNull$$$0(5);
        }
        return this.findAndroidModelInModule(file2, true);
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file2, boolean honorExclusion) {
        Module module2;
        if (file2 == null) {
            GradleProjectInfo.$$$reportNull$$$0(6);
        }
        if ((module2 = this.findModuleForFile(file2, honorExclusion)) == null) {
            return null;
        }
        if (module2.isDisposed()) {
            this.getLog().warn("Attempted to get an Android Facet from a disposed module");
            return null;
        }
        return AndroidModuleModel.get(module2);
    }

    @Nullable
    private Module findModuleForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        if (file2 == null) {
            GradleProjectInfo.$$$reportNull$$$0(7);
        }
        return this.myProjectFileIndex.getModuleForFile(file2, honorExclusion);
    }

    @NotNull
    public Module[] getModulesToBuildFromSelection(@Nullable DataContext dataContext) {
        Module[] modules;
        if (dataContext == null) {
            ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
            AbstractProjectViewPane pane = projectView.getCurrentProjectViewPane();
            if (pane != null) {
                JComponent treeComponent = pane.getComponentToFocus();
                dataContext = DataManager.getInstance().getDataContext((Component)treeComponent);
            } else {
                if (Module.EMPTY_ARRAY == null) {
                    GradleProjectInfo.$$$reportNull$$$0(8);
                }
                return Module.EMPTY_ARRAY;
            }
        }
        if ((modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null) {
            if (modules.length == 1 && GradleProjectInfo.isProjectModule(modules[0])) {
                Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
                if (moduleArray == null) {
                    GradleProjectInfo.$$$reportNull$$$0(9);
                }
                return moduleArray;
            }
            if (modules == null) {
                GradleProjectInfo.$$$reportNull$$$0(10);
            }
            return modules;
        }
        Module module2 = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module2 != null) {
            Module[] moduleArray;
            if (GradleProjectInfo.isProjectModule(module2)) {
                moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = module2;
            }
            if (moduleArray == null) {
                GradleProjectInfo.$$$reportNull$$$0(11);
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            GradleProjectInfo.$$$reportNull$$$0(12);
        }
        return Module.EMPTY_ARRAY;
    }

    public static AccessToken beginInitializingGradleProjectAt(final @NotNull File projectFolderPath) {
        UserDataHolderEx userData;
        Set projectsBeingInitialized;
        if (projectFolderPath == null) {
            GradleProjectInfo.$$$reportNull$$$0(13);
        }
        if (!(projectsBeingInitialized = (Set)(userData = (UserDataHolderEx)ApplicationManager.getApplication()).putUserDataIfAbsent(PROJECTS_BEING_INITIALIZED, (Object)ContainerUtil.newConcurrentSet())).add(projectFolderPath)) {
            throw new IllegalStateException("Cannot initialize two projects at the same location at the same time. Project location: " + projectFolderPath);
        }
        return new AccessToken(){

            public void finish() {
                projectsBeingInitialized.remove(projectFolderPath);
            }
        };
    }

    private static boolean isBeingInitializedAsGradleProject(@NotNull Project project) {
        String basePath;
        if (project == null) {
            GradleProjectInfo.$$$reportNull$$$0(14);
        }
        if ((basePath = project.getBasePath()) == null) {
            return false;
        }
        Set projectsBeingInitialized = (Set)ApplicationManager.getApplication().getUserData(PROJECTS_BEING_INITIALIZED);
        if (projectsBeingInitialized == null) {
            return false;
        }
        return projectsBeingInitialized.contains(new File(basePath));
    }

    private static boolean isProjectModule(@NotNull Module module2) {
        File moduleRootFolderPath;
        if (module2 == null) {
            GradleProjectInfo.$$$reportNull$$$0(15);
        }
        if ((moduleRootFolderPath = AndroidRootUtil.findModuleRootFolderPath(module2)) == null) {
            return false;
        }
        String basePath = module2.getProject().getBasePath();
        return basePath != null && FileUtil.filesEqual((File)moduleRootFolderPath, (File)new File(basePath)) && !GradleFacet.isAppliedTo(module2);
    }

    @NotNull
    private Logger getLog() {
        Logger logger2 = Logger.getInstance(this.getClass());
        if (logger2 == null) {
            GradleProjectInfo.$$$reportNull$$$0(16);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/GradleProjectInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolderPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/GradleProjectInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidModules";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToBuildFromSelection";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEachAndroidModule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAndroidModelInModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "beginInitializingGradleProjectAt";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isBeingInitializedAsGradleProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isProjectModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

