/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.AndroidModuleImporter;
import com.android.tools.idea.gradle.project.GradleProjectDependencyParser;
import com.android.tools.idea.gradle.project.GradleSiblingLookup;
import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleModuleImporter
extends ModuleImporter {
    private final Logger LOG;
    @Nullable
    private final Project myProject;
    private final boolean myIsWizard;

    private GradleModuleImporter(@NotNull WizardContext context) {
        if (context == null) {
            GradleModuleImporter.$$$reportNull$$$0(0);
        }
        this(context.getProject(), true);
    }

    private GradleModuleImporter(@Nullable Project project, boolean isWizard) {
        this.LOG = Logger.getInstance(this.getClass());
        this.myIsWizard = isWizard;
        this.myProject = project;
    }

    @Override
    public boolean isStepVisible(@NotNull ModuleWizardStep step2) {
        if (step2 == null) {
            GradleModuleImporter.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Override
    @NotNull
    public List<? extends ModuleWizardStep> createWizardSteps() {
        List list = Collections.emptyList();
        if (list == null) {
            GradleModuleImporter.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void importProjects(Map<String, VirtualFile> projects2) {
        try {
            GradleModuleImporter.importModules(this, projects2, this.myProject, null);
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean canImport(@NotNull VirtualFile importSource) {
        if (importSource == null) {
            GradleModuleImporter.$$$reportNull$$$0(3);
        }
        return GradleProjects.canImportAsGradleProject(importSource) && (this.myIsWizard || this.findModules(importSource).size() == 1);
    }

    @Override
    @NotNull
    public Set<ModuleToImport> findModules(@NotNull VirtualFile importSource) {
        if (importSource == null) {
            GradleModuleImporter.$$$reportNull$$$0(4);
        }
        assert (this.myProject != null);
        return GradleModuleImporter.getRelatedProjects(importSource, this.myProject);
    }

    @NotNull
    public static Set<ModuleToImport> getRelatedProjects(@NotNull VirtualFile sourceProject, @NotNull Project destinationProject) {
        VirtualFile settingsGradle;
        if (sourceProject == null) {
            GradleModuleImporter.$$$reportNull$$$0(5);
        }
        if (destinationProject == null) {
            GradleModuleImporter.$$$reportNull$$$0(6);
        }
        if ((settingsGradle = sourceProject.findFileByRelativePath("settings.gradle")) != null) {
            return GradleModuleImporter.buildModulesSet(GradleModuleImporter.getSubProjects(settingsGradle, destinationProject), GradleProjectDependencyParser.newInstance(destinationProject));
        }
        return GradleModuleImporter.getRequiredProjects(sourceProject, destinationProject);
    }

    @NotNull
    private static Set<ModuleToImport> getRequiredProjects(@NotNull VirtualFile sourceProject, @NotNull Project destinationProject) {
        if (sourceProject == null) {
            GradleModuleImporter.$$$reportNull$$$0(7);
        }
        if (destinationProject == null) {
            GradleModuleImporter.$$$reportNull$$$0(8);
        }
        GradleSiblingLookup subProjectLocations = new GradleSiblingLookup(sourceProject, destinationProject);
        Function<VirtualFile, Iterable<String>> parser = GradleProjectDependencyParser.newInstance(destinationProject);
        HashMap modules = Maps.newHashMap();
        ImmutableList toAnalyze = new LinkedList();
        toAnalyze.add(sourceProject);
        while (!toAnalyze.isEmpty()) {
            HashSet dependencies2 = Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform(toAnalyze, parser)));
            Iterable notAnalyzed = Iterables.filter((Iterable)dependencies2, (Predicate)Predicates.not((Predicate)Predicates.in(modules.keySet())));
            HashMap dependencyToLocation = Maps.newHashMap();
            for (String dependency : notAnalyzed) {
                dependencyToLocation.put(dependency, subProjectLocations.apply(dependency));
            }
            modules.putAll(dependencyToLocation);
            toAnalyze = FluentIterable.from(dependencyToLocation.values()).filter(Predicates.notNull()).toList();
        }
        modules.put(subProjectLocations.getPrimaryProjectName(), sourceProject);
        return GradleModuleImporter.buildModulesSet(modules, parser);
    }

    @NotNull
    private static Set<ModuleToImport> buildModulesSet(@NotNull Map<String, VirtualFile> modules, @NotNull Function<VirtualFile, Iterable<String>> parser) {
        if (modules == null) {
            GradleModuleImporter.$$$reportNull$$$0(9);
        }
        if (parser == null) {
            GradleModuleImporter.$$$reportNull$$$0(10);
        }
        HashSet modulesSet = Sets.newHashSetWithExpectedSize((int)modules.size());
        for (Map.Entry<String, VirtualFile> entry : modules.entrySet()) {
            VirtualFile location = entry.getValue();
            Supplier dependencyComputer = location != null ? Suppliers.compose(parser, (Supplier)Suppliers.ofInstance((Object)location)) : Suppliers.ofInstance((Object)ImmutableSet.of());
            modulesSet.add(new ModuleToImport(entry.getKey(), location, (Supplier<? extends Iterable<String>>)dependencyComputer));
        }
        HashSet hashSet = modulesSet;
        if (hashSet == null) {
            GradleModuleImporter.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @NotNull
    public static Map<String, VirtualFile> getSubProjects(@NotNull VirtualFile settingsGradle, Project destinationProject) {
        if (settingsGradle == null) {
            GradleModuleImporter.$$$reportNull$$$0(12);
        }
        GradleSettingsModel gradleSettingsModel = GradleSettingsModel.get((VirtualFile)settingsGradle, (Project)destinationProject);
        Set paths = gradleSettingsModel.modulePaths();
        LinkedHashMap<String, File> allProjects = new LinkedHashMap<String, File>();
        for (String path2 : paths) {
            File projectFile;
            if (path2.equals(":") || (projectFile = gradleSettingsModel.moduleDirectory(path2)) == null) continue;
            allProjects.put(path2, projectFile);
        }
        Map map2 = Maps.transformValues(allProjects, (Function)new ResolvePath(VfsUtilCore.virtualToIoFile((VirtualFile)settingsGradle.getParent())));
        if (map2 == null) {
            GradleModuleImporter.$$$reportNull$$$0(13);
        }
        return map2;
    }

    @VisibleForTesting
    static void importModules(@NotNull Object requestor, @NotNull Map<String, VirtualFile> modules, @Nullable Project project, @Nullable GradleSyncListener listener2) throws IOException {
        String error;
        if (requestor == null) {
            GradleModuleImporter.$$$reportNull$$$0(14);
        }
        if (modules == null) {
            GradleModuleImporter.$$$reportNull$$$0(15);
        }
        if ((error = GradleModuleImporter.validateProjectsForImport(modules)) != null) {
            if (listener2 != null && project != null) {
                listener2.syncFailed(project, error);
                return;
            }
            throw new IOException(error);
        }
        assert (project != null);
        WriteCommandAction.writeCommandAction((Project)project).run(() -> GradleModuleImporter.copyAndRegisterModule(requestor, modules, project, listener2));
    }

    @Nullable
    private static String validateProjectsForImport(@NotNull Map<String, VirtualFile> modules) {
        if (modules == null) {
            GradleModuleImporter.$$$reportNull$$$0(16);
        }
        TreeSet<String> projects2 = new TreeSet<String>();
        for (Map.Entry<String, VirtualFile> mapping : modules.entrySet()) {
            if (mapping.getValue() != null) continue;
            projects2.add(mapping.getKey());
        }
        if (projects2.isEmpty()) {
            return null;
        }
        if (projects2.size() == 1) {
            return String.format("Sources for module '%1$s' were not found", Iterables.getFirst(projects2, null));
        }
        String projectsList = Joiner.on((String)"', '").join(projects2);
        return String.format("Sources were not found for modules '%1$s'", projectsList);
    }

    private static void copyAndRegisterModule(@NotNull Object requestor, @NotNull Map<String, VirtualFile> modules, @NotNull Project project, @Nullable GradleSyncListener listener2) throws IOException {
        VirtualFile projectRoot;
        if (requestor == null) {
            GradleModuleImporter.$$$reportNull$$$0(17);
        }
        if (modules == null) {
            GradleModuleImporter.$$$reportNull$$$0(18);
        }
        if (project == null) {
            GradleModuleImporter.$$$reportNull$$$0(19);
        }
        if ((projectRoot = Objects.requireNonNull(ProjectUtil.guessProjectDir((Project)project))).findChild("settings.gradle") == null) {
            projectRoot.createChildData(requestor, "settings.gradle");
        }
        GradleSettingsModel gradleSettingsModel = ProjectBuildModel.get((Project)project).getProjectSettingsModel();
        for (Map.Entry<String, VirtualFile> module2 : modules.entrySet()) {
            String name = module2.getKey();
            Path targetFile = GradleUtil.getModuleDefaultPath(Paths.get(projectRoot.getPath(), new String[0]), name);
            VirtualFile moduleSource = module2.getValue();
            if (moduleSource != null) {
                if (!VfsUtilCore.isAncestor((VirtualFile)projectRoot, (VirtualFile)moduleSource, (boolean)true)) {
                    VirtualFile target = VfsUtil.createDirectoryIfMissing((String)targetFile.toAbsolutePath().toString());
                    if (target == null) {
                        throw new IOException(String.format("Unable to create directory %1$s", targetFile));
                    }
                    if (target.exists()) {
                        target.delete(requestor);
                    }
                    moduleSource.copy(requestor, target.getParent(), target.getName());
                } else {
                    targetFile = Paths.get(moduleSource.getPath(), new String[0]);
                }
            }
            if (gradleSettingsModel == null) continue;
            gradleSettingsModel.addModulePath(name);
            if (FileUtil.filesEqual((File)GradleUtil.getModuleDefaultPath(Paths.get(projectRoot.getPath(), new String[0]), name).toFile(), (File)targetFile.toFile())) continue;
            gradleSettingsModel.setModuleDirectory(name, targetFile.toFile());
        }
        if (gradleSettingsModel == null) {
            Messages.showErrorDialog((Project)project, (String)"Couldn't add new paths to the Gradle settings file, please add them manually", (String)"Gradle Module Import Error");
        } else {
            gradleSettingsModel.applyChanges();
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_IMPORT_MODULES_COPIED);
            GradleSyncInvoker.getInstance().requestProjectSync(project, request, listener2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 2: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/GradleModuleImporter";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSource";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceProject";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationProject";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsGradle";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/GradleModuleImporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createWizardSteps";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModulesSet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isStepVisible";
                break;
            }
            case 2: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canImport";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedProjects";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredProjects";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildModulesSet";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSubProjects";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "importModules";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectsForImport";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copyAndRegisterModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GradleAndroidModuleImporter
    implements AndroidModuleImporter {
        @Override
        @NotNull
        public ModuleImporter create(@NotNull WizardContext context) {
            if (context == null) {
                GradleAndroidModuleImporter.$$$reportNull$$$0(0);
            }
            return new GradleModuleImporter(context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/project/GradleModuleImporter$GradleAndroidModuleImporter", "create"));
        }
    }

    private static class ResolvePath
    implements Function<File, VirtualFile> {
        private final File mySourceDir;

        ResolvePath(File sourceDir) {
            this.mySourceDir = sourceDir;
        }

        public VirtualFile apply(File path2) {
            if (!path2.isAbsolute()) {
                path2 = new File(this.mySourceDir, path2.getPath());
            }
            return VfsUtil.findFileByIoFile((File)path2, (boolean)true);
        }
    }
}

