/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleOrderEnumeratorHandler;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;

public class AndroidGradleOrderEnumeratorHandlerFactory
extends GradleOrderEnumeratorHandler.FactoryImpl {
    @NotNull
    private static final String CLASSES_FOLDER_NAME = "classes";
    @NotNull
    private static final String RESOURCES_FOLDER_NAME = "resources";
    @NotNull
    private static final String MAIN_FOLDER_NAME = "main";
    @NotNull
    private static final String TEST_FOLDER_NAME = "test";
    @NotNull
    private static final String KOTLIN_FOLDER_NAME = "kotlin";

    public boolean isApplicable(@NotNull Module module2) {
        if (module2 == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(0);
        }
        return IdeInfo.getInstance().isAndroidStudio() || AndroidModuleModel.get(module2) != null;
    }

    @NotNull
    public GradleOrderEnumeratorHandler createHandler(@NotNull Module module2) {
        boolean shouldRecurse;
        if (module2 == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(1);
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
        boolean bl = shouldRecurse = AndroidModuleModel.get(module2) != null;
        if (rootProjectPath != null && !shouldRecurse) {
            String gradleVersion2 = GradleLocalSettings.getInstance((Project)module2.getProject()).getGradleVersion(rootProjectPath);
            shouldRecurse = gradleVersion2 != null && GradleVersion.version((String)gradleVersion2).compareTo(GradleVersion.version((String)"2.5")) < 0;
        }
        final boolean finalShouldRecurse = shouldRecurse;
        return new GradleOrderEnumeratorHandler(module2){

            public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
                return false;
            }

            public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
                return true;
            }

            public boolean shouldProcessDependenciesRecursively() {
                return finalShouldRecurse;
            }

            public boolean addCustomModuleRoots(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result2, boolean includeProduction, boolean includeTests) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rootModel == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!type.equals((Object)OrderRootType.CLASSES)) {
                    return false;
                }
                AndroidModuleModel androidModel = AndroidModuleModel.get(rootModel.getModule());
                if (androidModel != null) {
                    super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
                    AndroidGradleOrderEnumeratorHandlerFactory.getAndroidCompilerOutputFolders(androidModel, includeProduction, includeTests).stream().filter(root2 -> !result2.contains(root2)).forEachOrdered(result2::add);
                    return true;
                }
                JavaModuleModel javaModel = JavaModuleModel.get(rootModel.getModule());
                if (javaModel != null) {
                    super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
                    AndroidGradleOrderEnumeratorHandlerFactory.getJavaAndKotlinCompilerOutputFolders(javaModel, includeProduction, includeTests).stream().filter(root2 -> !result2.contains(root2)).forEachOrdered(result2::add);
                    return true;
                }
                return super.addCustomModuleRoots(type, rootModel, result2, includeProduction, includeTests);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootModel";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/gradle/project/AndroidGradleOrderEnumeratorHandlerFactory$1";
                objectArray[2] = "addCustomModuleRoots";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static List<String> getAndroidCompilerOutputFolders(@NotNull AndroidModuleModel androidModel, boolean includeProduction, boolean includeTests) {
        if (androidModel == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(2);
        }
        LinkedList<String> toAdd = new LinkedList<String>();
        if (includeTests) {
            if (androidModel.getSelectedVariant().getUnitTestArtifact() != null) {
                AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromJavaArtifact(androidModel.getSelectedVariant().getUnitTestArtifact(), toAdd);
            }
            if (androidModel.getSelectedVariant().getAndroidTestArtifact() != null) {
                AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromAndroidArtifact(androidModel.getSelectedVariant().getAndroidTestArtifact(), toAdd);
            }
        }
        if (includeProduction) {
            AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromAndroidArtifact(androidModel.getSelectedVariant().getMainArtifact(), toAdd);
        }
        LinkedList<String> linkedList = toAdd;
        if (linkedList == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(3);
        }
        return linkedList;
    }

    private static void addFoldersFromBaseArtifact(@NotNull IdeBaseArtifact artifact, @NotNull List<String> toAdd) {
        if (artifact == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(4);
        }
        if (toAdd == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(5);
        }
        toAdd.add(FilePaths.pathToIdeaUrl((File)artifact.getClassesFolder()));
        artifact.getAdditionalClassesFolders().stream().filter(Objects::nonNull).map(FilePaths::pathToIdeaUrl).forEach(toAdd::add);
        toAdd.add(FilePaths.pathToIdeaUrl((File)artifact.getJavaResourcesFolder()));
    }

    private static void addFoldersFromJavaArtifact(@NotNull IdeJavaArtifact artifact, @NotNull List<String> toAdd) {
        if (artifact == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(6);
        }
        if (toAdd == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(7);
        }
        AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromBaseArtifact((IdeBaseArtifact)artifact, toAdd);
    }

    private static void addFoldersFromAndroidArtifact(@NotNull IdeAndroidArtifact artifact, @NotNull List<String> toAdd) {
        if (artifact == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(8);
        }
        if (toAdd == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(9);
        }
        AndroidGradleOrderEnumeratorHandlerFactory.addFoldersFromBaseArtifact((IdeBaseArtifact)artifact, toAdd);
        artifact.getGeneratedResourceFolders().stream().filter(Objects::nonNull).map(FilePaths::pathToIdeaUrl).forEach(toAdd::add);
    }

    @NotNull
    private static Collection<String> getJavaAndKotlinCompilerOutputFolders(@NotNull JavaModuleModel javaModel, boolean includeProduction, boolean includeTests) {
        if (javaModel == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(10);
        }
        LinkedList<String> toAdd = new LinkedList<String>();
        File mainClassesFolderPath = null;
        File mainResourcesFolderPath = null;
        File testClassesFolderPath = null;
        File testResourcesFolderPath = null;
        File mainKotlinClassesFolderPath = null;
        File testKotlinClassesFolderPath = null;
        ExtIdeaCompilerOutput compilerOutput = javaModel.getCompilerOutput();
        if (compilerOutput != null) {
            mainClassesFolderPath = compilerOutput.getMainClassesDir();
            mainResourcesFolderPath = compilerOutput.getMainResourcesDir();
            testClassesFolderPath = compilerOutput.getTestClassesDir();
            testResourcesFolderPath = compilerOutput.getTestResourcesDir();
        }
        File buildFolderPath = javaModel.getBuildFolderPath();
        if (javaModel.isBuildable()) {
            if (mainClassesFolderPath == null) {
                mainClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, MAIN_FOLDER_NAME}));
            }
            if (mainResourcesFolderPath == null) {
                mainResourcesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{RESOURCES_FOLDER_NAME, MAIN_FOLDER_NAME}));
            }
            if (testClassesFolderPath == null) {
                testClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, TEST_FOLDER_NAME}));
            }
            if (testResourcesFolderPath == null) {
                testResourcesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{RESOURCES_FOLDER_NAME, TEST_FOLDER_NAME}));
            }
        }
        if (buildFolderPath != null) {
            File kotlinClasses = buildFolderPath.toPath().resolve(CLASSES_FOLDER_NAME).resolve(KOTLIN_FOLDER_NAME).toFile();
            if (includeTests) {
                testKotlinClassesFolderPath = new File(kotlinClasses, TEST_FOLDER_NAME);
            }
            if (includeProduction) {
                mainKotlinClassesFolderPath = new File(kotlinClasses, MAIN_FOLDER_NAME);
            }
        }
        if (includeTests) {
            if (testClassesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl((File)testClassesFolderPath));
            }
            if (testKotlinClassesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl(testKotlinClassesFolderPath));
            }
            if (testResourcesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl((File)testResourcesFolderPath));
            }
        }
        if (includeProduction) {
            if (mainClassesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl((File)mainClassesFolderPath));
            }
            if (mainKotlinClassesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl(mainKotlinClassesFolderPath));
            }
            if (mainResourcesFolderPath != null) {
                toAdd.add(FilePaths.pathToIdeaUrl((File)mainResourcesFolderPath));
            }
        }
        LinkedList<String> linkedList = toAdd;
        if (linkedList == null) {
            AndroidGradleOrderEnumeratorHandlerFactory.$$$reportNull$$$0(11);
        }
        return linkedList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/AndroidGradleOrderEnumeratorHandlerFactory";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/AndroidGradleOrderEnumeratorHandlerFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidCompilerOutputFolders";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaAndKotlinCompilerOutputFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidCompilerOutputFolders";
                break;
            }
            case 3: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFoldersFromBaseArtifact";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFoldersFromJavaArtifact";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFoldersFromAndroidArtifact";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJavaAndKotlinCompilerOutputFolders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

