/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.actions.RefreshLinkedCppProjectsAction;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.utils.BuildScriptUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.BuildContentManager;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ProjectSyncStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final long PROJECT_STRUCTURE_NOTIFICATION_RESHOW_TIMEOUT_MS = TimeUnit.DAYS.toMillis(30L);
    @NotNull
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.sync.status");
    @NotNull
    private final GradleProjectInfo myProjectInfo;
    @NotNull
    private final GradleSyncState mySyncState;

    public ProjectSyncStatusNotificationProvider(@NotNull Project project) {
        if (project == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(0);
        }
        this(GradleProjectInfo.getInstance(project), GradleSyncState.getInstance(project));
    }

    @NonInjectable
    @TestOnly
    public ProjectSyncStatusNotificationProvider(@NotNull GradleProjectInfo projectInfo, @NotNull GradleSyncState syncState) {
        if (projectInfo == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(1);
        }
        if (syncState == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(2);
        }
        this.myProjectInfo = projectInfo;
        this.mySyncState = syncState;
    }

    @NotNull
    public final Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(3);
        }
        return key;
    }

    @AnyThread
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor editor2, @NotNull Project project) {
        if (file2 == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(6);
        }
        NotificationPanel.Type newPanelType = this.notificationPanelType(project);
        return newPanelType.create(project, file2, this.myProjectInfo);
    }

    @NotNull
    private NotificationPanel.Type notificationPanelType(@NotNull Project project) {
        if (project == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(7);
        }
        if (IdeInfo.getInstance().isAndroidStudio() || ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            NotificationPanel.Type type = this.notificationPanelType();
            if (type == null) {
                ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(8);
            }
            return type;
        }
        NotificationPanel.Type type = NotificationPanel.Type.NONE;
        if (type == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(9);
        }
        return type;
    }

    @VisibleForTesting
    @NotNull
    NotificationPanel.Type notificationPanelType() {
        if (!this.myProjectInfo.isBuildWithGradle()) {
            NotificationPanel.Type type = NotificationPanel.Type.NONE;
            if (type == null) {
                ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(10);
            }
            return type;
        }
        if (this.mySyncState.isSyncInProgress()) {
            NotificationPanel.Type type = NotificationPanel.Type.IN_PROGRESS;
            if (type == null) {
                ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(11);
            }
            return type;
        }
        if (this.mySyncState.lastSyncFailed()) {
            NotificationPanel.Type type = NotificationPanel.Type.FAILED;
            if (type == null) {
                ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(12);
            }
            return type;
        }
        ThreeState gradleSyncNeeded = this.mySyncState.isSyncNeeded();
        if (gradleSyncNeeded == ThreeState.YES) {
            NotificationPanel.Type type = NotificationPanel.Type.SYNC_NEEDED;
            if (type == null) {
                ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(13);
            }
            return type;
        }
        NotificationPanel.Type type = NotificationPanel.Type.NONE;
        if (type == null) {
            ProjectSyncStatusNotificationProvider.$$$reportNull$$$0(14);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "notificationPanelType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notificationPanelType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class ProjectStructureNotificationPanel
    extends NotificationPanel {
        ProjectStructureNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text2, @NotNull Module module2) {
            if (project == null) {
                ProjectStructureNotificationPanel.$$$reportNull$$$0(0);
            }
            if (type == null) {
                ProjectStructureNotificationPanel.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                ProjectStructureNotificationPanel.$$$reportNull$$$0(2);
            }
            if (module2 == null) {
                ProjectStructureNotificationPanel.$$$reportNull$$$0(3);
            }
            super(type, text2);
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"ShowProjectStructureSettings");
            Object label = "Open";
            if (shortcutText != "") {
                label = (String)label + " (" + shortcutText + ")";
            }
            this.createActionLabel((String)label, () -> {
                ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance((Project)project);
                if (projectSettingsService instanceof AndroidProjectSettingsService) {
                    projectSettingsService.openModuleSettings(module2);
                }
            });
            this.createActionLabel("Hide notification", () -> {
                PropertiesComponent.getInstance().setValue("PROJECT_STRUCTURE_NOTIFICATION_LAST_HIDDEN_TIMESTAMP", Long.toString(System.currentTimeMillis()));
                this.setVisible(false);
            });
        }

        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            return color == null ? UIUtil.getPanelBackground() : color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$ProjectStructureNotificationPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class SyncProblemNotificationPanel
    extends NotificationPanel {
        SyncProblemNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text2) {
            if (project == null) {
                SyncProblemNotificationPanel.$$$reportNull$$$0(0);
            }
            if (type == null) {
                SyncProblemNotificationPanel.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                SyncProblemNotificationPanel.$$$reportNull$$$0(2);
            }
            super(type, text2);
            this.createActionLabel("Try Again", () -> GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_USER_TRY_AGAIN));
            this.createActionLabel("Open 'Build' View", () -> {
                ToolWindow tw = BuildContentManager.getInstance((Project)project).getOrCreateToolWindow();
                if (tw != null && !tw.isActive()) {
                    tw.activate(null, false);
                }
            });
            this.createActionLabel("Show Log in " + RevealFileAction.getFileManagerName(), () -> {
                File logFile = new File(PathManager.getLogPath(), "idea.log");
                RevealFileAction.openFile((File)logFile);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$SyncProblemNotificationPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class StaleGradleModelNotificationPanel
    extends NotificationPanel {
        StaleGradleModelNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text2) {
            if (project == null) {
                StaleGradleModelNotificationPanel.$$$reportNull$$$0(0);
            }
            if (type == null) {
                StaleGradleModelNotificationPanel.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                StaleGradleModelNotificationPanel.$$$reportNull$$$0(2);
            }
            super(type, text2);
            if (GradleFiles.getInstance(project).areExternalBuildFilesModified()) {
                project.putUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, (Object)true);
            }
            this.createActionLabel("Sync Now", () -> GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_USER_STALE_CHANGES));
            this.createActionLabel("Ignore these changes", () -> {
                GradleFiles.getInstance(project).removeChangedFiles();
                this.setVisible(false);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$StaleGradleModelNotificationPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class NotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final Type type;

        NotificationPanel(@NotNull Type type, @NotNull String text2) {
            if (type == null) {
                NotificationPanel.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                NotificationPanel.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.setText(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static enum Type {
            NONE{

                @Override
                @Nullable
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (projectInfo == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (!IdeInfo.getInstance().isAndroidStudio()) {
                        return null;
                    }
                    if (System.currentTimeMillis() - Long.parseLong(PropertiesComponent.getInstance().getValue("PROJECT_STRUCTURE_NOTIFICATION_LAST_HIDDEN_TIMESTAMP", "0")) > PROJECT_STRUCTURE_NOTIFICATION_RESHOW_TIMEOUT_MS) {
                        if (!projectInfo.isBuildWithGradle()) {
                            return null;
                        }
                        if (!BuildScriptUtil.isDefaultGradleBuildFile((File)VfsUtilCore.virtualToIoFile((VirtualFile)file2))) {
                            return null;
                        }
                        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project);
                        if (module2 == null) {
                            if (ApplicationManager.getApplication().isUnitTestMode()) {
                                module2 = ModuleManager.getInstance((Project)project).getModules()[0];
                            } else {
                                return null;
                            }
                        }
                        return new ProjectStructureNotificationPanel(project, this, "You can use the Project Structure dialog to view and edit your project configuration", module2);
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "projectInfo";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$1";
                    objectArray[2] = "create";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            ,
            IN_PROGRESS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (file2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (projectInfo == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return new NotificationPanel(this, "Gradle project sync in progress...");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "projectInfo";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$2";
                    objectArray[2] = "create";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            ,
            FAILED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    if (project == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (file2 == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (projectInfo == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    String text2 = "Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.";
                    return new SyncProblemNotificationPanel(project, this, text2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "projectInfo";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$3";
                    objectArray[2] = "create";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            ,
            SYNC_NEEDED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    boolean buildFilesModified;
                    if (project == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (file2 == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    if (projectInfo == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    String text2 = ((buildFilesModified = GradleFiles.getInstance(project).areExternalBuildFilesModified()) ? "External build files" : "Gradle files") + " have changed since last project sync. A project sync may be necessary for the IDE to work properly.";
                    return new StaleGradleModelNotificationPanel(project, this, text2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "projectInfo";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/gradle/notification/ProjectSyncStatusNotificationProvider$NotificationPanel$Type$4";
                    objectArray[2] = "create";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };


            @Nullable
            abstract NotificationPanel create(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull GradleProjectInfo var3);
        }
    }
}

