/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.android.tools.idea.gradle.model.java.GradleModuleVersionImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarLibraryDependency
implements Serializable {
    private static final long serialVersionUID = 2L;
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    @NotNull
    private final String myName;
    @Nullable
    private final File myBinaryPath;
    @Nullable
    private final File mySourcePath;
    @Nullable
    private final File myJavadocPath;
    @Nullable
    private final String myScope;
    @Nullable
    private final GradleModuleVersion myModuleVersion;
    private final boolean myResolved;

    @NotNull
    public static String getDependencyName(@NotNull File binaryPath, boolean resolved) {
        if (binaryPath == null) {
            JarLibraryDependency.$$$reportNull$$$0(0);
        }
        if (resolved) {
            String string = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
            if (string == null) {
                JarLibraryDependency.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = binaryPath.getName().substring(UNRESOLVED_DEPENDENCY_PREFIX.length()).replace(' ', ':');
        if (string == null) {
            JarLibraryDependency.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isResolved(@NotNull String libraryName) {
        if (libraryName == null) {
            JarLibraryDependency.$$$reportNull$$$0(3);
        }
        return !libraryName.startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
    }

    @PropertyMapping(value={"myName", "myBinaryPath", "mySourcePath", "myJavadocPath", "myScope", "myModuleVersion", "myResolved"})
    public JarLibraryDependency(@NotNull String name, @Nullable File binaryPath, @Nullable File sourcePath, @Nullable File javadocPath, @Nullable String scope2, @Nullable GradleModuleVersion moduleVersion, boolean resolved) {
        if (name == null) {
            JarLibraryDependency.$$$reportNull$$$0(4);
        }
        this.myName = name;
        this.myBinaryPath = binaryPath;
        this.mySourcePath = sourcePath;
        this.myJavadocPath = javadocPath;
        this.myScope = scope2;
        this.myModuleVersion = moduleVersion != null ? new GradleModuleVersionImpl(moduleVersion) : null;
        this.myResolved = resolved;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JarLibraryDependency.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public File getBinaryPath() {
        return this.myBinaryPath;
    }

    @Nullable
    public File getSourcePath() {
        return this.mySourcePath;
    }

    @Nullable
    public File getJavadocPath() {
        return this.myJavadocPath;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    @Nullable
    public GradleModuleVersion getModuleVersion() {
        return this.myModuleVersion;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myBinaryPath, this.mySourcePath, this.myJavadocPath, this.myScope, this.myModuleVersion, this.myResolved);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JarLibraryDependency)) {
            return false;
        }
        JarLibraryDependency dependency = (JarLibraryDependency)obj;
        return Objects.equals(this.myName, dependency.myName) && Objects.equals(this.myBinaryPath, dependency.myBinaryPath) && Objects.equals(this.mySourcePath, dependency.mySourcePath) && Objects.equals(this.myJavadocPath, dependency.myJavadocPath) && Objects.equals(this.myScope, dependency.myScope) && Objects.equals(this.myModuleVersion, dependency.myModuleVersion) && Objects.equals(this.myResolved, dependency.myResolved);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/model/java/JarLibraryDependency";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/model/java/JarLibraryDependency";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyName";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResolved";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

