/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.adtimport;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.adtimport.EclipseProject;
import com.android.tools.idea.gradle.adtimport.ImportModule;
import com.android.tools.idea.gradle.adtimport.ImportSummary;
import com.android.tools.idea.gradle.npw.project.GradleBuildSettings;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.gradle.util.ImportUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.util.PropertiesFiles;
import com.android.utils.PositionXmlParser;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.primitives.Bytes;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GradleImport {
    public static final String NL = System.lineSeparator();
    public static final int CURRENT_COMPILE_VERSION = 30;
    public static final String ANDROID_GRADLE_PLUGIN = "com.android.tools.build:gradle:" + LatestKnownPluginVersionProvider.INSTANCE.get();
    public static final String MAVEN_URL_PROPERTY = "android.mavenRepoUrl";
    public static final String ECLIPSE_DOT_CLASSPATH = ".classpath";
    public static final String ECLIPSE_DOT_PROJECT = ".project";
    public static final String MAVEN_REPOSITORY;
    private static final String WORKSPACE_PROPERTY = "android.eclipseWorkspace";
    private final List<String> myWarnings = new ArrayList<String>();
    private final List<String> myErrors = new ArrayList<String>();
    private List<? extends ImportModule> myRootModules;
    private Set<ImportModule> myModules;
    private ImportSummary mySummary;
    private File myWorkspaceLocation;
    private boolean myCreateGradleWrapper = false;
    private File mySdkLocation;
    private File myNdkLocation;
    private Set<String> myHandledJars = new HashSet<String>();
    private Map<String, File> myWorkspaceProjects;
    private boolean myGradleNameStyle = true;
    private boolean myReplaceJars = true;
    private boolean myReplaceLibs = true;
    private boolean myImportIntoExisting;
    private Map<String, File> myPathMap = Maps.newTreeMap();
    private Map<File, String> mySelectedModules;
    private boolean myDefaultEncodingInitialized;
    private Charset myDefaultEncoding;
    private Map<File, EclipseProject> myProjectMap = Maps.newHashMap();

    public GradleImport() {
        String workspace = System.getProperty(WORKSPACE_PROPERTY);
        if (workspace != null) {
            this.myWorkspaceLocation = new File(workspace);
        }
    }

    public static boolean isEclipseProjectDir(File file2) {
        return file2 != null && file2.isDirectory() && new File(file2, ECLIPSE_DOT_CLASSPATH).exists() && new File(file2, ECLIPSE_DOT_PROJECT).exists();
    }

    public static boolean isAdtProjectDir(File file2) {
        return new File(file2, "AndroidManifest.xml").exists() && (GradleImport.isEclipseProjectDir(file2) || new File(file2, "res").exists() && (new File(file2, "src").exists() || new File(file2, "jni").exists()));
    }

    private static File getDirFromLocalProperties(File projectDir, String property2) {
        File localProperties = new File(projectDir, "local.properties");
        if (localProperties.exists()) {
            try {
                Properties properties2 = PropertiesFiles.getProperties(localProperties);
                String sdk = properties2.getProperty(property2);
                if (sdk != null) {
                    File dir = new File(sdk);
                    if (dir.exists()) {
                        return dir;
                    }
                    dir = new File(sdk.replace('/', File.separatorChar));
                    if (dir.exists()) {
                        return dir;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isEclipseWorkspaceDir(File file2) {
        return file2.isDirectory() && new File(file2, ".metadata" + File.separator + "version.ini").exists();
    }

    private static String generateProguardFileList(List<File> localRules, List<File> sdkRules) {
        assert (!localRules.isEmpty() || !sdkRules.isEmpty());
        StringBuilder sb = new StringBuilder();
        for (File rule : sdkRules) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("getDefaultProguardFile('");
            sb.append(ImportUtil.escapeGroovyStringLiteral(rule.getName()));
            sb.append("')");
        }
        for (File rule : localRules) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'");
            sb.append(ImportUtil.escapeGroovyStringLiteral(rule.getName()));
            sb.append("'");
        }
        return sb.toString();
    }

    private static void appendDependencies(StringBuilder sb, ImportModule module2) {
        if (!(module2.getDirectDependencies().isEmpty() && module2.getDependencies().isEmpty() && module2.getJarDependencies().isEmpty() && module2.getTestDependencies().isEmpty() && module2.getTestJarDependencies().isEmpty())) {
            String path2;
            sb.append(NL);
            sb.append("dependencies {").append(NL);
            for (ImportModule lib : module2.getDirectDependencies()) {
                if (lib.isReplacedWithDependency()) continue;
                sb.append("    compile project('").append(lib.getModuleReference()).append("')").append(NL);
            }
            for (GradleCoordinate dependency : module2.getDependencies()) {
                sb.append("    compile '").append(dependency.toString()).append("'").append(NL);
            }
            for (File jar : module2.getJarDependencies()) {
                path2 = jar.getPath().replace(File.separatorChar, '/');
                sb.append("    compile files('").append(ImportUtil.escapeGroovyStringLiteral(path2)).append("')").append(NL);
            }
            for (GradleCoordinate dependency : module2.getTestDependencies()) {
                sb.append("    androidTestCompile '").append(dependency.toString()).append("'").append(NL);
            }
            for (File jar : module2.getTestJarDependencies()) {
                path2 = jar.getPath().replace(File.separatorChar, '/');
                sb.append("    androidTestCompile files('").append(ImportUtil.escapeGroovyStringLiteral(path2)).append("')").append(NL);
            }
            sb.append("}").append(NL);
        }
    }

    private static String formatMessage(String project, File file2, String message2) {
        StringBuilder sb = new StringBuilder();
        if (project != null) {
            sb.append("Project ").append(project).append(":");
        }
        if (file2 != null) {
            sb.append(file2.getPath());
            sb.append(":\n");
        }
        sb.append(message2);
        return sb.toString();
    }

    static boolean isIgnoredFile(File file2) {
        String name = file2.getName();
        return name.equals(".svn") || name.equals(".git") || name.equals(".hg") || name.equals(".DS_Store") || name.endsWith("~") && name.length() > 1;
    }

    private static void copyTextFileWithEncoding(File source, File dest, Charset sourceEncoding) throws IOException {
        if (!Charsets.UTF_8.equals(sourceEncoding)) {
            String text2 = Files.asCharSource((File)source, (Charset)sourceEncoding).read();
            Files.asCharSink((File)dest, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)text2);
        } else {
            Files.copy((File)source, (File)dest);
        }
    }

    static boolean isTextFile(File file2) {
        String name = file2.getName();
        return name.endsWith(".java") || name.endsWith(".kt") || name.endsWith(".kts") || name.endsWith(".json") || name.endsWith(".xml") || name.endsWith(".aidl") || name.endsWith(".fs") || name.endsWith(".rs") || name.endsWith(".rsh") || name.endsWith(".txt") || name.endsWith(".gradle") || name.endsWith(".properties") || name.endsWith(".cfg") || name.endsWith(".pro") || name.endsWith(".h") || name.endsWith(".c") || name.endsWith(".cpp");
    }

    public static File computeRelativePath(File canonicalBase, File file2) throws IOException {
        File canonical = file2.getCanonicalFile();
        String canonicalPath = canonical.getPath();
        if (canonicalPath.startsWith(canonicalBase.getPath())) {
            int length = canonicalBase.getPath().length();
            if (canonicalPath.length() == length) {
                return new File(".");
            }
            if (canonicalPath.charAt(length) == File.separatorChar) {
                return new File(canonicalPath.substring(length + 1));
            }
            return new File(canonicalPath.substring(length));
        }
        return null;
    }

    public void importProjects(List<File> projectDirs) {
        this.mySummary = new ImportSummary(this);
        this.myProjectMap.clear();
        this.myHandledJars.clear();
        this.myWarnings.clear();
        this.myErrors.clear();
        this.myWorkspaceProjects = null;
        this.myRootModules = Collections.emptyList();
        this.myModules = new HashSet<ImportModule>();
        for (File file2 : projectDirs) {
            if (file2.isFile()) {
                assert (!file2.isDirectory());
                file2 = file2.getParentFile();
            }
            this.guessWorkspace(file2);
            if (GradleImport.isAdtProjectDir(file2)) {
                this.guessSdk(file2);
                this.guessNdk(file2);
                try {
                    EclipseProject.getProject(this, file2);
                    continue;
                }
                catch (ImportException importException) {
                    return;
                }
                catch (Exception exception) {
                    this.reportError(null, file2, exception.toString(), false);
                    return;
                }
            }
            this.reportError(null, file2, "Not a recognized project: " + file2, false);
            return;
        }
        HashSet projects2 = Sets.newHashSet(this.myProjectMap.values());
        this.myRootModules = EclipseProject.performImport(this, projects2);
        for (ImportModule importModule : this.myRootModules) {
            this.myModules.add(importModule);
            this.myModules.addAll(importModule.getAllDependencies());
        }
    }

    public GradleImport setCreateGradleWrapper(boolean createGradleWrapper) {
        this.myCreateGradleWrapper = createGradleWrapper;
        return this;
    }

    public File getSdkLocation() {
        return this.mySdkLocation;
    }

    public GradleImport setSdkLocation(File sdkLocation) {
        this.mySdkLocation = sdkLocation;
        return this;
    }

    public File getNdkLocation() {
        return this.myNdkLocation;
    }

    public GradleImport setNdkLocation(File ndkLocation) {
        this.myNdkLocation = ndkLocation;
        return this;
    }

    public File getEclipseWorkspace() {
        return this.myWorkspaceLocation;
    }

    public GradleImport setEclipseWorkspace(File workspace) {
        this.myWorkspaceLocation = workspace;
        assert (this.myWorkspaceLocation.exists()) : workspace.getPath();
        this.myWorkspaceProjects = null;
        return this;
    }

    public boolean isReplaceJars() {
        return this.myReplaceJars;
    }

    public GradleImport setReplaceJars(boolean replaceJars) {
        this.myReplaceJars = replaceJars;
        return this;
    }

    public boolean isReplaceLibs() {
        return this.myReplaceLibs;
    }

    public GradleImport setReplaceLibs(boolean replaceLibs) {
        this.myReplaceLibs = replaceLibs;
        return this;
    }

    public boolean isImportIntoExisting() {
        return this.myImportIntoExisting;
    }

    public void setImportIntoExisting(boolean importIntoExisting) {
        this.myImportIntoExisting = importIntoExisting;
    }

    public boolean isGradleNameStyle() {
        return this.myGradleNameStyle;
    }

    public GradleImport setGradleNameStyle(boolean lowerCase) {
        this.myGradleNameStyle = lowerCase;
        return this;
    }

    private void guessWorkspace(File projectDir) {
        if (this.myWorkspaceLocation == null) {
            for (File dir = projectDir.getParentFile(); dir != null; dir = dir.getParentFile()) {
                if (!GradleImport.isEclipseWorkspaceDir(dir)) continue;
                this.setEclipseWorkspace(dir);
                break;
            }
        }
    }

    private void guessSdk(File projectDir) {
        if (this.mySdkLocation == null) {
            this.mySdkLocation = GradleImport.getDirFromLocalProperties(projectDir, "sdk.dir");
            if (this.mySdkLocation == null && this.myWorkspaceLocation != null) {
                this.mySdkLocation = this.getDirFromWorkspaceSetting(this.getAdtSettingsFile(), "com.android.ide.eclipse.adt.sdk");
            }
        }
    }

    private void guessNdk(File projectDir) {
        if (this.myNdkLocation == null) {
            this.myNdkLocation = GradleImport.getDirFromLocalProperties(projectDir, "ndk.dir");
            if (this.myNdkLocation == null && this.myWorkspaceLocation != null) {
                this.myNdkLocation = this.getDirFromWorkspaceSetting(this.getNdkSettingsFile(), "ndkLocation");
            }
        }
    }

    private Charset getEncodingFromWorkspaceSetting() {
        if (this.myWorkspaceLocation != null && !this.myDefaultEncodingInitialized) {
            this.myDefaultEncodingInitialized = true;
            File settings = this.getEncodingSettingsFile();
            if (settings.exists()) {
                try {
                    Properties properties2 = PropertiesFiles.getProperties(settings);
                    String encodingName = properties2.getProperty("encoding");
                    if (encodingName != null) {
                        try {
                            this.myDefaultEncoding = Charset.forName(encodingName);
                        }
                        catch (UnsupportedCharsetException uce) {
                            this.reportWarning((ImportModule)null, settings, "Unknown charset " + encodingName);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.myDefaultEncoding;
    }

    private File getDirFromWorkspaceSetting(File settings, String property2) {
        if (this.myWorkspaceLocation != null && settings.exists()) {
            try {
                Properties properties2 = PropertiesFiles.getProperties(settings);
                String path2 = properties2.getProperty(property2);
                if (path2 == null) {
                    return null;
                }
                File dir = new File(path2);
                if (dir.exists()) {
                    return dir;
                }
                dir = new File(path2.replace('/', File.separatorChar));
                if (dir.exists()) {
                    return dir;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public File resolveWorkspacePath(EclipseProject fromProject, String path2, boolean record) {
        if (path2.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, File> entry : this.myPathMap.entrySet()) {
            File resolved;
            String workspacePath = entry.getKey();
            File file2 = entry.getValue();
            if (file2 == null || !path2.startsWith(workspacePath)) continue;
            if (path2.equals(workspacePath)) {
                return file2;
            }
            if ((path2 = path2.substring(workspacePath.length())).charAt(0) == '/' || path2.charAt(0) == File.separatorChar) {
                path2 = path2.substring(1);
            }
            if (!(resolved = new File(file2, path2.replace('/', File.separatorChar))).exists()) continue;
            return resolved;
        }
        if (fromProject != null && this.myWorkspaceLocation == null) {
            this.guessWorkspace(fromProject.getDir());
        }
        if (this.myWorkspaceLocation != null) {
            File project;
            char first = path2.charAt(0);
            if (first != '/') {
                return null;
            }
            File f = new File(this.myWorkspaceLocation, path2.substring(1).replace('/', File.separatorChar));
            if (f.exists()) {
                this.myPathMap.put(path2, f);
                return f;
            }
            if (this.myWorkspaceProjects == null) {
                this.myWorkspaceProjects = Maps.newHashMap();
                File projectDir = new File(this.myWorkspaceLocation, ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.core.resources" + File.separator + ".projects");
                File[] projects2 = projectDir.exists() ? projectDir.listFiles() : null;
                byte[] target = "URI//file:".getBytes(Charsets.US_ASCII);
                if (projects2 != null) {
                    for (File project2 : projects2) {
                        File location = new File(project2, ".location");
                        if (!location.exists()) continue;
                        try {
                            int end;
                            byte[] bytes = Files.toByteArray((File)location);
                            int start2 = Bytes.indexOf((byte[])bytes, (byte[])target);
                            if (start2 == -1) continue;
                            for (end = start2 + target.length; end < bytes.length && bytes[end] != 0; ++end) {
                            }
                            try {
                                int length = end - start2;
                                String s = new String(bytes, start2, length, Charsets.UTF_8);
                                s = s.substring(5);
                                File file3 = SdkUtils.urlToFile((String)s);
                                if (!file3.exists()) continue;
                                String name = project2.getName();
                                this.myWorkspaceProjects.put("/" + name, file3);
                            }
                            catch (Throwable throwable) {}
                        }
                        catch (IOException e) {
                            this.reportWarning((ImportModule)null, location, "Can't read .location file");
                        }
                    }
                }
            }
            if ((project = this.myWorkspaceProjects.get(path2)) != null) {
                this.myPathMap.put(path2, project);
                return project;
            }
            for (Map.Entry<String, File> entry : this.myWorkspaceProjects.entrySet()) {
                File resolved;
                String workspacePath = entry.getKey();
                File file4 = entry.getValue();
                if (file4 == null || !path2.startsWith(workspacePath)) continue;
                if (path2.equals(workspacePath)) {
                    return file4;
                }
                if ((path2 = path2.substring(workspacePath.length())).charAt(0) == '/' || path2.charAt(0) == File.separatorChar) {
                    path2 = path2.substring(1);
                }
                if (!(resolved = new File(file4, path2.replace('/', File.separatorChar))).exists()) continue;
                return resolved;
            }
            if (record) {
                this.myPathMap.put(path2, null);
            }
        } else if (record) {
            this.myPathMap.put(path2, null);
        }
        return null;
    }

    public void exportProject(File destDir, boolean allowNonEmpty) throws IOException {
        this.mySummary.setDestDir(destDir);
        if (!this.isImportIntoExisting()) {
            this.createDestDir(destDir, allowNonEmpty);
            GradleImport.createProjectBuildGradle(new File(destDir, "build.gradle"));
            this.exportGradleWrapper(destDir);
            this.exportLocalProperties(destDir);
        }
        this.exportSettingsGradle(new File(destDir, "settings.gradle"), this.isImportIntoExisting());
        for (ImportModule importModule : this.getModulesToImport()) {
            this.exportModule(new File(destDir, importModule.getModuleName()), importModule);
        }
        this.mySummary.write(new File(destDir, "import-summary.txt"));
    }

    private Iterable<? extends ImportModule> getModulesToImport() {
        if (this.mySelectedModules == null) {
            return this.myRootModules;
        }
        ImmutableSet.Builder builder2 = ImmutableSet.builder();
        for (ImportModule importModule : this.myRootModules) {
            File dir = importModule.getDir();
            if (!this.mySelectedModules.containsKey(dir)) continue;
            String name = this.mySelectedModules.get(dir);
            if (name != null) {
                importModule.setModuleName(name);
            }
            builder2.add((Object)importModule);
        }
        return builder2.build();
    }

    @Deprecated
    public void setModulesToImport(Map<String, File> modules) {
        this.mySelectedModules = Maps.newHashMap();
        for (File module2 : modules.values()) {
            this.mySelectedModules.put(module2, null);
        }
    }

    public List<File> exportIntoProject(File projectDir, boolean updateSettings, boolean writeSummary, Map<File, File> destDirMap) throws IOException {
        this.mySummary.setDestDir(projectDir);
        ArrayList imported = Lists.newArrayListWithExpectedSize((int)this.myRootModules.size());
        for (ImportModule importModule : this.getModulesToImport()) {
            File moduleDir = null;
            if (destDirMap != null) {
                moduleDir = destDirMap.get(importModule.getDir());
            }
            if (moduleDir == null && (moduleDir = new File(projectDir, importModule.getModuleName())).exists()) {
                importModule.pickUniqueName(projectDir);
                moduleDir = new File(projectDir, importModule.getModuleName());
                assert (!moduleDir.exists());
            }
            this.exportModule(moduleDir, importModule);
            imported.add(moduleDir);
        }
        if (updateSettings) {
            this.exportSettingsGradle(new File(projectDir, "settings.gradle"), true);
        }
        if (writeSummary) {
            this.mySummary.write(new File(projectDir, "import-summary.txt"));
        }
        return imported;
    }

    private void exportGradleWrapper(File destDir) throws IOException {
        if (!this.myCreateGradleWrapper) {
            return;
        }
        GradleWrapper.create(destDir, "6.7.1", null);
        File gradlewDest = new File(destDir, "gradlew");
        if (!gradlewDest.canExecute()) {
            this.reportWarning((ImportModule)null, gradlewDest, "Gradle wrapper script is not executable");
        }
    }

    private void exportLocalProperties(File destDir) throws IOException {
        boolean needsNdk = this.needsNdk();
        if (this.myNdkLocation != null && needsNdk || this.mySdkLocation != null) {
            Properties properties2 = new Properties();
            if (this.mySdkLocation != null) {
                properties2.setProperty("sdk.dir", this.mySdkLocation.getPath());
            }
            if (this.myNdkLocation != null && needsNdk) {
                properties2.setProperty("ndk.dir", this.myNdkLocation.getPath());
            }
            File path2 = new File(destDir, "local.properties");
            String comments = "# This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n\n# Location of the SDK. This is only used by Gradle.\n";
            PropertiesFiles.savePropertiesToFile(properties2, path2, comments);
        }
    }

    public boolean needsNdk() {
        for (ImportModule module2 : this.myModules) {
            if (!module2.isNdkProject()) continue;
            return true;
        }
        return false;
    }

    private void exportModule(File destDir, ImportModule module2) throws IOException {
        this.mkdirs(destDir);
        this.createModuleBuildGradle(new File(destDir, "build.gradle"), module2);
        module2.copyInto(destDir);
    }

    public void mkdirs(File destDir) {
        boolean ok;
        if (!destDir.exists() && !(ok = destDir.mkdirs())) {
            this.reportError(null, destDir, "Could not make directory " + destDir);
        }
    }

    private void createModuleBuildGradle(File file2, ImportModule module2) throws IOException {
        StringBuilder sb = new StringBuilder(500);
        if (module2.isApp() || module2.isAndroidLibrary()) {
            String languageLevel;
            if (module2.isApp()) {
                sb.append("apply plugin: 'com.android.application'").append(NL);
            } else {
                assert (module2.isAndroidLibrary());
                sb.append("apply plugin: 'com.android.library'").append(NL);
            }
            sb.append(NL);
            sb.append("android {").append(NL);
            AndroidVersion compileSdkVersion2 = module2.getCompileSdkVersion();
            AndroidVersion minSdkVersion2 = module2.getMinSdkVersion();
            AndroidVersion targetSdkVersion2 = module2.getTargetSdkVersion();
            Object compileSdkVersionString = compileSdkVersion2.isPreview() ? "'" + AndroidTargetHash.getPlatformHashString((AndroidVersion)compileSdkVersion2) + "'" : Integer.toString(compileSdkVersion2.getApiLevel());
            String addOn = module2.getAddOn();
            if (addOn != null) {
                compileSdkVersionString = "'" + addOn + "'";
            }
            Object minSdkVersionString = minSdkVersion2.isPreview() ? "'" + module2.getMinSdkVersion().getCodename() + "'" : Integer.toString(module2.getMinSdkVersion().getApiLevel());
            Object targetSdkVersionString = targetSdkVersion2.isPreview() ? "'" + module2.getTargetSdkVersion().getCodename() + "'" : Integer.toString(module2.getTargetSdkVersion().getApiLevel());
            sb.append("    compileSdkVersion ").append((String)compileSdkVersionString).append(NL);
            sb.append("    buildToolsVersion \"").append(this.getBuildToolsVersion()).append("\"").append(NL);
            sb.append(NL);
            sb.append("    defaultConfig {").append(NL);
            if (module2.getPackage() != null && module2.isApp()) {
                sb.append("        applicationId \"").append(module2.getPackage()).append('\"').append(NL);
            }
            if (minSdkVersion2.getApiLevel() > 1) {
                sb.append("        minSdkVersion ").append((String)minSdkVersionString).append(NL);
            }
            if (targetSdkVersion2.getApiLevel() > 1 && compileSdkVersion2.getApiLevel() > 3) {
                sb.append("        targetSdkVersion ").append((String)targetSdkVersionString).append(NL);
            }
            if (!(languageLevel = module2.getLanguageLevel()).equals("1.6")) {
                sb.append("        compileOptions {").append(NL);
                String level = languageLevel.replace('.', '_');
                sb.append("            sourceCompatibility JavaVersion.VERSION_").append(level).append(NL);
                sb.append("            targetCompatibility JavaVersion.VERSION_").append(level).append(NL);
                sb.append("        }").append(NL);
            }
            if (module2.isNdkProject() && module2.getNativeModuleName() != null) {
                sb.append(NL);
                sb.append("        ndk {").append(NL);
                sb.append("            moduleName \"").append(module2.getNativeModuleName()).append("\"").append(NL);
                sb.append("        }").append(NL);
            }
            if (module2.getInstrumentationDir() != null) {
                sb.append(NL);
                File manifestFile = new File(module2.getInstrumentationDir(), "AndroidManifest.xml");
                assert (manifestFile.exists()) : manifestFile;
                Document manifest = this.getXmlDocument(manifestFile, true);
                if (manifest != null && manifest.getDocumentElement() != null) {
                    NodeList list;
                    String pkg = manifest.getDocumentElement().getAttribute("package");
                    if (pkg != null && !pkg.isEmpty()) {
                        sb.append("        testApplicationId \"").append(pkg).append("\"").append(NL);
                    }
                    if ((list = manifest.getElementsByTagName("instrumentation")).getLength() > 0) {
                        Attr attr2;
                        Element tag = (Element)list.item(0);
                        String runner = tag.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (runner != null && !runner.isEmpty()) {
                            sb.append("        testInstrumentationRunner \"").append(runner).append("\"").append(NL);
                        }
                        if ((attr2 = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "functionalTest")) != null) {
                            sb.append("        testFunctionalTest ").append(attr2.getValue()).append(NL);
                        }
                        if ((attr2 = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "handleProfiling")) != null) {
                            sb.append("        testHandlingProfiling ").append(attr2.getValue()).append(NL);
                        }
                    }
                }
            }
            sb.append("    }").append(NL);
            sb.append(NL);
            List<File> localRules = module2.getLocalProguardFiles();
            List<File> sdkRules = module2.getSdkProguardFiles();
            if (!localRules.isEmpty() || !sdkRules.isEmpty()) {
                sb.append("    buildTypes {").append(NL);
                sb.append("        release {").append(NL);
                sb.append("            minifyEnabled true").append(NL);
                sb.append("            proguardFiles ");
                sb.append(GradleImport.generateProguardFileList(localRules, sdkRules)).append(NL);
                sb.append("        }").append(NL);
                sb.append("    }").append(NL);
            } else {
                sb.append("    buildTypes {").append(NL);
                sb.append("        release {").append(NL);
                sb.append("            minifyEnabled false").append(NL);
                sb.append("            proguardFiles getDefaultProguardFile('proguard-android.txt'), 'proguard-rules.txt'").append(NL);
                sb.append("        }").append(NL);
                sb.append("    }").append(NL);
            }
            sb.append("}").append(NL);
            GradleImport.appendDependencies(sb, module2);
        } else if (module2.isJavaLibrary()) {
            sb.append("apply plugin: 'java'").append(NL);
            String languageLevel = module2.getLanguageLevel();
            if (!languageLevel.equals("1.6")) {
                sb.append(NL);
                sb.append("sourceCompatibility = \"");
                sb.append(languageLevel);
                sb.append("\"").append(NL);
                sb.append("targetCompatibility = \"");
                sb.append(languageLevel);
                sb.append("\"").append(NL);
            }
            GradleImport.appendDependencies(sb, module2);
        } else assert (false) : module2;
        Files.asCharSink((File)file2, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)sb.toString());
    }

    String getBuildToolsVersion() {
        AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((File)this.mySdkLocation);
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        return GradleBuildSettings.getRecommendedBuildToolsRevision(sdkHandler, (ProgressIndicator)progress).toString();
    }

    private static void createProjectBuildGradle(File file2) throws IOException {
        String sb = "// Top-level build file where you can add configuration options common to all sub-projects/modules." + NL + "buildscript {" + NL + "    repositories {" + NL + "        " + MAVEN_REPOSITORY + NL + "    }" + NL + "    dependencies {" + NL + "        classpath '" + ANDROID_GRADLE_PLUGIN + "'" + NL + "    }" + NL + "}" + NL + NL + "allprojects {" + NL + "    repositories {" + NL + "        " + MAVEN_REPOSITORY + NL + "    }" + NL + "}" + NL;
        Files.asCharSink((File)file2, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)sb);
    }

    private void exportSettingsGradle(File file2, boolean append) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (append) {
            if (!file2.exists()) {
                append = false;
            } else {
                String existing2 = Files.asCharSource((File)file2, (Charset)Charsets.UTF_8).read();
                if (!existing2.endsWith(NL)) {
                    sb.append(NL);
                }
            }
        }
        for (ImportModule importModule : this.getModulesToImport()) {
            sb.append("include '");
            sb.append(importModule.getModuleReference());
            sb.append("'");
            sb.append(NL);
        }
        String code = sb.toString();
        if (append) {
            Files.asCharSink((File)file2, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)code);
        } else {
            Files.asCharSink((File)file2, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)code);
        }
    }

    private void createDestDir(File destDir, boolean allowNonEmpty) throws IOException {
        if (destDir.exists()) {
            File[] files2;
            if (!allowNonEmpty && (files2 = destDir.listFiles()) != null && files2.length > 0) {
                throw new IOException("Destination directory " + destDir + " should be empty");
            }
        } else {
            this.mkdirs(destDir);
        }
    }

    public List<String> getWarnings() {
        return this.myWarnings;
    }

    public List<String> getErrors() {
        return this.myErrors;
    }

    public Map<String, File> getDetectedModuleLocations() {
        TreeMap<String, File> modules = new TreeMap<String, File>();
        for (ImportModule module2 : this.myModules) {
            modules.put(module2.getModuleName(), module2.getCanonicalModuleDir());
        }
        return modules;
    }

    public void setImportModuleNames(Map<File, String> moduleLocationToName) {
        this.mySelectedModules = ImmutableMap.copyOf(moduleLocationToName);
    }

    @NotNull
    public Set<String> getProjectDependencies(String projectName) {
        ImportModule module2 = null;
        for (ImportModule m : this.myModules) {
            if (!Objects.equal((Object)m.getModuleName(), (Object)projectName)) continue;
            module2 = m;
            break;
        }
        if (module2 == null) {
            ImmutableSet immutableSet = ImmutableSet.of();
            if (immutableSet == null) {
                GradleImport.$$$reportNull$$$0(0);
            }
            return immutableSet;
        }
        ImmutableSet.Builder deps = ImmutableSet.builder();
        for (ImportModule importModule : module2.getAllDependencies()) {
            deps.add((Object)importModule.getModuleName());
        }
        ImmutableSet immutableSet = deps.build();
        if (immutableSet == null) {
            GradleImport.$$$reportNull$$$0(1);
        }
        return immutableSet;
    }

    public void reportError(EclipseProject project, File file2, String message2) {
        this.reportError(project, file2, message2, true);
    }

    public void reportError(EclipseProject project, File file2, String message2, boolean abort) {
        String text2 = GradleImport.formatMessage(project != null ? project.getName() : null, file2, message2);
        this.myErrors.add(text2);
        if (abort) {
            throw new ImportException(text2);
        }
    }

    public void reportWarning(ImportModule module2, File file2, String message2) {
        String moduleName2 = module2 != null ? module2.getOriginalName() : null;
        this.myWarnings.add(GradleImport.formatMessage(moduleName2, file2, message2));
    }

    public void reportWarning(EclipseProject project, File file2, String message2) {
        String moduleName2 = project != null ? project.getName() : null;
        this.myWarnings.add(GradleImport.formatMessage(moduleName2, file2, message2));
    }

    File resolvePathVariable(EclipseProject fromProject, String name, boolean record) throws IOException {
        File file2 = this.myPathMap.get(name);
        if (file2 != null) {
            return file2;
        }
        if (fromProject != null && this.myWorkspaceLocation == null) {
            this.guessWorkspace(fromProject.getDir());
        }
        String value2 = null;
        Properties properties2 = this.getJdtSettingsProperties(false);
        if (properties2 != null) {
            value2 = properties2.getProperty("org.eclipse.jdt.core.classpathVariable." + name);
        }
        if (value2 == null && (properties2 = this.getPathSettingsProperties(false)) != null) {
            value2 = properties2.getProperty("pathvariable." + name);
        }
        if (value2 == null) {
            if (record) {
                this.myPathMap.put(name, null);
            }
            return null;
        }
        file2 = new File(value2.replace('/', File.separatorChar));
        return file2;
    }

    private Properties getJdtSettingsProperties(boolean mustExist) throws IOException {
        File settings = this.getJdtSettingsFile();
        if (!settings.exists()) {
            if (mustExist) {
                this.reportError(null, settings, "Settings file does not exist");
            }
            return null;
        }
        return PropertiesFiles.getProperties(settings);
    }

    private File getRuntimeSettingsDir() {
        return new File(this.getWorkspaceLocation(), ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.core.runtime" + File.separator + ".settings");
    }

    private File getJdtSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "org.eclipse.jdt.core.prefs");
    }

    private File getPathSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "org.eclipse.core.resources.prefs");
    }

    private File getEncodingSettingsFile() {
        return this.getPathSettingsFile();
    }

    private File getNdkSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "com.android.ide.eclipse.ndk.prefs");
    }

    private File getAdtSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "com.android.ide.eclipse.adt.prefs");
    }

    private Properties getPathSettingsProperties(boolean mustExist) throws IOException {
        File settings = this.getPathSettingsFile();
        if (!settings.exists()) {
            if (mustExist) {
                this.reportError(null, settings, "Settings file does not exist");
            }
            return null;
        }
        return PropertiesFiles.getProperties(settings);
    }

    private File getWorkspaceLocation() {
        return this.myWorkspaceLocation;
    }

    Document getXmlDocument(File file2, boolean namespaceAware) throws IOException {
        String xml = Files.asCharSource((File)file2, (Charset)Charsets.UTF_8).read();
        try {
            return XmlUtils.parseDocument((String)xml, (boolean)namespaceAware);
        }
        catch (Exception e) {
            this.reportError(null, file2, "Invalid XML file: " + file2.getPath() + ":\n" + e.getMessage());
            return null;
        }
    }

    Map<File, EclipseProject> getProjectMap() {
        return this.myProjectMap;
    }

    public ImportSummary getSummary() {
        return this.mySummary;
    }

    void registerProject(EclipseProject project) {
        this.myProjectMap.put(project.getDir(), project);
        this.myProjectMap.put(project.getDir().getAbsoluteFile(), project);
        this.myProjectMap.put(project.getCanonicalDir(), project);
    }

    int getModuleCount() {
        int moduleCount = 0;
        for (ImportModule module2 : this.myModules) {
            if (module2.isReplacedWithDependency()) continue;
            ++moduleCount;
        }
        return moduleCount;
    }

    public Map<String, File> getPathMap() {
        return this.myPathMap;
    }

    public void copyDir(File source, File dest, CopyHandler handler2, boolean updateEncoding, ImportModule sourceModule) throws IOException {
        if (handler2 != null && handler2.handle(source, dest, updateEncoding, sourceModule)) {
            return;
        }
        if (source.isDirectory()) {
            File[] copied;
            if (GradleImport.isIgnoredFile(source)) {
                return;
            }
            this.mkdirs(dest);
            File[] files2 = source.listFiles();
            if (files2 != null) {
                for (File child : files2) {
                    this.copyDir(child, new File(dest, child.getName()), handler2, updateEncoding, sourceModule);
                }
            }
            if ((copied = dest.listFiles()) != null && copied.length == 0) {
                dest.delete();
            }
        } else if (updateEncoding && GradleImport.isTextFile(source) && !source.getPath().endsWith(".properties")) {
            this.copyTextFile(sourceModule, source, dest);
        } else {
            Files.copy((File)source, (File)dest);
        }
    }

    public void copyTextFile(ImportModule module2, File source, File dest) throws IOException {
        assert (GradleImport.isTextFile(source)) : source;
        Charset encoding = null;
        if (module2 != null) {
            encoding = module2.getFileEncoding(source);
            if (encoding != null) {
                GradleImport.copyTextFileWithEncoding(source, dest, encoding);
                return;
            }
            encoding = module2.getProjectEncoding(source);
        }
        if (encoding == null) {
            encoding = this.getEncodingFromWorkspaceSetting();
        }
        if (SdkUtils.endsWithIgnoreCase((String)source.getPath(), (String)".xml")) {
            int prologueEnd;
            String defaultCharset = encoding != null ? encoding.name() : "UTF-8";
            Object xml = PositionXmlParser.getXmlString((byte[])Files.toByteArray((File)source), (String)defaultCharset);
            if (((String)xml).startsWith("<?xml") && (prologueEnd = ((String)xml).indexOf("?>")) != -1) {
                xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + ((String)xml).substring(prologueEnd + 2);
            }
            Files.asCharSink((File)dest, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)xml);
        } else if (encoding != null) {
            GradleImport.copyTextFileWithEncoding(source, dest, encoding);
        } else {
            Files.copy((File)source, (File)dest);
        }
    }

    void markJarHandled(File file2) {
        this.myHandledJars.add(file2.getName());
    }

    boolean isJarHandled(File file2) {
        return this.myHandledJars.contains(file2.getName());
    }

    static {
        Object repository = System.getProperty(MAVEN_URL_PROPERTY);
        repository = repository == null ? "jcenter()" : "jcenter();" + NL + "        maven { url '" + (String)repository + "' }";
        MAVEN_REPOSITORY = repository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/adtimport/GradleImport", "getProjectDependencies"));
    }

    private static class ImportException
    extends RuntimeException {
        private String mMessage;

        private ImportException(String message2) {
            this.mMessage = message2;
        }

        @Override
        public String getMessage() {
            return this.mMessage;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    public static interface CopyHandler {
        public boolean handle(File var1, File var2, boolean var3, ImportModule var4) throws IOException;
    }
}

