/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.adtimport;

import com.android.tools.idea.gradle.adtimport.AdtImportBuilder;
import com.android.tools.idea.gradle.adtimport.AdtImportProvider;
import com.android.tools.idea.gradle.adtimport.GradleImport;
import com.android.tools.idea.gradle.adtimport.actions.AndroidImportProjectAction;
import com.android.tools.idea.gradle.project.AndroidModuleImporter;
import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.utils.BuildScriptUtil;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class AdtModuleImporter
extends ModuleImporter {
    @NotNull
    private final WizardContext myContext;
    @NotNull
    private final AdtImportProvider myProvider;
    private List<ModuleWizardStep> myWizardSteps;

    private AdtModuleImporter(@NotNull WizardContext context) {
        if (context == null) {
            AdtModuleImporter.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myProvider = new AdtImportProvider(false);
        this.myContext.setProjectBuilder((ProjectBuilder)this.myProvider.getBuilder());
    }

    public static boolean isAdtProjectLocation(@NotNull VirtualFile importSource) {
        VirtualFile target;
        if (importSource == null) {
            AdtModuleImporter.$$$reportNull$$$0(1);
        }
        VirtualFile targetDir = (target = AndroidImportProjectAction.findImportTarget(importSource)).isDirectory() ? target : target.getParent();
        File targetDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)targetDir);
        return GradleImport.isAdtProjectDir(targetDirFile) && !BuildScriptUtil.findGradleBuildFile((File)targetDirFile).isFile();
    }

    @Override
    @NotNull
    public List<? extends ModuleWizardStep> createWizardSteps() {
        Object[] adtImportSteps = this.myProvider.createSteps(this.myContext);
        this.myWizardSteps = Lists.newArrayList((Object[])adtImportSteps);
        List<ModuleWizardStep> list = this.myWizardSteps;
        if (list == null) {
            AdtModuleImporter.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void importProjects(Map<String, VirtualFile> projects2) {
        Project project = this.myContext.getProject();
        assert (project != null);
        AdtImportBuilder builder2 = AdtImportBuilder.getBuilder(this.myContext);
        assert (builder2 != null);
        GradleImport importer = this.getGradleImport();
        ImmutableMap.Builder modules = ImmutableMap.builder();
        for (Map.Entry<String, VirtualFile> entry : projects2.entrySet()) {
            modules.put((Object)VfsUtilCore.virtualToIoFile((VirtualFile)entry.getValue()), (Object)GradleUtil.getDefaultPhysicalPathFromGradlePath(entry.getKey()));
        }
        importer.setImportModuleNames((Map<File, String>)modules.build());
        if (builder2.validate(null, project)) {
            builder2.commit(project, null, ModulesProvider.EMPTY_MODULES_PROVIDER, null);
            builder2.cleanup();
        }
    }

    @NotNull
    private GradleImport getGradleImport() {
        AdtImportBuilder builder2 = AdtImportBuilder.getBuilder(this.myContext);
        assert (builder2 != null);
        GradleImport importer = builder2.getImporter();
        assert (importer != null);
        GradleImport gradleImport = importer;
        if (gradleImport == null) {
            AdtModuleImporter.$$$reportNull$$$0(3);
        }
        return gradleImport;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean canImport(@NotNull VirtualFile importSource) {
        if (importSource == null) {
            AdtModuleImporter.$$$reportNull$$$0(4);
        }
        return AdtModuleImporter.isAdtProjectLocation(importSource);
    }

    @Override
    @NotNull
    public Set<ModuleToImport> findModules(@NotNull VirtualFile importSource) throws IOException {
        if (importSource == null) {
            AdtModuleImporter.$$$reportNull$$$0(5);
        }
        AdtImportBuilder builder2 = (AdtImportBuilder)this.myContext.getProjectBuilder();
        assert (builder2 != null);
        builder2.setSelectedProject(VfsUtilCore.virtualToIoFile((VirtualFile)importSource));
        final GradleImport gradleImport = this.getGradleImport();
        gradleImport.importProjects(Collections.singletonList(VfsUtilCore.virtualToIoFile((VirtualFile)importSource)));
        Map<String, File> adtProjects = gradleImport.getDetectedModuleLocations();
        HashSet<ModuleToImport> modules = new HashSet<ModuleToImport>();
        for (final Map.Entry<String, File> entry : adtProjects.entrySet()) {
            VirtualFile location = VfsUtil.findFileByIoFile((File)entry.getValue(), (boolean)false);
            modules.add(new ModuleToImport(entry.getKey(), location, (Supplier<? extends Iterable<String>>)new Supplier<Iterable<String>>(){

                public Iterable<String> get() {
                    return gradleImport.getProjectDependencies((String)entry.getKey());
                }
            }));
        }
        HashSet<ModuleToImport> hashSet = modules;
        if (hashSet == null) {
            AdtModuleImporter.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Override
    public boolean isStepVisible(@NotNull ModuleWizardStep step2) {
        if (step2 == null) {
            AdtModuleImporter.$$$reportNull$$$0(7);
        }
        return this.myWizardSteps.contains(step2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSource";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/adtimport/AdtModuleImporter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/adtimport/AdtModuleImporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createWizardSteps";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleImport";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAdtProjectLocation";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canImport";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isStepVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AdtAndroidModuleImporter
    implements AndroidModuleImporter {
        @Override
        @NotNull
        public ModuleImporter create(@NotNull WizardContext context) {
            if (context == null) {
                AdtAndroidModuleImporter.$$$reportNull$$$0(0);
            }
            return new AdtModuleImporter(context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/adtimport/AdtModuleImporter$AdtAndroidModuleImporter", "create"));
        }
    }
}

