/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.adtimport;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.adtimport.GradleImport;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.util.EditorUtil;
import com.android.tools.idea.util.ToolWindows;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdtImportBuilder
extends ProjectImportBuilder<String> {
    private File mySelectedProject;
    private GradleImport myImporter;
    private final boolean myCreateProject;

    public AdtImportBuilder(boolean createProject) {
        this.myCreateProject = createProject;
    }

    @NotNull
    public String getName() {
        return "ADT (Eclipse Android)";
    }

    public void setSelectedProject(@NotNull File selectedProject) {
        if (selectedProject == null) {
            AdtImportBuilder.$$$reportNull$$$0(0);
        }
        this.mySelectedProject = selectedProject;
        List<File> projects2 = Collections.singletonList(this.mySelectedProject);
        this.myImporter = this.createImporter(projects2);
    }

    @NotNull
    private GradleImport createImporter(@NotNull List<File> projects2) {
        if (projects2 == null) {
            AdtImportBuilder.$$$reportNull$$$0(1);
        }
        GradleImport importer = new GradleImport();
        importer.setImportIntoExisting(!this.myCreateProject);
        if (this.myCreateProject) {
            importer.setCreateGradleWrapper(true);
            AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
            if (sdkData != null) {
                importer.setSdkLocation(sdkData.getLocation());
            }
        }
        importer.importProjects(projects2);
        GradleImport gradleImport = importer;
        if (gradleImport == null) {
            AdtImportBuilder.$$$reportNull$$$0(2);
        }
        return gradleImport;
    }

    @Nullable
    public GradleImport getImporter() {
        return this.myImporter;
    }

    public Icon getIcon() {
        return AllIcons.Providers.Eclipse;
    }

    public boolean isMarked(String element2) {
        return false;
    }

    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @Nullable
    public List<Module> commit(Project project, @Nullable ModifiableModuleModel model2, ModulesProvider modulesProvider, @Nullable ModifiableArtifactModel artifactModel) {
        File destDir = Projects.getBaseDirPath((Project)project);
        try {
            boolean ok;
            if (!destDir.exists() && !(ok = destDir.mkdirs())) {
                throw new IOException("Could not create destination directory");
            }
            this.readProjects();
            if (!this.myImporter.getErrors().isEmpty()) {
                return null;
            }
            this.myImporter.exportProject(destDir, true);
            project.getBaseDir().refresh(false, true);
        }
        catch (IOException e) {
            Logger.getInstance(AdtImportBuilder.class).error((Throwable)e);
            return null;
        }
        try {
            GradleSyncListener syncListener = new GradleSyncListener(){

                @Override
                public void syncSucceeded(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ToolWindows.activateProjectView(project);
                        AdtImportBuilder.openSummary(project);
                    });
                }

                @Override
                public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> AdtImportBuilder.openSummary(project));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/gradle/adtimport/AdtImportBuilder$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "syncSucceeded";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "syncFailed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            GradleProjectImporter importer = GradleProjectImporter.getInstance();
            if (this.myCreateProject) {
                GradleProjectImporter.Request request = new GradleProjectImporter.Request(project);
                request.isNewProject = true;
                importer.importProjectNoSync(request);
                Path projectDir = Projects.getBaseDirPath((Project)request.project).getAbsoluteFile().toPath();
                ProjectManagerEx.getInstanceEx().openProject(projectDir, new OpenProjectTask(true, null, false, false, project, null, true, null, null, -1, -1, true, false, true, null, false, false, null, null, null));
            } else {
                GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_IMPORT_ADT_MODULE, syncListener);
            }
        }
        catch (Throwable e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"ADT Project Import");
        }
        return Collections.emptyList();
    }

    public void readProjects() {
        this.myImporter.importProjects(Collections.singletonList(this.mySelectedProject));
    }

    private static void openSummary(Project project) {
        VirtualFile summary = project.getBaseDir().findChild("import-summary.txt");
        if (summary != null) {
            EditorUtil.openEditor(project, summary);
        }
    }

    @Nullable
    public static AdtImportBuilder getBuilder(@Nullable WizardContext context) {
        if (context != null) {
            return (AdtImportBuilder)context.getProjectBuilder();
        }
        return null;
    }

    @Nullable
    public Project createProject(String name, String path2) {
        return GradleProjectImporter.getInstance().createProject(name, new File(path2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/adtimport/AdtImportBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/adtimport/AdtImportBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createImporter";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

