/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.build.OutputFile;
import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.VariantBuildOutput;
import com.android.ide.common.gradle.model.IdeAndroidArtifactOutput;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.util.GradleBuildOutputUtil;
import com.android.tools.idea.gradle.util.OutputType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildsToPathsMapper {
    @NotNull
    public static BuildsToPathsMapper getInstance(@NotNull Project project) {
        if (project == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(0);
        }
        BuildsToPathsMapper buildsToPathsMapper = (BuildsToPathsMapper)project.getService(BuildsToPathsMapper.class);
        if (buildsToPathsMapper == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(1);
        }
        return buildsToPathsMapper;
    }

    @NotNull
    Map<String, File> getBuildsToPaths(@Nullable Object model2, @NotNull List<String> buildVariants, @NotNull Collection<Module> modules, boolean isAppBundle, @Nullable String signedApkOrBundlePath) {
        boolean isSigned;
        if (buildVariants == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(2);
        }
        if (modules == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(3);
        }
        boolean bl = isSigned = !buildVariants.isEmpty();
        if (isSigned) assert (modules.size() == 1);
        PostBuildModel postBuildModel = null;
        TreeMap<String, File> buildsToPathsCollector = new TreeMap<String, File>();
        if (model2 instanceof OutputBuildAction.PostBuildProjectModels) {
            postBuildModel = new PostBuildModel((OutputBuildAction.PostBuildProjectModels)model2);
        }
        for (Module module2 : modules) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
            if (androidModel == null) continue;
            if (!isSigned) {
                buildVariants = ImmutableList.singleton((Object)androidModel.getSelectedVariant().getName());
            }
            for (String buildVariant : buildVariants) {
                BuildsToPathsMapper.collectBuildsToPaths(androidModel, postBuildModel, module2, buildVariant, buildsToPathsCollector, isAppBundle, isSigned, signedApkOrBundlePath);
            }
        }
        TreeMap<String, File> treeMap = buildsToPathsCollector;
        if (treeMap == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(4);
        }
        return treeMap;
    }

    private static void collectBuildsToPaths(@NotNull AndroidModuleModel androidModel, @Nullable PostBuildModel postBuildModel, @NotNull Module module2, @NotNull String buildVariant, @NotNull Map<String, File> buildsToPathsCollector, boolean isAppBundle, boolean isSigned, @Nullable String signedApkOrBundlePath) {
        if (androidModel == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(5);
        }
        if (module2 == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(6);
        }
        if (buildVariant == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(7);
        }
        if (buildsToPathsCollector == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(8);
        }
        File outputFolderOrFile = null;
        if (androidModel.getFeatures().isBuildOutputFileSupported()) {
            OutputType outputType = isAppBundle ? OutputType.Bundle : OutputType.Apk;
            outputFolderOrFile = GradleBuildOutputUtil.getOutputFileOrFolderFromListingFile(androidModel, buildVariant, outputType, false);
        } else if (postBuildModel != null) {
            if (androidModel.getAndroidProject().getProjectType() == 0 || androidModel.getAndroidProject().getProjectType() == 6) {
                outputFolderOrFile = isAppBundle ? BuildsToPathsMapper.tryToGetOutputPostBuildBundleFile(module2, postBuildModel, buildVariant) : BuildsToPathsMapper.tryToGetOutputPostBuildApkFile(module2, postBuildModel, buildVariant);
            } else if (androidModel.getAndroidProject().getProjectType() == 4) {
                outputFolderOrFile = BuildsToPathsMapper.tryToGetOutputPostBuildInstantApp(module2, postBuildModel, buildVariant);
            }
        }
        if (outputFolderOrFile == null) {
            if (isSigned) {
                assert (signedApkOrBundlePath != null);
                outputFolderOrFile = new File(signedApkOrBundlePath);
            } else if (!isAppBundle) {
                outputFolderOrFile = BuildsToPathsMapper.tryToGetOutputPreBuild(androidModel);
            }
        }
        if (outputFolderOrFile == null) {
            return;
        }
        buildsToPathsCollector.put(isSigned ? buildVariant : module2.getName(), outputFolderOrFile);
    }

    @Nullable
    private static File tryToGetOutputPostBuildApkFile(@NotNull Module module2, @NotNull PostBuildModel postBuildModel, @NotNull String buildVariant) {
        ProjectBuildOutput projectBuildOutput;
        if (module2 == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(9);
        }
        if (postBuildModel == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(10);
        }
        if (buildVariant == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(11);
        }
        if ((projectBuildOutput = postBuildModel.findProjectBuildOutput(module2)) == null) {
            return null;
        }
        for (VariantBuildOutput variantBuildOutput : projectBuildOutput.getVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(buildVariant)) continue;
            Collection outputs = variantBuildOutput.getOutputs();
            File outputFolderOrApk = ((OutputFile)outputs.iterator().next()).getOutputFile();
            if (outputs.size() > 1) {
                return outputFolderOrApk.getParentFile();
            }
            return outputFolderOrApk;
        }
        return null;
    }

    @Nullable
    private static File tryToGetOutputPostBuildBundleFile(@NotNull Module module2, @NotNull PostBuildModel postBuildModel, @NotNull String buildVariant) {
        AppBundleProjectBuildOutput appBundleProjectBuildOutput;
        if (module2 == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(12);
        }
        if (postBuildModel == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(13);
        }
        if (buildVariant == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(14);
        }
        if ((appBundleProjectBuildOutput = postBuildModel.findAppBundleProjectBuildOutput(module2)) == null) {
            return null;
        }
        for (AppBundleVariantBuildOutput variantBuildOutput : appBundleProjectBuildOutput.getAppBundleVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(buildVariant)) continue;
            return variantBuildOutput.getBundleFile();
        }
        return null;
    }

    @Nullable
    private static File tryToGetOutputPostBuildInstantApp(@NotNull Module module2, @NotNull PostBuildModel postBuildModel, @NotNull String buildVariant) {
        InstantAppProjectBuildOutput instantAppProjectBuildOutput;
        if (module2 == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(15);
        }
        if (postBuildModel == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(16);
        }
        if (buildVariant == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(17);
        }
        if ((instantAppProjectBuildOutput = postBuildModel.findInstantAppProjectBuildOutput(module2)) == null) {
            return null;
        }
        for (InstantAppVariantBuildOutput variantBuildOutput : instantAppProjectBuildOutput.getInstantAppVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(buildVariant)) continue;
            return variantBuildOutput.getOutput().getOutputFile();
        }
        return null;
    }

    @Nullable
    private static File tryToGetOutputPreBuild(@NotNull AndroidModuleModel androidModel) {
        List outputs;
        if (androidModel == null) {
            BuildsToPathsMapper.$$$reportNull$$$0(18);
        }
        if ((outputs = androidModel.getMainArtifact().getOutputs()).isEmpty()) {
            return null;
        }
        File outputFolderOrApk = ((IdeAndroidArtifactOutput)outputs.iterator().next()).getOutputFile();
        if (outputs.size() > 1) {
            return outputFolderOrApk.getParentFile();
        }
        return outputFolderOrApk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/actions/BuildsToPathsMapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariants";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariant";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildsToPathsCollector";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postBuildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/actions/BuildsToPathsMapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildsToPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBuildsToPaths";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectBuildsToPaths";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToGetOutputPostBuildApkFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryToGetOutputPostBuildBundleFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryToGetOutputPostBuildInstantApp";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryToGetOutputPreBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

