/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeDependencies;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class AndroidGradleJavaProjectModelModifier
extends JavaProjectModelModifier {
    @NotNull
    private static final Map<String, String> EXTERNAL_LIBRARY_VERSIONS = ImmutableMap.of((Object)"net.jcip:jcip-annotations", (Object)"1.0", (Object)"org.jetbrains:annotations-java5", (Object)"15.0", (Object)"org.jetbrains:annotations", (Object)"15.0", (Object)"junit:junit", (Object)"4.12", (Object)"org.testng:testng", (Object)"6.9.6");
    @NotNull
    private static final Set<String> ANDROID_PLUGIN_IDENTIFIERS = ImmutableSet.of((Object)"android", (Object)"android-library", (Object)"com.android.application", (Object)"com.android.library", (Object)"com.android.instantapp", (Object)"com.android.feature", (Object[])new String[]{"com.android.dynamic-feature", "com.android.test"});
    @NotNull
    private static final Set<String> JAVA_PLUGIN_IDENTIFIERS = ImmutableSet.of((Object)"java", (Object)"java-library");

    private static boolean isAndroidGradleProject(@NotNull Project project) {
        if (project == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(0);
        }
        return AndroidProjectInfo.getInstance(project).requiresAndroidModel();
    }

    @Nullable
    private static String getSingleExternalProjectPathOrNull(Collection<? extends Module> modules) {
        String projectPath = null;
        for (Module module2 : modules) {
            String rootProjectPathForModule = AndroidGradleJavaProjectModelModifier.getSingleExternalProjectPathOrNull(module2);
            if (rootProjectPathForModule == null) {
                return null;
            }
            if (projectPath == null) {
                projectPath = rootProjectPathForModule;
                continue;
            }
            if (projectPath.equals(rootProjectPathForModule)) continue;
            return null;
        }
        return projectPath;
    }

    @Nullable
    private static String getSingleExternalProjectPathOrNull(Module module2) {
        return ExternalSystemModulePropertyManager.getInstance((Module)module2).getRootProjectPath();
    }

    @Nullable
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope2, boolean exported) {
        String externalProjectPath;
        if (from == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(1);
        }
        if (to == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(2);
        }
        if (scope2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(3);
        }
        if ((externalProjectPath = AndroidGradleJavaProjectModelModifier.getSingleExternalProjectPathOrNull(from)) == null) {
            return null;
        }
        Project project = from.getProject();
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)from.getProject()).getCurrentFile();
        String gradlePath = GradleUtil.getGradlePath(to);
        GradleBuildModel buildModel = GradleBuildModel.get((Module)from);
        if (buildModel != null && gradlePath != null) {
            DependenciesModel dependencies2 = buildModel.dependencies();
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(from, scope2, openedFile);
            dependencies2.addModule(configurationName, gradlePath, null);
            WriteCommandAction.writeCommandAction((Project)project).withName("Add Gradle Module Dependency").run(() -> {
                buildModel.applyChanges();
                AndroidGradleJavaProjectModelModifier.registerUndoAction(project, externalProjectPath);
            });
            return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, externalProjectPath, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ADD_MODULE_DEPENDENCY);
        }
        if (buildModel == null ^ gradlePath == null) {
            return Promises.rejectedPromise();
        }
        return null;
    }

    @Nullable
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<? extends Module> modules, @NotNull ExternalLibraryDescriptor descriptor2, @NotNull DependencyScope scope2) {
        String externalProjectPath;
        if (modules == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(6);
        }
        if ((externalProjectPath = AndroidGradleJavaProjectModelModifier.getSingleExternalProjectPathOrNull(modules)) == null) {
            return null;
        }
        ArtifactDependencySpec dependencySpec = ArtifactDependencySpec.create((String)descriptor2.getLibraryArtifactId(), (String)descriptor2.getLibraryGroupId(), (String)AndroidGradleJavaProjectModelModifier.selectVersion(descriptor2));
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency(modules, dependencySpec, scope2);
    }

    @Nullable
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope2, boolean exported) {
        String externalProjectPath;
        if (from == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(7);
        }
        if (library == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(8);
        }
        if (scope2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(9);
        }
        if ((externalProjectPath = AndroidGradleJavaProjectModelModifier.getSingleExternalProjectPathOrNull(from)) == null) {
            return null;
        }
        ArtifactDependencySpec dependencySpec = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(from.getProject(), library);
        if (dependencySpec == null) {
            return Promises.rejectedPromise();
        }
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency((Collection<? extends Module>)ImmutableList.of((Object)from), dependencySpec, scope2);
    }

    @Nullable
    private static Promise<Void> addExternalLibraryDependency(@NotNull Collection<? extends Module> modules, @NotNull ArtifactDependencySpec dependencySpec, @NotNull DependencyScope scope2) {
        String externalProjectPath;
        if (modules == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(10);
        }
        if (dependencySpec == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(11);
        }
        if (scope2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(12);
        }
        if ((externalProjectPath = AndroidGradleJavaProjectModelModifier.getSingleExternalProjectPathOrNull(modules)) == null) {
            return null;
        }
        Module firstModule = (Module)Iterables.getFirst(modules, null);
        if (firstModule == null) {
            return null;
        }
        Project project = firstModule.getProject();
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)firstModule.getProject()).getCurrentFile();
        ArrayList<GradleBuildModel> buildModelsToUpdate = new ArrayList<GradleBuildModel>();
        for (Module module2 : modules) {
            GradleBuildModel buildModel = GradleBuildModel.get((Module)module2);
            if (buildModel == null) {
                return null;
            }
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(module2, scope2, openedFile);
            DependenciesModel dependencies2 = buildModel.dependencies();
            dependencies2.addArtifact(configurationName, dependencySpec);
            buildModelsToUpdate.add(buildModel);
        }
        WriteCommandAction.writeCommandAction((Project)project).withName("Add Gradle Library Dependency").run(() -> {
            for (GradleBuildModel buildModel : buildModelsToUpdate) {
                buildModel.applyChanges();
            }
            AndroidGradleJavaProjectModelModifier.registerUndoAction(project, externalProjectPath);
        });
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, externalProjectPath, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ADD_LIBRARY_DEPENDENCY);
    }

    @Nullable
    public Promise<Void> changeLanguageLevel(@NotNull Module module2, @NotNull LanguageLevel level) {
        String externalProjectPath;
        if (module2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(13);
        }
        if (level == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(14);
        }
        if ((externalProjectPath = AndroidGradleJavaProjectModelModifier.getSingleExternalProjectPathOrNull(module2)) == null) {
            return null;
        }
        Project project = module2.getProject();
        GradleBuildModel buildModel = GradleBuildModel.get((Module)module2);
        if (buildModel == null) {
            return null;
        }
        List pluginNames = PluginModel.extractNames((List)buildModel.plugins());
        ArrayList androidPluginNames = new ArrayList(pluginNames);
        androidPluginNames.retainAll(ANDROID_PLUGIN_IDENTIFIERS);
        ArrayList javaPluginNames = new ArrayList(pluginNames);
        javaPluginNames.retainAll(JAVA_PLUGIN_IDENTIFIERS);
        if (!androidPluginNames.isEmpty()) {
            AndroidModel android = buildModel.android();
            CompileOptionsModel compileOptions = android.compileOptions();
            compileOptions.sourceCompatibility().setLanguageLevel(level);
            compileOptions.targetCompatibility().setLanguageLevel(level);
        }
        if (!javaPluginNames.isEmpty()) {
            JavaModel javaModel = buildModel.java();
            javaModel.sourceCompatibility().setLanguageLevel(level);
            javaModel.targetCompatibility().setLanguageLevel(level);
        }
        WriteCommandAction.writeCommandAction((Project)project).withName("Change Gradle Language Level").run(() -> {
            buildModel.applyChanges();
            AndroidGradleJavaProjectModelModifier.registerUndoAction(project, externalProjectPath);
        });
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, externalProjectPath, GradleSyncStats.Trigger.TRIGGER_MODIFIER_LANGUAGE_LEVEL_CHANGED);
    }

    @NotNull
    private static String getConfigurationName(@NotNull Module module2, @NotNull DependencyScope scope2, @Nullable VirtualFile openedFile) {
        if (module2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(15);
        }
        if (scope2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(16);
        }
        String string = GradleUtil.mapConfigurationName(AndroidGradleJavaProjectModelModifier.getLegacyConfigurationName(module2, scope2, openedFile), GradleUtil.getAndroidGradleModelVersionInUse(module2), false);
        if (string == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String getLegacyConfigurationName(@NotNull Module module2, @NotNull DependencyScope scope2, @Nullable VirtualFile openedFile) {
        TestArtifactSearchScopes testScopes;
        if (module2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(18);
        }
        if (scope2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(19);
        }
        if (!scope2.isForProductionCompile() && (testScopes = TestArtifactSearchScopes.getInstance(module2)) != null && openedFile != null) {
            return testScopes.isAndroidTestSource(openedFile) ? "androidTestCompile" : "testCompile";
        }
        return "compile";
    }

    @Nullable
    @TestOnly
    static String selectVersion(@NotNull ExternalLibraryDescriptor descriptor2) {
        GoogleMavenArtifactId library;
        if (descriptor2 == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(20);
        }
        if (descriptor2.getPreferredVersion() != null) {
            return descriptor2.getPreferredVersion();
        }
        String libraryArtifactId = descriptor2.getLibraryArtifactId();
        String libraryGroupId = descriptor2.getLibraryGroupId();
        String groupAndId = libraryGroupId + ":" + libraryArtifactId;
        String version2 = EXTERNAL_LIBRARY_VERSIONS.get(groupAndId);
        if (version2 == null && (library = GoogleMavenArtifactId.Companion.find(libraryGroupId, libraryArtifactId)) != null) {
            GradleCoordinate coordinate;
            Predicate<GradleVersion> filter2 = descriptor2.getMinVersion() == null ? null : v -> v.toString().startsWith(descriptor2.getMinVersion());
            String gc = RepositoryUrlManager.get().getArtifactStringCoordinate(library, filter2, false);
            if (gc == null) {
                gc = RepositoryUrlManager.get().getLibraryRevision(libraryGroupId, libraryArtifactId, filter2, false, FileOpUtils.create());
            }
            if (gc != null && (coordinate = GradleCoordinate.parseCoordinateString((String)gc)) != null) {
                version2 = coordinate.getRevision();
            }
        }
        return version2;
    }

    @NotNull
    private static Promise<Void> requestProjectSync(@NotNull Project project, @NotNull String externalProjectPath, @NotNull GradleSyncStats.Trigger trigger) {
        if (project == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(21);
        }
        if (externalProjectPath == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(22);
        }
        if (trigger == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(23);
        }
        if (AndroidGradleJavaProjectModelModifier.isAndroidGradleProject(project)) {
            return AndroidGradleJavaProjectModelModifier.doAndroidGradleSync(project, trigger);
        }
        return AndroidGradleJavaProjectModelModifier.doIdeaGradleSync(project, externalProjectPath);
    }

    @NotNull
    private static AsyncPromise<Void> doAndroidGradleSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        if (project == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(24);
        }
        if (trigger == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(25);
        }
        final AsyncPromise promise = new AsyncPromise();
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(trigger);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request, new GradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                promise.setResult(null);
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(2);
                }
                promise.setError(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncSucceeded";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "syncFailed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(26);
        }
        return asyncPromise;
    }

    @NotNull
    private static AsyncPromise<Void> doIdeaGradleSync(@NotNull Project project, @NotNull String externalProjectPath) {
        if (project == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(27);
        }
        if (externalProjectPath == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(28);
        }
        final AsyncPromise promise = new AsyncPromise();
        final ImportSpecBuilder importSpecBuilder = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID);
        importSpecBuilder.callback(new ExternalProjectRefreshCallback(){
            private final ImportSpecBuilder.DefaultProjectRefreshCallback defaultCallback;
            {
                this.defaultCallback = new ImportSpecBuilder.DefaultProjectRefreshCallback(importSpecBuilder.build());
            }

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                this.defaultCallback.onSuccess(externalProject);
                ApplicationManager.getApplication().invokeLater(() -> promise.setResult(null));
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.defaultCallback.onFailure(errorMessage, errorDetails);
                promise.setError(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier$2", "onFailure"));
            }
        });
        ExternalSystemUtil.refreshProject((String)externalProjectPath, (ImportSpecBuilder)importSpecBuilder);
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(29);
        }
        return asyncPromise;
    }

    private static void registerUndoAction(final @NotNull Project project, final @NotNull String externalProjectPath) {
        if (project == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(30);
        }
        if (externalProjectPath == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(31);
        }
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project, externalProjectPath, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_UNDONE);
            }

            public void redo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project, externalProjectPath, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_REDONE);
            }
        });
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Project project, @NotNull Library library) {
        if (project == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(32);
        }
        if (library == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(33);
        }
        if (library.getName() == null) {
            return null;
        }
        ArtifactDependencySpec result2 = null;
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
            if (androidModel == null || LibraryUtil.findLibrary((Module)module2, (String)library.getName()) == null) continue;
            result2 = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(library, androidModel.getSelectedVariant());
            break;
        }
        if (result2 == null) {
            result2 = AndroidGradleJavaProjectModelModifier.findNewExternalDependencyByExaminingPath(library);
        }
        return result2;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Library library, @NotNull IdeVariant selectedVariant) {
        if (library == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(34);
        }
        if (selectedVariant == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(35);
        }
        @Nullable ArtifactDependencySpec matchedLibrary = null;
        IdeJavaArtifact testArtifact = selectedVariant.getUnitTestArtifact();
        if (testArtifact != null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, (IdeBaseArtifact)testArtifact);
        }
        if (matchedLibrary == null && (testArtifact = selectedVariant.getAndroidTestArtifact()) != null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, (IdeBaseArtifact)testArtifact);
        }
        if (matchedLibrary == null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, (IdeBaseArtifact)selectedVariant.getMainArtifact());
        }
        if (matchedLibrary == null) {
            return null;
        }
        return matchedLibrary;
    }

    @Nullable
    private static ArtifactDependencySpec findMatchedLibrary(@NotNull Library library, @NotNull IdeBaseArtifact artifact) {
        if (library == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(36);
        }
        if (artifact == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(37);
        }
        IdeDependencies dependencies2 = artifact.getLevel2Dependencies();
        for (IdeLibrary gradleLibrary : dependencies2.getJavaLibraries()) {
            String libraryName = FileUtil.getNameWithoutExtension((File)gradleLibrary.getArtifact());
            if (!libraryName.equals(library.getName())) continue;
            return ArtifactDependencySpec.create((String)gradleLibrary.getArtifactAddress());
        }
        return null;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependencyByExaminingPath(@NotNull Library library) {
        VirtualFile[] files2;
        if (library == null) {
            AndroidGradleJavaProjectModelModifier.$$$reportNull$$$0(38);
        }
        if ((files2 = library.getFiles(OrderRootType.CLASSES)).length == 0) {
            return null;
        }
        File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)files2[0]);
        String libraryName = library.getName();
        if (libraryName == null) {
            return null;
        }
        List pathSegments = FileUtil.splitPath((String)file2.getPath());
        for (int i2 = 1; i2 < pathSegments.size() - 2; ++i2) {
            if (!libraryName.startsWith((String)pathSegments.get(i2))) continue;
            String groupId = (String)pathSegments.get(i2 - 1);
            String artifactId = (String)pathSegments.get(i2);
            String version2 = (String)pathSegments.get(i2 + 1);
            if (!libraryName.endsWith(version2)) continue;
            return ArtifactDependencySpec.create((String)artifactId, (String)groupId, (String)version2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencySpec";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 17: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier";
                break;
            }
            case 22: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariant";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/AndroidGradleJavaProjectModelModifier";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "doAndroidGradleSync";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doIdeaGradleSync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidGradleProject";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addModuleDependency";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addExternalLibraryDependency";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryDependency";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "changeLanguageLevel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationName";
                break;
            }
            case 17: 
            case 26: 
            case 29: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyConfigurationName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "selectVersion";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "requestProjectSync";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doAndroidGradleSync";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doIdeaGradleSync";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "registerUndoAction";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findNewExternalDependency";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findMatchedLibrary";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findNewExternalDependencyByExaminingPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

