/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontProvider;
import com.android.tools.idea.downloads.DownloadService;
import com.android.tools.idea.fonts.DownloadableFontCacheServiceImpl;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

class FontDirectoryDownloadService
extends DownloadService {
    private static final String SERVICE_POSTFIX = " Downloadable Fonts";
    private static final String TEMPORARY_FONT_DIRECTORY_FILENAME = "temp_font_directory.xml";
    private final FontProvider myProvider;
    private final DownloadableFontCacheServiceImpl myFontService;

    FontDirectoryDownloadService(@NotNull DownloadableFontCacheServiceImpl fontService, @NotNull FontProvider provider2, @NotNull File fontCachePath) {
        if (fontService == null) {
            FontDirectoryDownloadService.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            FontDirectoryDownloadService.$$$reportNull$$$0(1);
        }
        if (fontCachePath == null) {
            FontDirectoryDownloadService.$$$reportNull$$$0(2);
        }
        super(provider2.getName() + SERVICE_POSTFIX, provider2.getUrl(), FontDirectoryDownloadService.getFallbackResourceUrl(provider2), FontDirectoryDownloadService.getCachePath(provider2, fontCachePath), TEMPORARY_FONT_DIRECTORY_FILENAME, "font_directory.xml");
        this.myFontService = fontService;
        this.myProvider = provider2;
    }

    @Override
    public void loadFromFile(@NotNull URL url) {
        if (url == null) {
            FontDirectoryDownloadService.$$$reportNull$$$0(3);
        }
        this.myFontService.loadDirectory(this.myProvider, url);
    }

    @NotNull
    private static File getCachePath(@NotNull FontProvider provider2, @NotNull File fontCachePath) {
        if (provider2 == null) {
            FontDirectoryDownloadService.$$$reportNull$$$0(4);
        }
        if (fontCachePath == null) {
            FontDirectoryDownloadService.$$$reportNull$$$0(5);
        }
        File providerPath = new File(fontCachePath, provider2.getAuthority());
        File directoryPath = new File(providerPath, "directory");
        FileUtil.createDirectory((File)directoryPath);
        File file2 = directoryPath;
        if (file2 == null) {
            FontDirectoryDownloadService.$$$reportNull$$$0(6);
        }
        return file2;
    }

    static URL getFallbackResourceUrl(@NotNull FontProvider provider2) {
        if (provider2 == null) {
            FontDirectoryDownloadService.$$$reportNull$$$0(7);
        }
        String filename = provider2.equals((Object)FontProvider.GOOGLE_PROVIDER) ? "google_font_directory.xml" : "empty_font_directory.xml";
        return FontDirectoryDownloadService.class.getClassLoader().getResource("fonts/" + filename);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontService";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontCachePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fonts/FontDirectoryDownloadService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fonts/FontDirectoryDownloadService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCachePath";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackResourceUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

