/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontLoader;
import com.android.ide.common.fonts.FontProvider;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.fonts.FontDirectoryDownloadService;
import com.android.tools.idea.fonts.FontDownloadService;
import com.android.tools.idea.fonts.SystemFonts;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class DownloadableFontCacheServiceImpl
extends FontLoader
implements DownloadableFontCacheService {
    private static final String FONTS = "fonts";
    private static final String FONT = "font";
    private static final String V1 = "v1";
    private final SystemFonts mySystemFonts;
    private final Map<String, FontDirectoryDownloadService> myDownloadServiceMap = new HashMap<String, FontDirectoryDownloadService>();

    @NotNull
    static DownloadableFontCacheServiceImpl getInstance() {
        DownloadableFontCacheServiceImpl downloadableFontCacheServiceImpl = (DownloadableFontCacheServiceImpl)DownloadableFontCacheService.getInstance();
        if (downloadableFontCacheServiceImpl == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(0);
        }
        return downloadableFontCacheServiceImpl;
    }

    @Override
    @NotNull
    public List<FontFamily> getSystemFontFamilies() {
        return new ArrayList<FontFamily>(this.mySystemFonts.getFontFamilies());
    }

    @Override
    @Nullable
    public FontFamily getSystemFont(@NotNull String name) {
        if (name == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(1);
        }
        return this.mySystemFonts.getFont(name);
    }

    @Override
    @NotNull
    public FontFamily getDefaultSystemFont() {
        FontFamily fontFamily = this.mySystemFonts.getFontFamilies().iterator().next();
        if (fontFamily == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(2);
        }
        return fontFamily;
    }

    @Override
    @Nullable
    public File getCachedMenuFile(@NotNull FontFamily family) {
        String menu;
        if (family == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(3);
        }
        if ((menu = family.getMenu()).isEmpty()) {
            return null;
        }
        if (menu.startsWith("file://")) {
            return new File(menu.substring("file://".length()));
        }
        return this.getCachedFont(family.getProvider().getAuthority(), menu);
    }

    @Nullable
    public File getRelativeCachedMenuFile(@NotNull FontFamily family) {
        String menu;
        if (family == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(4);
        }
        if (!(menu = family.getMenu()).startsWith("https://")) {
            return null;
        }
        return DownloadableFontCacheServiceImpl.getRelativeCachedFont(family.getProvider().getAuthority(), menu);
    }

    @Override
    @Nullable
    public File getCachedFontFile(@NotNull FontDetail font) {
        String fontUrl;
        if (font == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(5);
        }
        if ((fontUrl = font.getFontUrl()).isEmpty()) {
            return null;
        }
        if (fontUrl.startsWith("file://")) {
            return new File(fontUrl.substring("file://".length()));
        }
        return this.getCachedFont(font.getFamily().getProvider().getAuthority(), fontUrl);
    }

    @Nullable
    public File getRelativeFontFile(@NotNull FontDetail font) {
        String fontUrl;
        if (font == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(6);
        }
        if (!(fontUrl = font.getFontUrl()).startsWith("https://")) {
            return null;
        }
        return DownloadableFontCacheServiceImpl.getRelativeCachedFont(font.getFamily().getProvider().getAuthority(), fontUrl);
    }

    @Override
    @Nullable
    @Language(value="XML")
    public String toXml(@NotNull FontFamily family) {
        if (family == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(7);
        }
        StringBuilder output = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<font-family xmlns:android=\"http://schemas.android.com/apk/res/android\">");
        boolean hasAnyDownloadedFonts = false;
        for (FontDetail detail : family.getFonts()) {
            int weight;
            File cachedFile = this.getCachedFontFile(detail);
            if (cachedFile == null || !cachedFile.exists()) continue;
            hasAnyDownloadedFonts = true;
            output.append(String.format("<font android:font=\"%s\"", cachedFile.getAbsolutePath()));
            if (detail.getHasExplicitStyle()) {
                output.append(String.format(" android:fontStyle=\"%s\"", detail.getFontStyle()));
            }
            if ((weight = detail.getWeight()) != -1) {
                output.append(String.format(Locale.US, " android:fontWeight=\"%d\"", weight));
            }
            output.append(" />");
        }
        if (!hasAnyDownloadedFonts) {
            return null;
        }
        output.append("</font-family>");
        return output.toString();
    }

    @Override
    public void download(@NotNull FontFamily family) {
        if (family == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(8);
        }
        FontDownloadService.download(Collections.singletonList(family), false, null, null);
    }

    @Override
    @Nullable
    public Font loadMenuFont(@NotNull FontFamily fontFamily) {
        File file2;
        if (fontFamily == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(9);
        }
        if ((file2 = this.getCachedMenuFile(fontFamily)) != null && file2.exists()) {
            try {
                return Font.createFont(0, file2);
            }
            catch (FontFormatException | IOException ex) {
                Logger.getInstance(DownloadableFontCacheServiceImpl.class).warn("Could not load font: " + fontFamily.getName(), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Font loadDetailFont(@NotNull FontDetail fontDetail) {
        File file2;
        if (fontDetail == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(10);
        }
        if ((file2 = this.getCachedFontFile(fontDetail)) != null && file2.exists()) {
            try {
                return Font.createFont(0, file2);
            }
            catch (FontFormatException | IOException ex) {
                Logger.getInstance(DownloadableFontCacheServiceImpl.class).warn("Could not load font: " + fontDetail.getFamily().getName(), (Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(@Nullable Runnable success2, @Nullable Runnable failure) {
        Collection<FontDirectoryDownloadService> services;
        Iterator<FontDirectoryDownloadService> iterator = this.getLock();
        synchronized (iterator) {
            if (this.updateSdkHome()) {
                this.updateDownloadServices();
            }
            services = this.myDownloadServiceMap.values();
        }
        for (FontDirectoryDownloadService service : services) {
            service.refresh(success2, failure);
        }
    }

    @VisibleForTesting
    DownloadableFontCacheServiceImpl() {
        this.init();
        this.mySystemFonts = new SystemFonts(this);
        instance = this;
    }

    @TestOnly
    SystemFonts getSystemFonts() {
        return this.mySystemFonts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        File initialSdkHome = this.locateSdkHome();
        if (initialSdkHome == null) {
            initialSdkHome = DownloadableFontCacheServiceImpl.createTempSdk();
        }
        Object object = this.getLock();
        synchronized (object) {
            this.clear(initialSdkHome);
            this.fontsLoaded();
            this.updateDownloadServices();
        }
    }

    @Nullable
    protected File locateSdkHome() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        return sdkHandler.getLocation();
    }

    protected void loadFonts() {
        super.loadFonts();
        if (this.getFontFamilies().isEmpty()) {
            this.loadDirectory(FontProvider.GOOGLE_PROVIDER, FontDirectoryDownloadService.getFallbackResourceUrl(FontProvider.GOOGLE_PROVIDER));
        }
    }

    @Nullable
    private static File createTempSdk() {
        try {
            return FileUtil.createTempDirectory((String)"temp", (String)"sdk");
        }
        catch (IOException ex) {
            Logger.getInstance(DownloadableFontCacheServiceImpl.class).error((Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSdkHome() {
        Object object = this.getLock();
        synchronized (object) {
            File newSdkHome = this.locateSdkHome();
            File oldSdkHome = this.getSdkHome();
            if (Objects.equals(newSdkHome, oldSdkHome)) {
                return false;
            }
            if (newSdkHome == null) {
                if (oldSdkHome != null && oldSdkHome.getName().startsWith("temp")) {
                    return false;
                }
                newSdkHome = DownloadableFontCacheServiceImpl.createTempSdk();
            }
            this.clear(newSdkHome);
            return true;
        }
    }

    @Nullable
    private File getCachedFont(@NotNull String authority, @NotNull String url) {
        File cachePath;
        if (authority == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(11);
        }
        if (url == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(12);
        }
        if ((cachePath = this.getFontPath()) == null) {
            return null;
        }
        return new File(cachePath, DownloadableFontCacheServiceImpl.getRelativeCachedFont(authority, url).getPath());
    }

    private static File getRelativeCachedFont(@NotNull String authority, @NotNull String menu) {
        if (authority == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(13);
        }
        if (menu == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(14);
        }
        File providerPath = new File(authority);
        File fontsPath = new File(providerPath, FONTS);
        File fontPath = new File(fontsPath, DownloadableFontCacheServiceImpl.getChildName(menu, 2, FONT));
        File versionPath = new File(fontPath, DownloadableFontCacheServiceImpl.getChildName(menu, 1, V1));
        return new File(versionPath, DownloadableFontCacheServiceImpl.getChildName(menu, 0, menu));
    }

    @NotNull
    private static String getChildName(@NotNull String menu, int fromLast, @NotNull String defaultName) {
        if (menu == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(15);
        }
        if (defaultName == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(16);
        }
        int lastIndex = menu.length();
        int prevIndex = menu.lastIndexOf(47, lastIndex - 1);
        while (fromLast > 0) {
            lastIndex = prevIndex;
            prevIndex = menu.lastIndexOf(47, lastIndex - 1);
            --fromLast;
        }
        if (prevIndex < 0) {
            String string = defaultName;
            if (string == null) {
                DownloadableFontCacheServiceImpl.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = menu.substring(prevIndex + 1, lastIndex);
        if (string == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    static String convertNameToFilename(@NotNull String name) {
        if (name == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(19);
        }
        StringBuilder builder2 = new StringBuilder();
        boolean previousUnderscore = true;
        for (char character : name.toCharArray()) {
            if (Character.isUpperCase(character)) {
                builder2.append(Character.toLowerCase(character));
                previousUnderscore = false;
                continue;
            }
            if (Character.isLowerCase(character) || Character.isDigit(character)) {
                builder2.append(character);
                previousUnderscore = false;
                continue;
            }
            if (previousUnderscore) continue;
            builder2.append('_');
            previousUnderscore = true;
        }
        String string = builder2.toString();
        if (string == null) {
            DownloadableFontCacheServiceImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDownloadServices() {
        Object object = this.getLock();
        synchronized (object) {
            this.myDownloadServiceMap.clear();
            File fontPath = this.getFontPath();
            if (fontPath != null) {
                for (FontProvider provider2 : this.getProviders().values()) {
                    this.myDownloadServiceMap.put(provider2.getAuthority(), new FontDirectoryDownloadService(this, provider2, fontPath));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fonts/DownloadableFontCacheServiceImpl";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = FONT;
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFamily";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontDetail";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authority";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menu";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fonts/DownloadableFontCacheServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemFont";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNameToFilename";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSystemFont";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCachedMenuFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeCachedMenuFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFontFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFontFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toXml";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadMenuFont";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadDetailFont";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFont";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeCachedFont";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertNameToFilename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

