/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.ui;

import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.explorer.DeviceExplorerModel;
import com.android.tools.idea.explorer.DeviceExplorerModelListener;
import com.android.tools.idea.explorer.DeviceExplorerView;
import com.android.tools.idea.explorer.DeviceExplorerViewListener;
import com.android.tools.idea.explorer.DeviceExplorerViewProgressListener;
import com.android.tools.idea.explorer.DeviceFileEntryNode;
import com.android.tools.idea.explorer.DeviceFileSystemRendererFactory;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceFileSystemRenderer;
import com.android.tools.idea.explorer.fs.DeviceFileSystemService;
import com.android.tools.idea.explorer.ui.ComponentPopupMenu;
import com.android.tools.idea.explorer.ui.DeviceExplorerPanel;
import com.android.tools.idea.explorer.ui.PopupMenuItem;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DeviceExplorerViewImpl
implements DeviceExplorerView {
    @NotNull
    private final List<DeviceExplorerViewListener> myListeners;
    @NotNull
    private final List<DeviceExplorerViewProgressListener> myProgressListeners;
    @NotNull
    private final DeviceFileSystemRenderer myDeviceRenderer;
    @NotNull
    private final DeviceExplorerPanel myPanel;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @Nullable
    private ComponentPopupMenu myTreePopupMenu;
    private int myTreeLoadingCount;

    public DeviceExplorerViewImpl(@NotNull Project project, @NotNull DeviceFileSystemRendererFactory rendererFactory, @NotNull DeviceExplorerModel model2) {
        if (project == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(0);
        }
        if (rendererFactory == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(1);
        }
        if (model2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(2);
        }
        this.myListeners = new ArrayList<DeviceExplorerViewListener>();
        this.myProgressListeners = new ArrayList<DeviceExplorerViewProgressListener>();
        model2.addListener(new ModelListener());
        this.myDeviceRenderer = rendererFactory.create(new DeviceNamePropertiesFetcher((Disposable)project, new FutureCallback<DeviceNameProperties>(){

            public void onSuccess(@Nullable DeviceNameProperties result2) {
                DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().updateUI();
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                Logger.getInstance(DeviceExplorerViewImpl.class).warn("Error retrieving device name properties", t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$1", "onFailure"));
            }
        }));
        this.myPanel = new DeviceExplorerPanel();
        this.myPanel.setCancelActionListener(e -> this.myProgressListeners.forEach(DeviceExplorerViewProgressListener::cancellationRequested));
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
    }

    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(3);
        }
        return jBLoadingPanel;
    }

    @TestOnly
    @Nullable
    public JComboBox<DeviceFileSystem> getDeviceCombo() {
        return this.myPanel.getDeviceCombo();
    }

    @TestOnly
    @Nullable
    public JTree getFileTree() {
        return this.myPanel.getTree();
    }

    @TestOnly
    @Nullable
    public ActionGroup getFileTreeActionGroup() {
        return this.myTreePopupMenu == null ? null : this.myTreePopupMenu.getActionGroup();
    }

    @TestOnly
    @NotNull
    public JBLoadingPanel getLoadingPanel() {
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(4);
        }
        return jBLoadingPanel;
    }

    @TestOnly
    @Nullable
    public DeviceExplorerPanel getDeviceExplorerPanel() {
        return this.myPanel;
    }

    @Override
    public void addListener(@NotNull DeviceExplorerViewListener listener2) {
        if (listener2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(5);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceExplorerViewListener listener2) {
        if (listener2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(6);
        }
        this.myListeners.remove(listener2);
    }

    @Override
    public void addProgressListener(@NotNull DeviceExplorerViewProgressListener listener2) {
        if (listener2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(7);
        }
        this.myProgressListeners.add(listener2);
    }

    @Override
    public void removeProgressListener(@NotNull DeviceExplorerViewProgressListener listener2) {
        if (listener2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(8);
        }
        this.myProgressListeners.remove(listener2);
    }

    @Override
    public void setup() {
        this.setupPanel();
    }

    @Override
    public void reportErrorRelatedToService(@NotNull DeviceFileSystemService service, @NotNull String message2, @NotNull Throwable t) {
        if (service == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(9);
        }
        if (message2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(10);
        }
        if (t == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(11);
        }
        if (t.getMessage() != null) {
            message2 = (String)message2 + ": " + t.getMessage();
        }
        this.myPanel.showErrorMessageLayer((String)message2, false);
    }

    @Override
    public void reportErrorRelatedToDevice(@NotNull DeviceFileSystem fileSystem, @NotNull String message2, @NotNull Throwable t) {
        if (fileSystem == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(12);
        }
        if (message2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(13);
        }
        if (t == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(14);
        }
        if (t.getMessage() != null) {
            message2 = (String)message2 + ": " + t.getMessage();
        }
        this.myPanel.showErrorMessageLayer((String)message2, true);
    }

    @Override
    public void reportErrorRelatedToNode(@NotNull DeviceFileEntryNode node2, @NotNull String message2, @NotNull Throwable t) {
        if (node2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(15);
        }
        if (message2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(16);
        }
        if (t == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(17);
        }
        DeviceExplorerViewImpl.reportError(message2, t);
    }

    @Override
    public void reportMessageRelatedToDevice(@NotNull DeviceFileSystem fileSystem, @NotNull String message2) {
        if (fileSystem == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(18);
        }
        if (message2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(19);
        }
        this.myPanel.showMessageLayer(message2, true);
    }

    @Override
    public void reportMessageRelatedToNode(@NotNull DeviceFileEntryNode node2, @NotNull String message2) {
        if (node2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(20);
        }
        if (message2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(21);
        }
        DeviceExplorerViewImpl.reportMessage(message2);
    }

    private static void reportMessage(@NotNull String message2) {
        if (message2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(22);
        }
        Notification notification = new Notification("Device File Explorer", "Device File Explorer", message2, NotificationType.INFORMATION);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)notification));
    }

    private static void reportError(@NotNull String message2, @NotNull Throwable t) {
        if (message2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(23);
        }
        if (t == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(24);
        }
        if (t instanceof CancellationException) {
            return;
        }
        if (t.getMessage() != null) {
            message2 = (String)message2 + ": " + t.getMessage();
        }
        Notification notification = new Notification("Device File Explorer", "Device File Explorer", (String)message2, NotificationType.WARNING);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)notification));
    }

    private void setupPanel() {
        this.myPanel.getComponent().setBorder(IdeBorderFactory.createBorder((int)8));
        this.myLoadingPanel.add((Component)this.myPanel.getComponent(), (Object)"Center");
        this.myPanel.getDeviceCombo().setRenderer(this.myDeviceRenderer.getDeviceNameListRenderer());
        this.myPanel.getDeviceCombo().addActionListener(actionEvent -> {
            Object sel = this.myPanel.getDeviceCombo().getSelectedItem();
            if (sel instanceof DeviceFileSystem) {
                DeviceFileSystem device = (DeviceFileSystem)sel;
                this.myListeners.forEach(x -> x.deviceSelected(device));
            } else {
                this.myListeners.forEach(DeviceExplorerViewListener::noDeviceSelected);
            }
        });
        final Tree tree = this.myPanel.getTree();
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DeviceFileEntryNode node2 = DeviceFileEntryNode.fromNode(event.getPath().getLastPathComponent());
                if (node2 != null) {
                    DeviceExplorerViewImpl.this.expandTreeNode(node2);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int selRow = tree.getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
                    if (selRow != -1 && selPath != null) {
                        DeviceExplorerViewImpl.this.openSelectedNodes(Collections.singletonList(selPath));
                    }
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath[] paths;
                if (10 == e.getKeyCode() && (paths = tree.getSelectionPaths()) != null) {
                    DeviceExplorerViewImpl.this.openSelectedNodes(Arrays.asList(paths));
                }
            }
        });
        this.createTreePopupMenu();
        this.myLoadingPanel.setLoadingText("Initializing ADB");
        this.myLoadingPanel.startLoading();
    }

    private void createTreePopupMenu() {
        this.myTreePopupMenu = new ComponentPopupMenu((JComponent)this.myPanel.getTree());
        ComponentPopupMenu fileMenu = this.myTreePopupMenu.addPopup("New");
        fileMenu.addItem(new NewFileMenuItem());
        fileMenu.addItem(new NewDirectoryMenuItem());
        this.myTreePopupMenu.addSeparator();
        this.myTreePopupMenu.addItem(new OpenMenuItem());
        this.myTreePopupMenu.addItem(new SaveAsMenuItem());
        this.myTreePopupMenu.addItem(new UploadFilesMenuItem());
        this.myTreePopupMenu.addItem(new DeleteNodesMenuItem());
        this.myTreePopupMenu.addSeparator();
        this.myTreePopupMenu.addItem(new SynchronizeNodesMenuItem());
        this.myTreePopupMenu.addItem(new CopyPathMenuItem());
        this.myTreePopupMenu.install();
    }

    private void openSelectedNodes(@NotNull List<TreePath> paths) {
        if (paths == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(25);
        }
        List<DeviceFileEntryNode> nodes = paths.stream().map(x -> DeviceFileEntryNode.fromNode(x.getLastPathComponent())).filter(Objects::nonNull).collect(Collectors.toList());
        this.openNodes(nodes);
    }

    private void copyNodePaths(@NotNull List<DeviceFileEntryNode> treeNodes) {
        if (treeNodes == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(26);
        }
        this.myListeners.forEach(x -> x.copyNodePathsInvoked(treeNodes));
    }

    private void openNodes(@NotNull List<DeviceFileEntryNode> treeNodes) {
        if (treeNodes == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(27);
        }
        this.myListeners.forEach(x -> x.openNodesInEditorInvoked(treeNodes));
    }

    private void saveNodesAs(@NotNull List<DeviceFileEntryNode> treeNodes) {
        if (treeNodes == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(28);
        }
        this.myListeners.forEach(x -> x.saveNodesAsInvoked(treeNodes));
    }

    private void newDirectory(@NotNull DeviceFileEntryNode treeNode) {
        if (treeNode == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(29);
        }
        this.myListeners.forEach(x -> x.newDirectoryInvoked(treeNode));
    }

    private void newFile(@NotNull DeviceFileEntryNode treeNode) {
        if (treeNode == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(30);
        }
        this.myListeners.forEach(x -> x.newFileInvoked(treeNode));
    }

    private void deleteNodes(@NotNull List<DeviceFileEntryNode> treeNodes) {
        if (treeNodes == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(31);
        }
        this.myListeners.forEach(x -> x.deleteNodesInvoked(treeNodes));
    }

    private void synchronizeNodes(@NotNull List<DeviceFileEntryNode> treeNodes) {
        if (treeNodes == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(32);
        }
        this.myListeners.forEach(x -> x.synchronizeNodesInvoked(treeNodes));
    }

    private void uploadFiles(@NotNull DeviceFileEntryNode treeNode) {
        if (treeNode == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(33);
        }
        this.myListeners.forEach(x -> x.uploadFilesInvoked(treeNode));
    }

    @Override
    public void startRefresh(@NotNull String text2) {
        if (text2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(34);
        }
        this.myPanel.showMessageLayer("", false);
        this.myLoadingPanel.setLoadingText(text2);
        this.myLoadingPanel.startLoading();
    }

    @Override
    public void stopRefresh() {
        this.myLoadingPanel.stopLoading();
    }

    @Override
    public void showNoDeviceScreen() {
        this.myPanel.showMessageLayer("Connect a device via USB cable or run an Android Virtual Device", AndroidIcons.Explorer.DevicesLineup, false);
    }

    public void setRootFolder(@Nullable DefaultTreeModel model2, @Nullable DefaultTreeSelectionModel treeSelectionModel) {
        Tree tree = this.myPanel.getTree();
        tree.setModel((TreeModel)model2);
        tree.setSelectionModel((TreeSelectionModel)treeSelectionModel);
        if (model2 != null) {
            this.myPanel.showTree();
            DeviceFileEntryNode rootNode = DeviceFileEntryNode.fromNode(model2.getRoot());
            if (rootNode != null) {
                tree.setRootVisible(false);
                this.expandTreeNode(rootNode);
            } else {
                tree.setRootVisible(true);
            }
        }
    }

    @Override
    public void startTreeBusyIndicator() {
        this.incrementTreeLoading();
    }

    @Override
    public void stopTreeBusyIndicator() {
        this.decrementTreeLoading();
    }

    @Override
    public void expandNode(@NotNull DeviceFileEntryNode treeNode) {
        if (treeNode == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(35);
        }
        this.myPanel.getTree().expandPath(new TreePath(treeNode.getPath()));
    }

    @Override
    public void startProgress() {
        this.myPanel.getProgressPanel().start();
    }

    @Override
    public void setProgressIndeterminate(boolean indeterminate) {
        this.myPanel.getProgressPanel().setIndeterminate(indeterminate);
    }

    @Override
    public void setProgressValue(double fraction) {
        this.myPanel.getProgressPanel().setProgress(fraction);
    }

    @Override
    public void setProgressOkColor() {
        this.myPanel.getProgressPanel().setOkStatusColor();
    }

    @Override
    public void setProgressWarningColor() {
        this.myPanel.getProgressPanel().setWarningStatusColor();
    }

    @Override
    public void setProgressErrorColor() {
        this.myPanel.getProgressPanel().setErrorStatusColor();
    }

    @Override
    public void setProgressText(@NotNull String text2) {
        if (text2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(36);
        }
        this.myPanel.getProgressPanel().setText(text2);
    }

    @Override
    public void stopProgress() {
        this.myPanel.getProgressPanel().stop();
    }

    private void expandTreeNode(@NotNull DeviceFileEntryNode node2) {
        if (node2 == null) {
            DeviceExplorerViewImpl.$$$reportNull$$$0(37);
        }
        this.myListeners.forEach(x -> x.treeNodeExpanding(node2));
    }

    private void incrementTreeLoading() {
        if (this.myTreeLoadingCount == 0) {
            this.myPanel.getTree().setPaintBusy(true);
        }
        ++this.myTreeLoadingCount;
    }

    private void decrementTreeLoading() {
        --this.myTreeLoadingCount;
        if (this.myTreeLoadingCount == 0) {
            this.myPanel.getTree().setPaintBusy(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 15: 
            case 20: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeNodes";
                break;
            }
            case 29: 
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeNode";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addProgressListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeProgressListener";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportErrorRelatedToService";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportErrorRelatedToDevice";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reportErrorRelatedToNode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reportMessageRelatedToDevice";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reportMessageRelatedToNode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reportMessage";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "openSelectedNodes";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyNodePaths";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "openNodes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "saveNodesAs";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "newDirectory";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "newFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "deleteNodes";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeNodes";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "uploadFiles";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "startRefresh";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "expandNode";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setProgressText";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "expandTreeNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UploadFilesMenuItem
    extends SingleSelectionTreeMenuItem {
        private UploadFilesMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Upload...";
        }

        @Override
        @Nullable
        public Shortcut[] getShortcuts() {
            return new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(79, 192), null), new KeyboardShortcut(KeyStroke.getKeyStroke(85, 192), null)};
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                UploadFilesMenuItem.$$$reportNull$$$0(0);
            }
            return node2.getEntry().isDirectory() || node2.isSymbolicLinkToDirectory();
        }

        @Override
        public void run(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                UploadFilesMenuItem.$$$reportNull$$$0(1);
            }
            DeviceExplorerViewImpl.this.uploadFiles(node2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$UploadFilesMenuItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SynchronizeNodesMenuItem
    extends TreeMenuItem {
        private SynchronizeNodesMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Synchronize";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.Refresh;
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                SynchronizeNodesMenuItem.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                SynchronizeNodesMenuItem.$$$reportNull$$$0(1);
            }
            DeviceExplorerViewImpl.this.synchronizeNodes(nodes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$SynchronizeNodesMenuItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DeleteNodesMenuItem
    extends TreeMenuItem {
        private DeleteNodesMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Delete...";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.Cancel;
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                DeleteNodesMenuItem.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        @Nullable
        public String getShortcutId() {
            return "$Delete";
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                DeleteNodesMenuItem.$$$reportNull$$$0(1);
            }
            DeviceExplorerViewImpl.this.deleteNodes(nodes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$DeleteNodesMenuItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class NewDirectoryMenuItem
    extends SingleSelectionTreeMenuItem {
        private NewDirectoryMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Directory";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Nodes.Folder;
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                NewDirectoryMenuItem.$$$reportNull$$$0(0);
            }
            return node2.getEntry().isDirectory() || node2.isSymbolicLinkToDirectory();
        }

        @Override
        public void run(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                NewDirectoryMenuItem.$$$reportNull$$$0(1);
            }
            DeviceExplorerViewImpl.this.newDirectory(node2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$NewDirectoryMenuItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class NewFileMenuItem
    extends SingleSelectionTreeMenuItem {
        private NewFileMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "File";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.FileTypes.Text;
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                NewFileMenuItem.$$$reportNull$$$0(0);
            }
            return node2.getEntry().isDirectory() || node2.isSymbolicLinkToDirectory();
        }

        @Override
        public void run(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                NewFileMenuItem.$$$reportNull$$$0(1);
            }
            DeviceExplorerViewImpl.this.newFile(node2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$NewFileMenuItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SaveAsMenuItem
    extends TreeMenuItem {
        private SaveAsMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Save As...";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.MenuSaveall;
        }

        @Override
        @Nullable
        public Shortcut[] getShortcuts() {
            return new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(83, 192), null), new KeyboardShortcut(KeyStroke.getKeyStroke(68, 192), null)};
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                SaveAsMenuItem.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                SaveAsMenuItem.$$$reportNull$$$0(1);
            }
            DeviceExplorerViewImpl.this.saveNodesAs(nodes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$SaveAsMenuItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class OpenMenuItem
    extends TreeMenuItem {
        private OpenMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Open";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.MenuOpen;
        }

        @Override
        @Nullable
        public String getShortcutId() {
            return "OpenFile";
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                OpenMenuItem.$$$reportNull$$$0(0);
            }
            return node2.getEntry().isFile();
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                OpenMenuItem.$$$reportNull$$$0(1);
            }
            DeviceExplorerViewImpl.this.openNodes(nodes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$OpenMenuItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CopyPathMenuItem
    extends TreeMenuItem {
        private CopyPathMenuItem() {
        }

        @Override
        @NotNull
        public String getText() {
            return "Copy Path";
        }

        @Override
        public String getShortcutId() {
            return "CopyPaths";
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Actions.Copy;
        }

        @Override
        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                CopyPathMenuItem.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                CopyPathMenuItem.$$$reportNull$$$0(1);
            }
            DeviceExplorerViewImpl.this.copyNodePaths(nodes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$CopyPathMenuItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class SingleSelectionTreeMenuItem
    extends TreeMenuItem {
        private SingleSelectionTreeMenuItem() {
        }

        @Override
        public boolean isEnabled(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                SingleSelectionTreeMenuItem.$$$reportNull$$$0(0);
            }
            return super.isEnabled(nodes) && nodes.size() == 1;
        }

        @Override
        public boolean isVisible(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                SingleSelectionTreeMenuItem.$$$reportNull$$$0(1);
            }
            return super.isVisible(nodes) && nodes.size() == 1;
        }

        @Override
        public void run(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                SingleSelectionTreeMenuItem.$$$reportNull$$$0(2);
            }
            if (nodes.size() == 1) {
                this.run(nodes.get(0));
            }
        }

        public abstract void run(@NotNull DeviceFileEntryNode var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "nodes";
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$SingleSelectionTreeMenuItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class TreeMenuItem
    implements PopupMenuItem {
        private TreeMenuItem() {
        }

        @Override
        @NotNull
        public abstract String getText();

        @Override
        @Nullable
        public Icon getIcon() {
            return null;
        }

        @Override
        public final boolean isEnabled() {
            List<DeviceFileEntryNode> nodes = this.getSelectedNodes();
            if (nodes == null) {
                return false;
            }
            return this.isEnabled(nodes);
        }

        public boolean isEnabled(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                TreeMenuItem.$$$reportNull$$$0(0);
            }
            return nodes.stream().anyMatch(this::isEnabled);
        }

        @Override
        public final boolean isVisible() {
            List<DeviceFileEntryNode> nodes = this.getSelectedNodes();
            if (nodes == null) {
                return false;
            }
            return this.isVisible(nodes);
        }

        public boolean isVisible(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes == null) {
                TreeMenuItem.$$$reportNull$$$0(1);
            }
            return nodes.stream().anyMatch(this::isVisible);
        }

        @Override
        public final void run() {
            List<DeviceFileEntryNode> nodes = this.getSelectedNodes();
            if (nodes == null) {
                return;
            }
            if (!(nodes = nodes.stream().filter(this::isEnabled).collect(Collectors.toList())).isEmpty()) {
                this.run(nodes);
            }
        }

        @Nullable
        private List<DeviceFileEntryNode> getSelectedNodes() {
            TreePath[] paths = DeviceExplorerViewImpl.this.myPanel.getTree().getSelectionPaths();
            if (paths == null) {
                return null;
            }
            List<DeviceFileEntryNode> nodes = Arrays.stream(paths).map(path2 -> DeviceFileEntryNode.fromNode(path2.getLastPathComponent())).filter(Objects::nonNull).collect(Collectors.toList());
            if (nodes.isEmpty()) {
                return null;
            }
            return nodes;
        }

        public boolean isVisible(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                TreeMenuItem.$$$reportNull$$$0(2);
            }
            return true;
        }

        public boolean isEnabled(@NotNull DeviceFileEntryNode node2) {
            if (node2 == null) {
                TreeMenuItem.$$$reportNull$$$0(3);
            }
            return this.isVisible(node2);
        }

        public abstract void run(@NotNull List<DeviceFileEntryNode> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$TreeMenuItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ModelListener
    implements DeviceExplorerModelListener {
        private ModelListener() {
        }

        @Override
        public void allDevicesRemoved() {
            DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().removeAllItems();
        }

        @Override
        public void deviceAdded(@NotNull DeviceFileSystem device) {
            if (device == null) {
                ModelListener.$$$reportNull$$$0(0);
            }
            DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().addItem(device);
        }

        @Override
        public void deviceRemoved(@NotNull DeviceFileSystem device) {
            if (device == null) {
                ModelListener.$$$reportNull$$$0(1);
            }
            DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().removeItem(device);
        }

        @Override
        public void deviceUpdated(@NotNull DeviceFileSystem device) {
            if (device == null) {
                ModelListener.$$$reportNull$$$0(2);
            }
            if (DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().getSelectedItem() == device) {
                DeviceExplorerViewImpl.this.myPanel.getDeviceCombo().repaint();
            }
        }

        @Override
        public void activeDeviceChanged(@Nullable DeviceFileSystem newActiveDevice) {
        }

        @Override
        public void treeModelChanged(@Nullable DefaultTreeModel newTreeModel, @Nullable DefaultTreeSelectionModel newTreeSelectionModel) {
            DeviceExplorerViewImpl.this.setRootFolder(newTreeModel, newTreeSelectionModel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "device";
            objectArray2[1] = "com/android/tools/idea/explorer/ui/DeviceExplorerViewImpl$ModelListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deviceAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deviceRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deviceUpdated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

