/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceCapabilities;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandBuilder;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandException;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandResult;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandsUtil;
import com.android.tools.idea.explorer.adbimpl.UniqueFileNameGenerator;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbFileOperations {
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final FutureCallbackExecutor myExecutor;
    @NotNull
    private final AdbDeviceCapabilities myDeviceCapabilities;

    public AdbFileOperations(@NotNull IDevice device, @NotNull AdbDeviceCapabilities deviceCapabilities, @NotNull Executor taskExecutor2) {
        if (device == null) {
            AdbFileOperations.$$$reportNull$$$0(0);
        }
        if (deviceCapabilities == null) {
            AdbFileOperations.$$$reportNull$$$0(1);
        }
        if (taskExecutor2 == null) {
            AdbFileOperations.$$$reportNull$$$0(2);
        }
        this.myDevice = device;
        this.myExecutor = FutureCallbackExecutor.wrap((Executor)taskExecutor2);
        this.myDeviceCapabilities = deviceCapabilities;
    }

    @NotNull
    public ListenableFuture<Void> createNewFile(@NotNull String parentPath, @NotNull String fileName) {
        if (parentPath == null) {
            AdbFileOperations.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            AdbFileOperations.$$$reportNull$$$0(4);
        }
        ListenableFuture<Void> listenableFuture = this.createNewFileRunAs(parentPath, fileName, null);
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(5);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> createNewFileRunAs(@NotNull String parentPath, @NotNull String fileName, @Nullable String runAs) {
        if (parentPath == null) {
            AdbFileOperations.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            AdbFileOperations.$$$reportNull$$$0(7);
        }
        ListenableFuture listenableFuture = this.myExecutor.executeAsync(() -> {
            if (fileName.contains("/")) {
                throw AdbShellCommandException.create("File name \"%s\" contains invalid characters", fileName);
            }
            String remotePath = AdbPathUtil.resolve(parentPath, fileName);
            String command = this.myDeviceCapabilities.supportsTestCommand() ? this.getCommand(runAs, "test -e ").withEscapedPath(remotePath).build() : this.getCommand(runAs, "ls -d -a ").withEscapedPath(remotePath).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            if (!commandResult.isError()) {
                throw AdbShellCommandException.create("File \"%s\" already exists on device", remotePath);
            }
            this.touchFileRunAs(remotePath, runAs);
            return null;
        });
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(8);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> createNewDirectory(@NotNull String parentPath, @NotNull String directoryName) {
        if (parentPath == null) {
            AdbFileOperations.$$$reportNull$$$0(9);
        }
        if (directoryName == null) {
            AdbFileOperations.$$$reportNull$$$0(10);
        }
        ListenableFuture<Void> listenableFuture = this.createNewDirectoryRunAs(parentPath, directoryName, null);
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(11);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> createNewDirectoryRunAs(@NotNull String parentPath, @NotNull String directoryName, @Nullable String runAs) {
        if (parentPath == null) {
            AdbFileOperations.$$$reportNull$$$0(12);
        }
        if (directoryName == null) {
            AdbFileOperations.$$$reportNull$$$0(13);
        }
        ListenableFuture listenableFuture = this.myExecutor.executeAsync(() -> {
            if (directoryName.contains("/")) {
                throw AdbShellCommandException.create("Directory name \"%s\" contains invalid characters", directoryName);
            }
            String remotePath = AdbPathUtil.resolve(parentPath, directoryName);
            String command = this.getCommand(runAs, "mkdir ").withEscapedPath(remotePath).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return null;
        });
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(14);
        }
        return listenableFuture;
    }

    public ListenableFuture<List<String>> listPackages() {
        return this.myExecutor.executeAsync(() -> {
            String command = this.getCommand(null, "pm list packages").build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return commandResult.getOutput().stream().map(AdbFileOperations::processPackageListLine).filter(x -> !StringUtil.isEmpty((String)x)).collect(Collectors.toList());
        });
    }

    @Nullable
    private static String processPackageListLine(@NotNull String line2) {
        String prefix;
        if (line2 == null) {
            AdbFileOperations.$$$reportNull$$$0(15);
        }
        if (!line2.startsWith(prefix = "package:")) {
            return null;
        }
        return line2.substring(prefix.length());
    }

    public ListenableFuture<List<PackageInfo>> listPackageInfo() {
        return this.myExecutor.executeAsync(() -> {
            String command = this.getCommand(null, "pm list packages -f").build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return commandResult.getOutput().stream().map(AdbFileOperations::processPackageInfoLine).filter(Objects::nonNull).collect(Collectors.toList());
        });
    }

    @Nullable
    private static PackageInfo processPackageInfoLine(@NotNull String line2) {
        String prefix;
        if (line2 == null) {
            AdbFileOperations.$$$reportNull$$$0(16);
        }
        if (!line2.startsWith(prefix = "package:")) {
            return null;
        }
        int separatorIndex = line2.indexOf(61, prefix.length());
        if (separatorIndex < 0) {
            return null;
        }
        String path2 = line2.substring(prefix.length(), separatorIndex).trim();
        if (StringUtil.isEmpty((String)path2)) {
            return null;
        }
        String packageName = line2.substring(separatorIndex + 1).trim();
        if (StringUtil.isEmpty((String)packageName)) {
            return null;
        }
        return new PackageInfo(packageName, path2);
    }

    @NotNull
    public ListenableFuture<Void> deleteFile(@NotNull String path2) {
        if (path2 == null) {
            AdbFileOperations.$$$reportNull$$$0(17);
        }
        ListenableFuture<Void> listenableFuture = this.deleteFileRunAs(path2, null);
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(18);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> deleteFileRunAs(@NotNull String path2, @Nullable String runAs) {
        if (path2 == null) {
            AdbFileOperations.$$$reportNull$$$0(19);
        }
        ListenableFuture listenableFuture = this.myExecutor.executeAsync(() -> {
            String command = this.getRmCommand(runAs, path2, false);
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return null;
        });
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(20);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> deleteRecursive(@NotNull String path2) {
        if (path2 == null) {
            AdbFileOperations.$$$reportNull$$$0(21);
        }
        ListenableFuture<Void> listenableFuture = this.deleteRecursiveRunAs(path2, null);
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(22);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> deleteRecursiveRunAs(@NotNull String path2, @Nullable String runAs) {
        if (path2 == null) {
            AdbFileOperations.$$$reportNull$$$0(23);
        }
        ListenableFuture listenableFuture = this.myExecutor.executeAsync(() -> {
            String command = this.getRmCommand(runAs, path2, true);
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return null;
        });
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(24);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> copyFile(@NotNull String source, @NotNull String destination) {
        if (source == null) {
            AdbFileOperations.$$$reportNull$$$0(25);
        }
        if (destination == null) {
            AdbFileOperations.$$$reportNull$$$0(26);
        }
        ListenableFuture<Void> listenableFuture = this.copyFileRunAs(source, destination, null);
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(27);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> copyFileRunAs(@NotNull String source, @NotNull String destination, @Nullable String runAs) {
        if (source == null) {
            AdbFileOperations.$$$reportNull$$$0(28);
        }
        if (destination == null) {
            AdbFileOperations.$$$reportNull$$$0(29);
        }
        ListenableFuture listenableFuture = this.myExecutor.executeAsync(() -> {
            String command = this.myDeviceCapabilities.supportsCpCommand() ? this.getCommand(runAs, "cp ").withEscapedPath(source).withText(" ").withEscapedPath(destination).build() : this.getCommand(runAs, "cat ").withEscapedPath(source).withText(" >").withEscapedPath(destination).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return null;
        });
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(30);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<String> createTempFile(@NotNull String tempPath) {
        if (tempPath == null) {
            AdbFileOperations.$$$reportNull$$$0(31);
        }
        ListenableFuture<String> listenableFuture = this.createTempFileRunAs(tempPath, null);
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(32);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<String> createTempFileRunAs(@NotNull String tempDirectoy, @Nullable String runAs) {
        if (tempDirectoy == null) {
            AdbFileOperations.$$$reportNull$$$0(33);
        }
        ListenableFuture listenableFuture = this.myExecutor.executeAsync(() -> {
            String tempFileName = UniqueFileNameGenerator.getInstance().getUniqueFileName("temp", "");
            String remotePath = AdbPathUtil.resolve(tempDirectoy, tempFileName);
            this.touchFileRunAs(remotePath, runAs);
            return remotePath;
        });
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(34);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Void> touchFileAsDefaultUser(@NotNull String remotePath) {
        if (remotePath == null) {
            AdbFileOperations.$$$reportNull$$$0(35);
        }
        ListenableFuture listenableFuture = this.myExecutor.executeAsync(() -> {
            String command = this.myDeviceCapabilities.supportsTouchCommand() ? new AdbShellCommandBuilder().withText("touch ").withEscapedPath(remotePath).build() : new AdbShellCommandBuilder().withText("echo -n >").withEscapedPath(remotePath).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            commandResult.throwIfError();
            return null;
        });
        if (listenableFuture == null) {
            AdbFileOperations.$$$reportNull$$$0(36);
        }
        return listenableFuture;
    }

    private void touchFileRunAs(@NotNull String remotePath, @Nullable String runAs) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AdbShellCommandException {
        if (remotePath == null) {
            AdbFileOperations.$$$reportNull$$$0(37);
        }
        String command = this.myDeviceCapabilities.supportsTouchCommand() ? this.getCommand(runAs, "touch ").withEscapedPath(remotePath).build() : this.getCommand(runAs, "echo -n >").withEscapedPath(remotePath).build();
        AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
        commandResult.throwIfError();
    }

    @NotNull
    private String getRmCommand(@Nullable String runAs, @NotNull String path2, boolean recursive) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        if (path2 == null) {
            AdbFileOperations.$$$reportNull$$$0(38);
        }
        if (this.myDeviceCapabilities.supportsRmForceFlag()) {
            String string = this.getCommand(runAs, String.format("rm %s-f ", recursive ? "-r " : "")).withEscapedPath(path2).build();
            if (string == null) {
                AdbFileOperations.$$$reportNull$$$0(39);
            }
            return string;
        }
        String string = this.getCommand(runAs, String.format("rm %s", recursive ? "-r " : "")).withEscapedPath(path2).build();
        if (string == null) {
            AdbFileOperations.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    private AdbShellCommandBuilder getCommand(@Nullable String runAs, @NotNull String text2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (text2 == null) {
            AdbFileOperations.$$$reportNull$$$0(41);
        }
        AdbShellCommandBuilder command = new AdbShellCommandBuilder();
        if (this.myDeviceCapabilities.supportsSuRootCommand()) {
            command.withSuRootPrefix();
        } else if (runAs != null) {
            command.withRunAs(runAs);
        }
        AdbShellCommandBuilder adbShellCommandBuilder = command.withText(text2);
        if (adbShellCommandBuilder == null) {
            AdbFileOperations.$$$reportNull$$$0(42);
        }
        return adbShellCommandBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceCapabilities";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbFileOperations";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempPath";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDirectoy";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbFileOperations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewFileRunAs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDirectoryRunAs";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteFileRunAs";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteRecursive";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteRecursiveRunAs";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileRunAs";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFileRunAs";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "touchFileAsDefaultUser";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getRmCommand";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNewFile";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 42: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewFileRunAs";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNewDirectory";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNewDirectoryRunAs";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processPackageListLine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processPackageInfoLine";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deleteFileRunAs";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursive";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursiveRunAs";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "copyFileRunAs";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createTempFileRunAs";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "touchFileAsDefaultUser";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "touchFileRunAs";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getRmCommand";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PackageInfo {
        @NotNull
        private final String myName;
        @NotNull
        private final String myPath;

        public PackageInfo(@NotNull String name, @NotNull String path2) {
            if (name == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            if (path2 == null) {
                PackageInfo.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myPath = path2;
        }

        @NotNull
        public String getPackageName() {
            String string = this.myName;
            if (string == null) {
                PackageInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                PackageInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String toString() {
            return String.format("%s: path=%s", this.myName, this.myPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbFileOperations$PackageInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbFileOperations$PackageInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackageName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

