/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.tools.idea.explorer.adbimpl.AdbDeviceDirectFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceForwardingFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntryBuilder;
import com.android.tools.idea.explorer.adbimpl.AdbFileOperations;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AdbDeviceDataDirectoryEntry
extends AdbDeviceForwardingFileEntry {
    @NotNull
    private final AdbDeviceDirectFileEntry myDirectEntry;

    public AdbDeviceDataDirectoryEntry(@NotNull AdbDeviceFileEntry entry) {
        if (entry == null) {
            AdbDeviceDataDirectoryEntry.$$$reportNull$$$0(0);
        }
        super(entry.myDevice, entry.myEntry, entry.myParent);
        this.myDirectEntry = new AdbDeviceDirectFileEntry(entry.myDevice, entry.myEntry, entry.myParent, null);
    }

    @Override
    @NotNull
    public AdbDeviceFileEntry getForwardedFileEntry() {
        AdbDeviceDirectFileEntry adbDeviceDirectFileEntry = this.myDirectEntry;
        if (adbDeviceDirectFileEntry == null) {
            AdbDeviceDataDirectoryEntry.$$$reportNull$$$0(1);
        }
        return adbDeviceDirectFileEntry;
    }

    private static AdbFileListingEntry createDirectoryEntry(@NotNull AdbFileListingEntry parent, @NotNull String name) {
        if (parent == null) {
            AdbDeviceDataDirectoryEntry.$$$reportNull$$$0(2);
        }
        if (name == null) {
            AdbDeviceDataDirectoryEntry.$$$reportNull$$$0(3);
        }
        return new AdbFileListingEntryBuilder(parent).setPath(AdbPathUtil.resolve(parent.getFullPath(), name)).build();
    }

    private static AdbFileListingEntry createFileEntry(@NotNull AdbFileListingEntry parent, @NotNull String name) {
        if (parent == null) {
            AdbDeviceDataDirectoryEntry.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AdbDeviceDataDirectoryEntry.$$$reportNull$$$0(5);
        }
        return new AdbFileListingEntryBuilder(parent).setPath(AdbPathUtil.resolve(parent.getFullPath(), name)).setKind(AdbFileListingEntry.EntryKind.FILE).setSize(-1L).build();
    }

    @Override
    @NotNull
    public ListenableFuture<List<DeviceFileEntry>> getEntries() {
        ListenableFuture listenableFuture = this.myDevice.getTaskExecutor().executeAsync(() -> {
            ArrayList<AdbDeviceForwardingFileEntry> entries = new ArrayList<AdbDeviceForwardingFileEntry>();
            entries.add(new AdbDeviceDataAppDirectoryEntry(this, AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, "app")));
            entries.add(new AdbDeviceDataDataDirectoryEntry(this, AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, "data")));
            entries.add(new AdbDeviceDataLocalDirectoryEntry(this, AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, "local")));
            return entries;
        });
        if (listenableFuture == null) {
            AdbDeviceDataDirectoryEntry.$$$reportNull$$$0(6);
        }
        return listenableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDataDirectoryEntry";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDataDirectoryEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getForwardedFileEntry";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryEntry";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFileEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AdbDevicePackageDirectoryEntry
    extends AdbDeviceForwardingFileEntry {
        @NotNull
        private final String myPackageName;
        @NotNull
        private final AdbDeviceDirectFileEntry myDirectEntry;

        public AdbDevicePackageDirectoryEntry(@NotNull AdbDeviceFileEntry parent, @NotNull AdbFileListingEntry entry, @NotNull String packageName) {
            if (parent == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(1);
            }
            if (packageName == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(2);
            }
            super(parent.myDevice, entry, parent);
            this.myPackageName = packageName;
            this.myDirectEntry = new AdbDeviceDirectFileEntry(parent.myDevice, entry, parent, packageName);
        }

        @Override
        @NotNull
        public AdbDeviceFileEntry getForwardedFileEntry() {
            AdbDeviceDirectFileEntry adbDeviceDirectFileEntry = this.myDirectEntry;
            if (adbDeviceDirectFileEntry == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(3);
            }
            return adbDeviceDirectFileEntry;
        }

        @Override
        @NotNull
        public ListenableFuture<List<DeviceFileEntry>> getEntries() {
            ListenableFuture<List<AdbFileListingEntry>> futureChildren = this.myDevice.getAdbFileListing().getChildrenRunAs(this.myEntry, this.myPackageName);
            ListenableFuture listenableFuture = this.myDevice.getTaskExecutor().transform(futureChildren, entries -> {
                assert (entries != null);
                return ContainerUtil.map((Collection)entries, x -> new AdbDevicePackageDirectoryEntry(this, (AdbFileListingEntry)x, this.myPackageName));
            });
            if (listenableFuture == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(4);
            }
            return listenableFuture;
        }

        @Override
        @NotNull
        public ListenableFuture<Void> downloadFile(@NotNull Path localPath, @NotNull FileTransferProgress progress) {
            if (localPath == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(5);
            }
            if (progress == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(6);
            }
            ListenableFuture<Void> listenableFuture = this.myDevice.getAdbFileTransfer().downloadFileViaTempLocation(this.getFullPath(), this.getSize(), localPath, progress, this.myPackageName);
            if (listenableFuture == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(7);
            }
            return listenableFuture;
        }

        @Override
        @NotNull
        public ListenableFuture<Void> uploadFile(@NotNull Path localPath, @NotNull String fileName, @NotNull FileTransferProgress progress) {
            if (localPath == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(8);
            }
            if (fileName == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(9);
            }
            if (progress == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(10);
            }
            ListenableFuture<Void> listenableFuture = this.myDevice.getAdbFileTransfer().uploadFileViaTempLocation(localPath, AdbPathUtil.resolve(this.getFullPath(), fileName), progress, this.myPackageName);
            if (listenableFuture == null) {
                AdbDevicePackageDirectoryEntry.$$$reportNull$$$0(11);
            }
            return listenableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDataDirectoryEntry$AdbDevicePackageDirectoryEntry";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDataDirectoryEntry$AdbDevicePackageDirectoryEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForwardedFileEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEntries";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "downloadFile";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uploadFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadFile";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "uploadFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AdbDeviceDataLocalDirectoryEntry
    extends AdbDeviceForwardingFileEntry {
        @NotNull
        private final AdbDeviceDirectFileEntry myDirectEntry;

        public AdbDeviceDataLocalDirectoryEntry(@NotNull AdbDeviceFileEntry parent, @NotNull AdbFileListingEntry entry) {
            if (parent == null) {
                AdbDeviceDataLocalDirectoryEntry.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                AdbDeviceDataLocalDirectoryEntry.$$$reportNull$$$0(1);
            }
            super(parent.myDevice, entry, parent);
            this.myDirectEntry = new AdbDeviceDirectFileEntry(parent.myDevice, entry, parent, null);
        }

        @Override
        @NotNull
        public AdbDeviceFileEntry getForwardedFileEntry() {
            AdbDeviceDirectFileEntry adbDeviceDirectFileEntry = this.myDirectEntry;
            if (adbDeviceDirectFileEntry == null) {
                AdbDeviceDataLocalDirectoryEntry.$$$reportNull$$$0(2);
            }
            return adbDeviceDirectFileEntry;
        }

        @Override
        @NotNull
        public ListenableFuture<List<DeviceFileEntry>> getEntries() {
            ListenableFuture listenableFuture = this.myDevice.getTaskExecutor().executeAsync(() -> {
                ArrayList<AdbDeviceDirectFileEntry> entries = new ArrayList<AdbDeviceDirectFileEntry>();
                entries.add(new AdbDeviceDirectFileEntry(this.myDevice, AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, "tmp"), this, null));
                return entries;
            });
            if (listenableFuture == null) {
                AdbDeviceDataLocalDirectoryEntry.$$$reportNull$$$0(3);
            }
            return listenableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDataDirectoryEntry$AdbDeviceDataLocalDirectoryEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDataDirectoryEntry$AdbDeviceDataLocalDirectoryEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForwardedFileEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AdbDeviceDataAppDirectoryEntry
    extends AdbDeviceForwardingFileEntry {
        @NotNull
        private final AdbDeviceDirectFileEntry myDirectEntry;

        public AdbDeviceDataAppDirectoryEntry(@NotNull AdbDeviceFileEntry parent, @NotNull AdbFileListingEntry entry) {
            if (parent == null) {
                AdbDeviceDataAppDirectoryEntry.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                AdbDeviceDataAppDirectoryEntry.$$$reportNull$$$0(1);
            }
            super(parent.myDevice, entry, parent);
            this.myDirectEntry = new AdbDeviceDirectFileEntry(parent.myDevice, entry, parent, null);
        }

        @Override
        @NotNull
        public AdbDeviceFileEntry getForwardedFileEntry() {
            AdbDeviceDirectFileEntry adbDeviceDirectFileEntry = this.myDirectEntry;
            if (adbDeviceDirectFileEntry == null) {
                AdbDeviceDataAppDirectoryEntry.$$$reportNull$$$0(2);
            }
            return adbDeviceDirectFileEntry;
        }

        @Override
        @NotNull
        public ListenableFuture<List<DeviceFileEntry>> getEntries() {
            ListenableFuture<List<AdbFileOperations.PackageInfo>> futurePackages = this.myDevice.getAdbFileOperations().listPackageInfo();
            ListenableFuture listenableFuture = this.myDevice.getTaskExecutor().transform(futurePackages, packages -> {
                assert (packages != null);
                return packages.stream().map(info2 -> {
                    List<String> segments = AdbPathUtil.getSegments(info2.getPath());
                    if (segments.size() <= 2) {
                        return null;
                    }
                    if (!"data".equals(segments.get(0))) {
                        return null;
                    }
                    if (!"app".equals(segments.get(1))) {
                        return null;
                    }
                    if (segments.size() == 3) {
                        AdbFileListingEntry entry = AdbDeviceDataDirectoryEntry.createFileEntry(this.myEntry, segments.get(2));
                        return new AdbDeviceDirectFileEntry(this.myDevice, entry, this, info2.getPackageName());
                    }
                    AdbFileListingEntry entry = AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, segments.get(2));
                    return new AdbDevicePackageDirectoryEntry(this, entry, info2.getPackageName());
                }).filter(Objects::nonNull).collect(Collectors.toList());
            });
            if (listenableFuture == null) {
                AdbDeviceDataAppDirectoryEntry.$$$reportNull$$$0(3);
            }
            return listenableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDataDirectoryEntry$AdbDeviceDataAppDirectoryEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDataDirectoryEntry$AdbDeviceDataAppDirectoryEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForwardedFileEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AdbDeviceDataDataDirectoryEntry
    extends AdbDeviceForwardingFileEntry {
        @NotNull
        private final AdbDeviceDirectFileEntry myDirectEntry;

        public AdbDeviceDataDataDirectoryEntry(@NotNull AdbDeviceFileEntry parent, @NotNull AdbFileListingEntry entry) {
            if (parent == null) {
                AdbDeviceDataDataDirectoryEntry.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                AdbDeviceDataDataDirectoryEntry.$$$reportNull$$$0(1);
            }
            super(parent.myDevice, entry, parent);
            this.myDirectEntry = new AdbDeviceDirectFileEntry(parent.myDevice, entry, parent, null);
        }

        @Override
        @NotNull
        public AdbDeviceFileEntry getForwardedFileEntry() {
            AdbDeviceDirectFileEntry adbDeviceDirectFileEntry = this.myDirectEntry;
            if (adbDeviceDirectFileEntry == null) {
                AdbDeviceDataDataDirectoryEntry.$$$reportNull$$$0(2);
            }
            return adbDeviceDirectFileEntry;
        }

        @Override
        @NotNull
        public ListenableFuture<List<DeviceFileEntry>> getEntries() {
            ListenableFuture<List<String>> futurePackages = this.myDevice.getAdbFileOperations().listPackages();
            ListenableFuture listenableFuture = this.myDevice.getTaskExecutor().transform(futurePackages, packages -> {
                assert (packages != null);
                return packages.stream().map(packageName -> new AdbDevicePackageDirectoryEntry(this, AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, packageName), (String)packageName)).collect(Collectors.toList());
            });
            if (listenableFuture == null) {
                AdbDeviceDataDataDirectoryEntry.$$$reportNull$$$0(3);
            }
            return listenableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDataDirectoryEntry$AdbDeviceDataDataDirectoryEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceDataDirectoryEntry$AdbDeviceDataDataDirectoryEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForwardedFileEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

