/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandBuilder;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandException;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandResult;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandsUtil;
import com.android.tools.idea.explorer.adbimpl.DeviceUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbDeviceCapabilities {
    @NotNull
    private static final Logger LOGGER = Logger.getInstance(AdbDeviceCapabilities.class);
    @NotNull
    private static final String PROBE_FILES_TEMP_PATH = AdbPathUtil.resolve("/data/local/tmp", "device-explorer");
    @NotNull
    private static final String ESCAPING_LS_ESCAPED_PATH = AdbPathUtil.resolve("/data/local/tmp", "oyX2HCKL\\ acuauQGJ");
    @NotNull
    private static final String ESCAPING_LS_NOT_ESCAPED_PATH = AdbPathUtil.resolve("/data/local/tmp", "oyX2HCKL acuauQGJ");
    @NotNull
    private final IDevice myDevice;
    @Nullable
    private Boolean mySupportsTestCommand;
    @Nullable
    private Boolean mySupportsRmForceFlag;
    @Nullable
    private Boolean mySupportsTouchCommand;
    @Nullable
    private Boolean mySupportsSuRootCommand;
    @Nullable
    private Boolean myIsRoot;
    @Nullable
    private Boolean mySupportsCpCommand;
    @Nullable
    private Boolean myEscapingLs;
    @Nullable
    private Boolean mySupportsMkTempCommand;

    public AdbDeviceCapabilities(@NotNull IDevice device) {
        if (device == null) {
            AdbDeviceCapabilities.$$$reportNull$$$0(0);
        }
        this.myDevice = device;
    }

    public synchronized boolean supportsTestCommand() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        AdbDeviceCapabilities.assertNotDispatchThread();
        if (this.mySupportsTestCommand == null) {
            this.mySupportsTestCommand = this.supportsTestCommandWorker();
        }
        return this.mySupportsTestCommand;
    }

    public synchronized boolean supportsRmForceFlag() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        AdbDeviceCapabilities.assertNotDispatchThread();
        if (this.mySupportsRmForceFlag == null) {
            this.mySupportsRmForceFlag = this.supportsRmForceFlagWorker();
        }
        return this.mySupportsRmForceFlag;
    }

    public synchronized boolean supportsTouchCommand() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbDeviceCapabilities.assertNotDispatchThread();
        if (this.mySupportsTouchCommand == null) {
            this.mySupportsTouchCommand = this.supportsTouchCommandWorker();
        }
        return this.mySupportsTouchCommand;
    }

    public synchronized boolean supportsSuRootCommand() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbDeviceCapabilities.assertNotDispatchThread();
        if (this.mySupportsSuRootCommand == null) {
            this.mySupportsSuRootCommand = this.supportsSuRootCommandWorker();
        }
        return this.mySupportsSuRootCommand;
    }

    public synchronized boolean isRoot() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbDeviceCapabilities.assertNotDispatchThread();
        if (this.myIsRoot == null) {
            this.myIsRoot = this.isRootWorker();
        }
        return this.myIsRoot;
    }

    public synchronized boolean supportsCpCommand() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        AdbDeviceCapabilities.assertNotDispatchThread();
        if (this.mySupportsCpCommand == null) {
            this.mySupportsCpCommand = this.supportsCpCommandWorker();
        }
        return this.mySupportsCpCommand;
    }

    synchronized boolean hasEscapingLs() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbDeviceCapabilities.assertNotDispatchThread();
        if (this.myEscapingLs == null) {
            this.myEscapingLs = this.hasEscapingLsWorker();
        }
        return this.myEscapingLs;
    }

    public synchronized boolean supportsMkTempCommand() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbDeviceCapabilities.assertNotDispatchThread();
        if (this.mySupportsMkTempCommand == null) {
            this.mySupportsMkTempCommand = this.supportsMkTempCommandWorker();
        }
        return this.mySupportsMkTempCommand;
    }

    private static void assertNotDispatchThread() {
        Application application = ApplicationManager.getApplication();
        assert (application == null || !application.isDispatchThread());
    }

    @NotNull
    private static String getCommandOutputExtract(@NotNull AdbShellCommandResult commandResult) {
        List<String> output;
        if (commandResult == null) {
            AdbDeviceCapabilities.$$$reportNull$$$0(1);
        }
        if ((output = commandResult.getOutput()).isEmpty()) {
            return "[command output is empty]";
        }
        String string = output.stream().limit(5L).collect(Collectors.joining("\n  ", "\n  ", ""));
        if (string == null) {
            AdbDeviceCapabilities.$$$reportNull$$$0(2);
        }
        return string;
    }

    private boolean supportsTestCommandWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        try (ScopedRemoteFile tempFile = new ScopedRemoteFile(AdbPathUtil.resolve(PROBE_FILES_TEMP_PATH, ".__temp_test_test__file__.tmp"));){
            tempFile.create();
            String command = new AdbShellCommandBuilder().withText("test -e ").withEscapedPath(tempFile.getRemotePath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            try {
                commandResult.throwIfError();
                boolean bl = true;
                return bl;
            }
            catch (AdbShellCommandException e) {
                LOGGER.info(String.format("Device \"%s\" does not seem to support the \"test\" command: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
                boolean bl = false;
                tempFile.close();
                return bl;
            }
        }
    }

    public boolean supportsRmForceFlagWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        try (ScopedRemoteFile tempFile = new ScopedRemoteFile(AdbPathUtil.resolve(PROBE_FILES_TEMP_PATH, ".__temp_rm_test_file__.tmp"));){
            tempFile.create();
            String command = new AdbShellCommandBuilder().withText("rm -f ").withEscapedPath(tempFile.getRemotePath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            try {
                commandResult.throwIfError();
                tempFile.setDeleteOnClose(false);
                boolean bl = true;
                return bl;
            }
            catch (AdbShellCommandException e) {
                LOGGER.info(String.format("Device \"%s\" does not seem to support \"-f\" flag for rm: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
                boolean bl = false;
                tempFile.close();
                return bl;
            }
        }
    }

    private boolean supportsTouchCommandWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        try (ScopedRemoteFile tempFile = new ScopedRemoteFile(AdbPathUtil.resolve(PROBE_FILES_TEMP_PATH, ".__temp_touch_test_file__.tmp"));){
            String command = new AdbShellCommandBuilder().withText("touch ").withEscapedPath(tempFile.getRemotePath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            try {
                commandResult.throwIfError();
                tempFile.setDeleteOnClose(true);
                boolean bl = true;
                return bl;
            }
            catch (AdbShellCommandException e) {
                LOGGER.info(String.format("Device \"%s\" does not seem to support \"touch\" command: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
                boolean bl = false;
                tempFile.close();
                return bl;
            }
        }
    }

    private boolean supportsSuRootCommandWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String command = new AdbShellCommandBuilder().withSuRootPrefix().withText("id").build();
        AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
        try {
            commandResult.throwIfError();
            return true;
        }
        catch (AdbShellCommandException e) {
            LOGGER.info(String.format("Device \"%s\" does not seem to support the \"su 0\" command: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
            return false;
        }
    }

    private boolean isRootWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.myDevice.isRoot();
    }

    private boolean supportsCpCommandWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, SyncException {
        try (ScopedRemoteFile srcFile = new ScopedRemoteFile(AdbPathUtil.resolve(PROBE_FILES_TEMP_PATH, ".__temp_cp_test_file__.tmp"));){
            ScopedRemoteFile dstFile = new ScopedRemoteFile(AdbPathUtil.resolve(PROBE_FILES_TEMP_PATH, ".__temp_cp_test_file_dst__.tmp"));
            srcFile.create();
            String command = new AdbShellCommandBuilder().withText("cp ").withEscapedPath(srcFile.getRemotePath()).withText(" ").withEscapedPath(dstFile.getRemotePath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            try {
                commandResult.throwIfError();
                dstFile.setDeleteOnClose(true);
                boolean bl = true;
                dstFile.close();
                return bl;
            }
            catch (AdbShellCommandException e) {
                try {
                    LOGGER.info(String.format("Device \"%s\" does not seem to support the \"cp\" command: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
                    boolean bl = false;
                    dstFile.close();
                    srcFile.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        dstFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private boolean hasEscapingLsWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        try {
            this.touchEscapedPath();
        }
        catch (AdbShellCommandException exception) {
            LOGGER.info("Device \"" + DeviceUtil.toDebugString(this.myDevice) + "\" does not seem to support the touch command", (Throwable)exception);
            return false;
        }
        ScopedRemoteFile file2 = new ScopedRemoteFile(ESCAPING_LS_NOT_ESCAPED_PATH);
        try {
            file2.setDeleteOnClose(true);
            boolean bl = this.lsEscapedPath();
            file2.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    file2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (AdbShellCommandException exception) {
                LOGGER.info("Device \"" + DeviceUtil.toDebugString(this.myDevice) + "\" does not seem to support the ls command", (Throwable)exception);
                return false;
            }
        }
    }

    private void touchEscapedPath() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AdbShellCommandException {
        String command = new AdbShellCommandBuilder().withText("touch " + ESCAPING_LS_ESCAPED_PATH).build();
        AdbShellCommandResult result2 = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
        result2.throwIfError();
        if (!result2.getOutput().isEmpty()) {
            throw new AdbShellCommandException("Unexpected output from touch");
        }
    }

    private boolean lsEscapedPath() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AdbShellCommandException {
        String command = new AdbShellCommandBuilder().withText("ls " + ESCAPING_LS_ESCAPED_PATH).build();
        AdbShellCommandResult result2 = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
        result2.throwIfError();
        String output = result2.getOutput().get(0);
        if (output.equals(ESCAPING_LS_ESCAPED_PATH)) {
            return true;
        }
        if (output.equals(ESCAPING_LS_NOT_ESCAPED_PATH)) {
            return false;
        }
        throw new AdbShellCommandException("Unexpected output from ls");
    }

    private boolean supportsMkTempCommandWorker() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String command = new AdbShellCommandBuilder().withText("mktemp -p ").withEscapedPath("/data/local/tmp").build();
        AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
        try {
            commandResult.throwIfError();
            if (commandResult.getOutput().isEmpty()) {
                throw new AdbShellCommandException("Unexpected output from mktemp, assuming not supported");
            }
            String remotePath = commandResult.getOutput().get(0);
            try (ScopedRemoteFile tempFile = new ScopedRemoteFile(remotePath);){
                tempFile.setDeleteOnClose(true);
            }
            return true;
        }
        catch (AdbShellCommandException e) {
            LOGGER.info(String.format("Device \"%s\" does not seem to support the \"cp\" command: %s", DeviceUtil.toDebugString(this.myDevice), AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceCapabilities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceCapabilities";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandOutputExtract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCommandOutputExtract";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScopedRemoteFile
    implements AutoCloseable {
        @NotNull
        private final String myRemotePath;
        private boolean myDeleteOnClose;

        public ScopedRemoteFile(String remotePath) {
            if (remotePath == null) {
                ScopedRemoteFile.$$$reportNull$$$0(0);
            }
            this.myRemotePath = remotePath;
        }

        public void setDeleteOnClose(boolean value2) {
            this.myDeleteOnClose = value2;
        }

        @NotNull
        public String getRemotePath() {
            String string = this.myRemotePath;
            if (string == null) {
                ScopedRemoteFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void create() throws TimeoutException, AdbCommandRejectedException, SyncException, IOException {
            assert (!this.myDeleteOnClose);
            this.myDeleteOnClose = this.createRemoteTemporaryFile();
        }

        @Override
        public void close() {
            if (!this.myDeleteOnClose) {
                return;
            }
            try {
                String command = new AdbShellCommandBuilder().withText("rm ").withEscapedPath(this.myRemotePath).build();
                AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(AdbDeviceCapabilities.this.myDevice, command);
                try {
                    commandResult.throwIfError();
                }
                catch (AdbShellCommandException e) {
                    LOGGER.warn(String.format("Device \"%s\": Error deleting temporary test file \"%s\": %s", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice), this.myRemotePath, AdbDeviceCapabilities.getCommandOutputExtract(commandResult)), (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Device \"%s\": Error deleting temporary test file \"%s\"", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice), this.myRemotePath), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean createRemoteTemporaryFile() throws IOException, TimeoutException, AdbCommandRejectedException, SyncException {
            File file2 = FileUtil.createTempFile((String)this.myRemotePath, (String)"", (boolean)true);
            SyncService sync = AdbDeviceCapabilities.this.myDevice.getSyncService();
            if (sync == null) {
                throw new IOException(String.format("Device \"%s\": Unable to open sync connection", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice)));
            }
            LOGGER.trace(String.format("Device \"%s\": Uploading temporary file \"%s\" to remote file \"%s\"", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice), file2, this.myRemotePath));
            sync.pushFile(file2.getPath(), this.myRemotePath, SyncService.getNullProgressMonitor());
            boolean bl = true;
            sync.close();
            try {
                FileUtil.delete((File)file2);
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Device \"%s\": Error deleting temporary file \"%s\"", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice), file2), (Throwable)e);
            }
            return bl;
            {
                catch (Throwable throwable) {
                    try {
                        sync.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        try {
                            FileUtil.delete((File)file2);
                        }
                        catch (Exception e) {
                            LOGGER.warn(String.format("Device \"%s\": Error deleting temporary file \"%s\"", DeviceUtil.toDebugString(AdbDeviceCapabilities.this.myDevice), file2), (Throwable)e);
                        }
                        throw throwable2;
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remotePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceCapabilities$ScopedRemoteFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbDeviceCapabilities$ScopedRemoteFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemotePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

