/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.annotations.concurrency.UiThread;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.device.fs.DeviceFileDownloaderService;
import com.android.tools.idea.device.fs.DownloadProgress;
import com.android.tools.idea.explorer.DeviceExplorerFileManager;
import com.android.tools.idea.explorer.DeviceFileDownloaderServiceImpl;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceFileSystemService;
import com.android.utils.FileUtils;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.ide.PooledThreadExecutor;

@UiThread
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J@\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00150\u00170\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J@\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00150\u00170\u00112\u0006\u0010!\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J*\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00140\u00112\u0006\u0010$\u001a\u00020#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014H\u0002J\u0016\u0010&\u001a\u00020'2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014H\u0002J*\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00140\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014H\u0002R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/explorer/DeviceFileDownloaderServiceImpl;", "Lcom/android/tools/idea/device/fs/DeviceFileDownloaderService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "deviceFileSystemService", "Lcom/android/tools/idea/explorer/fs/DeviceFileSystemService;", "fileManager", "Lcom/android/tools/idea/explorer/DeviceExplorerFileManager;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/explorer/fs/DeviceFileSystemService;Lcom/android/tools/idea/explorer/DeviceExplorerFileManager;)V", "edtExecutor", "Lcom/intellij/util/concurrency/EdtExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "taskExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "deleteFiles", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "doDownload", "", "", "deviceFileSystem", "Lcom/android/tools/idea/explorer/fs/DeviceFileSystem;", "onDevicePaths", "downloadProgress", "Lcom/android/tools/idea/device/fs/DownloadProgress;", "localDestinationDirectory", "Ljava/nio/file/Path;", "downloadFiles", "deviceSerialNumber", "getEntriesFromCommonParent", "Lcom/android/tools/idea/explorer/fs/DeviceFileEntry;", "parent", "paths", "haveSameParent", "", "mapPathsToEntries", "intellij.android.core"})
public final class DeviceFileDownloaderServiceImpl
implements DeviceFileDownloaderService {
    private final ExecutorService taskExecutor;
    private final EdtExecutorService edtExecutor;
    private final Project project;
    private final DeviceFileSystemService<?> deviceFileSystemService;
    private final DeviceExplorerFileManager fileManager;

    @Override
    @NotNull
    public ListenableFuture<Map<String, VirtualFile>> downloadFiles(@NotNull String deviceSerialNumber, @NotNull List<String> onDevicePaths, @NotNull DownloadProgress downloadProgress, @NotNull Path localDestinationDirectory) {
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        Intrinsics.checkNotNullParameter(onDevicePaths, (String)"onDevicePaths");
        Intrinsics.checkNotNullParameter((Object)downloadProgress, (String)"downloadProgress");
        Intrinsics.checkNotNullParameter((Object)localDestinationDirectory, (String)"localDestinationDirectory");
        if (onDevicePaths.isEmpty()) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)MapsKt.emptyMap());
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFuture(emptyMap())");
            return listenableFuture;
        }
        ListenableFuture<Void> listenableFuture = this.deviceFileSystemService.start(new Supplier(this){
            final /* synthetic */ DeviceFileDownloaderServiceImpl this$0;

            public final File get() {
                return AndroidSdkUtils.getAdb(DeviceFileDownloaderServiceImpl.access$getProject$p(this.this$0));
            }
            {
                this.this$0 = deviceFileDownloaderServiceImpl;
            }
        });
        Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"deviceFileSystemService.\u2026dkUtils.getAdb(project) }");
        return FutureUtils.catching((ListenableFuture)FutureUtils.transformAsyncNullable(listenableFuture, (Executor)((Executor)this.edtExecutor), (Function1)((Function1)new Function1<Void, ListenableFuture<Map<String, ? extends VirtualFile>>>(this, deviceSerialNumber, onDevicePaths, downloadProgress, localDestinationDirectory){
            final /* synthetic */ DeviceFileDownloaderServiceImpl this$0;
            final /* synthetic */ String $deviceSerialNumber;
            final /* synthetic */ List $onDevicePaths;
            final /* synthetic */ DownloadProgress $downloadProgress;
            final /* synthetic */ Path $localDestinationDirectory;

            @NotNull
            public final ListenableFuture<Map<String, VirtualFile>> invoke(@Nullable Void it) {
                ListenableFuture<List<S>> listenableFuture = DeviceFileDownloaderServiceImpl.access$getDeviceFileSystemService$p(this.this$0).getDevices();
                Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"deviceFileSystemService.devices");
                ExecutorService executorService = DeviceFileDownloaderServiceImpl.access$getTaskExecutor$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"taskExecutor");
                return FutureUtils.transformAsync(listenableFuture, (Executor)executorService, (Function1)((Function1)new Function1<List<? extends DeviceFileSystem>, ListenableFuture<Map<String, ? extends VirtualFile>>>(this){
                    final /* synthetic */ downloadFiles.2 this$0;

                    @NotNull
                    public final ListenableFuture<Map<String, VirtualFile>> invoke(List<? extends DeviceFileSystem> devices2) {
                        Object v2;
                        boolean bl;
                        boolean bl2;
                        block2: {
                            List<? extends DeviceFileSystem> list = devices2;
                            Intrinsics.checkNotNull(list);
                            Iterable iterable = list;
                            bl2 = false;
                            Iterable iterable2 = iterable;
                            bl = false;
                            for (T t : iterable2) {
                                DeviceFileSystem it = (DeviceFileSystem)t;
                                boolean bl3 = false;
                                DeviceFileSystem deviceFileSystem = it;
                                Intrinsics.checkNotNullExpressionValue((Object)deviceFileSystem, (String)"it");
                                if (!Intrinsics.areEqual((Object)deviceFileSystem.getDeviceSerialNumber(), (Object)this.this$0.$deviceSerialNumber)) continue;
                                v2 = t;
                                break block2;
                            }
                            v2 = null;
                        }
                        DeviceFileSystem deviceFileSystem = v2;
                        boolean bl4 = deviceFileSystem != null;
                        bl2 = false;
                        boolean bl5 = false;
                        bl5 = false;
                        bl = false;
                        if (!bl4) {
                            boolean bl6 = false;
                            String string = "Failed requirement.";
                            throw (Throwable)new IllegalArgumentException(string.toString());
                        }
                        return DeviceFileDownloaderServiceImpl.access$doDownload(this.this$0.this$0, deviceFileSystem, this.this$0.$onDevicePaths, this.this$0.$downloadProgress, this.this$0.$localDestinationDirectory);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = deviceFileDownloaderServiceImpl;
                this.$deviceSerialNumber = string;
                this.$onDevicePaths = list;
                this.$downloadProgress = downloadProgress;
                this.$localDestinationDirectory = path2;
                super(1);
            }
        })), (Executor)((Executor)this.edtExecutor), AdbCommandRejectedException.class, (Function1)downloadFiles.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ListenableFuture<Unit> deleteFiles(@NotNull List<? extends VirtualFile> virtualFiles) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
        Iterable $this$map$iv = virtualFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            ListenableFuture<Void> listenableFuture = this.fileManager.deleteFile((VirtualFile)it);
            Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"fileManager.deleteFile(it)");
            ExecutorService executorService = this.taskExecutor;
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"taskExecutor");
            ListenableFuture listenableFuture2 = FutureUtils.transformNullable(listenableFuture, (Executor)executorService, (Function1)deleteFiles.futures.1.1.INSTANCE);
            collection2.add(listenableFuture2);
        }
        List futures2 = (List)destination$iv$iv;
        ListenableFuture listenableFuture = Futures.whenAllSucceed((Iterable)futures2).call((Callable)deleteFiles.1.INSTANCE, (Executor)this.taskExecutor);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.whenAllSucceed(f\u2026( { Unit }, taskExecutor)");
        return listenableFuture;
    }

    private final ListenableFuture<Map<String, VirtualFile>> doDownload(DeviceFileSystem deviceFileSystem, List<String> onDevicePaths, DownloadProgress downloadProgress, Path localDestinationDirectory) {
        ListenableFuture<List<DeviceFileEntry>> futureEntries = this.mapPathsToEntries(deviceFileSystem, onDevicePaths);
        ExecutorService executorService = this.taskExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"taskExecutor");
        return FutureUtils.transformAsync(futureEntries, (Executor)executorService, (Function1)((Function1)new Function1<List<? extends DeviceFileEntry>, ListenableFuture<Map<String, ? extends VirtualFile>>>(this, localDestinationDirectory, downloadProgress){
            final /* synthetic */ DeviceFileDownloaderServiceImpl this$0;
            final /* synthetic */ Path $localDestinationDirectory;
            final /* synthetic */ DownloadProgress $downloadProgress;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ListenableFuture<Map<String, VirtualFile>> invoke(@NotNull List<? extends DeviceFileEntry> entries) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(entries, (String)"entries");
                Iterable $this$map$iv = entries;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    Path localPath;
                    void entry;
                    DeviceFileEntry deviceFileEntry = (DeviceFileEntry)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)DeviceFileDownloaderServiceImpl.access$getFileManager$p(this.this$0).getPathForEntry((DeviceFileEntry)entry, this.$localDestinationDirectory), (String)"fileManager.getPathForEn\u2026ocalDestinationDirectory)");
                    FileUtils.mkdirs((File)localPath.getParent().toFile());
                    ListenableFuture<VirtualFile> listenableFuture = DeviceFileDownloaderServiceImpl.access$getFileManager$p(this.this$0).downloadFileEntry((DeviceFileEntry)entry, localPath, this.$downloadProgress);
                    Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"fileManager\n          .d\u2026alPath, downloadProgress)");
                    ExecutorService executorService = DeviceFileDownloaderServiceImpl.access$getTaskExecutor$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"taskExecutor");
                    ListenableFuture listenableFuture2 = FutureUtils.transform(listenableFuture, (Executor)executorService, (Function1)((Function1)new Function1<VirtualFile, Pair<? extends String, ? extends VirtualFile>>((DeviceFileEntry)entry){
                        final /* synthetic */ DeviceFileEntry $entry;

                        @NotNull
                        public final Pair<String, VirtualFile> invoke(VirtualFile file2) {
                            return new Pair((Object)this.$entry.getFullPath(), (Object)file2);
                        }
                        {
                            this.$entry = deviceFileEntry;
                            super(1);
                        }
                    }));
                    collection2.add(listenableFuture2);
                }
                List futurePairs2 = (List)destination$iv$iv;
                ListenableFuture listenableFuture = Futures.allAsList((Iterable)futurePairs2);
                Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures\n        // if a \u2026  .allAsList(futurePairs)");
                ExecutorService executorService = DeviceFileDownloaderServiceImpl.access$getTaskExecutor$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"taskExecutor");
                return FutureUtils.transform((ListenableFuture)listenableFuture, (Executor)executorService, (Function1)doDownload.1.INSTANCE);
            }
            {
                this.this$0 = deviceFileDownloaderServiceImpl;
                this.$localDestinationDirectory = path2;
                this.$downloadProgress = downloadProgress;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final ListenableFuture<List<DeviceFileEntry>> mapPathsToEntries(DeviceFileSystem deviceFileSystem, List<String> onDevicePaths) {
        ListenableFuture listenableFuture;
        if (this.haveSameParent(onDevicePaths)) {
            String string = AdbPathUtil.getParentPath(onDevicePaths.get(0));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AdbPathUtil.getParentPath(onDevicePaths[0])");
            String parentPath = string;
            ListenableFuture<DeviceFileEntry> listenableFuture2 = deviceFileSystem.getEntry(parentPath);
            Intrinsics.checkNotNullExpressionValue(listenableFuture2, (String)"deviceFileSystem.getEntry(parentPath)");
            ListenableFuture<DeviceFileEntry> parentEntryFuture = listenableFuture2;
            ExecutorService executorService = this.taskExecutor;
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"taskExecutor");
            ListenableFuture listenableFuture3 = FutureUtils.catching(parentEntryFuture, (Executor)executorService, IllegalArgumentException.class, (Function1)mapPathsToEntries.1.INSTANCE);
            ExecutorService executorService2 = this.taskExecutor;
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"taskExecutor");
            listenableFuture = FutureUtils.transformAsyncNullable((ListenableFuture)listenableFuture3, (Executor)executorService2, (Function1)((Function1)new Function1<DeviceFileEntry, ListenableFuture<List<? extends DeviceFileEntry>>>(this, onDevicePaths){
                final /* synthetic */ DeviceFileDownloaderServiceImpl this$0;
                final /* synthetic */ List $onDevicePaths;

                @NotNull
                public final ListenableFuture<List<DeviceFileEntry>> invoke(@Nullable DeviceFileEntry parentEntry) {
                    ListenableFuture listenableFuture;
                    if (parentEntry == null) {
                        ListenableFuture listenableFuture2 = Futures.immediateFuture((Object)CollectionsKt.emptyList());
                        listenableFuture = listenableFuture2;
                        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture2, (String)"Futures.immediateFuture(emptyList())");
                    } else {
                        listenableFuture = DeviceFileDownloaderServiceImpl.access$getEntriesFromCommonParent(this.this$0, parentEntry, this.$onDevicePaths);
                    }
                    return listenableFuture;
                }
                {
                    this.this$0 = deviceFileDownloaderServiceImpl;
                    this.$onDevicePaths = list;
                    super(1);
                }
            }));
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = onDevicePaths;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                ListenableFuture<DeviceFileEntry> listenableFuture4 = deviceFileSystem.getEntry((String)it);
                collection2.add(listenableFuture4);
            }
            List futureEntries = (List)destination$iv$iv;
            ListenableFuture listenableFuture5 = Futures.successfulAsList((Iterable)futureEntries);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture5, (String)"Futures\n        // if th\u2026sfulAsList(futureEntries)");
            ExecutorService executorService = this.taskExecutor;
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"taskExecutor");
            listenableFuture = FutureUtils.transform((ListenableFuture)listenableFuture5, (Executor)executorService, (Function1)mapPathsToEntries.3.INSTANCE);
        }
        return listenableFuture;
    }

    private final ListenableFuture<List<DeviceFileEntry>> getEntriesFromCommonParent(DeviceFileEntry parent, List<String> paths) {
        ListenableFuture<List<DeviceFileEntry>> listenableFuture = parent.getEntries();
        Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"parent\n      .entries");
        ExecutorService executorService = this.taskExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"taskExecutor");
        return FutureUtils.transform(listenableFuture, (Executor)executorService, (Function1)((Function1)new Function1<List<DeviceFileEntry>, List<? extends DeviceFileEntry>>(paths){
            final /* synthetic */ List $paths;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<DeviceFileEntry> invoke(List<DeviceFileEntry> entries) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.$paths;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    DeviceFileEntry deviceFileEntry;
                    Object v2;
                    block2: {
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String path2 = (String)element$iv$iv;
                        boolean bl2 = false;
                        List<DeviceFileEntry> list = entries;
                        Intrinsics.checkNotNullExpressionValue(list, (String)"entries");
                        Iterable $this$firstOrNull$iv = list;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            DeviceFileEntry it = (DeviceFileEntry)element$iv;
                            boolean bl3 = false;
                            DeviceFileEntry deviceFileEntry2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)deviceFileEntry2, (String)"it");
                            if (!Intrinsics.areEqual((Object)deviceFileEntry2.getFullPath(), (Object)path2)) continue;
                            v2 = element$iv;
                            break block2;
                        }
                        v2 = null;
                    }
                    if ((DeviceFileEntry)v2 == null) continue;
                    boolean bl = false;
                    boolean bl4 = false;
                    DeviceFileEntry it$iv$iv = deviceFileEntry;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$paths = list;
                super(1);
            }
        }));
    }

    private final boolean haveSameParent(List<String> paths) {
        boolean bl;
        block4: {
            if (paths.isEmpty()) {
                return false;
            }
            String firstPath = paths.get(0);
            String string = AdbPathUtil.getParentPath(firstPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AdbPathUtil.getParentPath(firstPath)");
            String parentPath = string;
            Iterable $this$none$iv = paths;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)AdbPathUtil.getParentPath(it), (Object)parentPath) ^ true)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NonInjectable
    @TestOnly
    public DeviceFileDownloaderServiceImpl(@NotNull Project project, @NotNull DeviceFileSystemService<?> deviceFileSystemService, @NotNull DeviceExplorerFileManager fileManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(deviceFileSystemService, (String)"deviceFileSystemService");
        Intrinsics.checkNotNullParameter((Object)fileManager, (String)"fileManager");
        this.project = project;
        this.deviceFileSystemService = deviceFileSystemService;
        this.fileManager = fileManager;
        this.taskExecutor = PooledThreadExecutor.INSTANCE;
        EdtExecutorService edtExecutorService = EdtExecutorService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)edtExecutorService, (String)"EdtExecutorService.getInstance()");
        this.edtExecutor = edtExecutorService;
    }

    public DeviceFileDownloaderServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AdbDeviceFileSystemService adbDeviceFileSystemService = AdbDeviceFileSystemService.getInstance(project);
        if (adbDeviceFileSystemService == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.explorer.fs.DeviceFileSystemService<*>");
        }
        DeviceFileSystemService deviceFileSystemService = adbDeviceFileSystemService;
        DeviceExplorerFileManager deviceExplorerFileManager = DeviceExplorerFileManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)deviceExplorerFileManager, (String)"DeviceExplorerFileManager.getInstance(project)");
        this(project, deviceFileSystemService, deviceExplorerFileManager);
    }

    public static final /* synthetic */ Project access$getProject$p(DeviceFileDownloaderServiceImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ DeviceFileSystemService access$getDeviceFileSystemService$p(DeviceFileDownloaderServiceImpl $this) {
        return $this.deviceFileSystemService;
    }

    public static final /* synthetic */ ExecutorService access$getTaskExecutor$p(DeviceFileDownloaderServiceImpl $this) {
        return $this.taskExecutor;
    }

    public static final /* synthetic */ ListenableFuture access$doDownload(DeviceFileDownloaderServiceImpl $this, DeviceFileSystem deviceFileSystem, List onDevicePaths, DownloadProgress downloadProgress, Path localDestinationDirectory) {
        return $this.doDownload(deviceFileSystem, onDevicePaths, downloadProgress, localDestinationDirectory);
    }

    public static final /* synthetic */ DeviceExplorerFileManager access$getFileManager$p(DeviceFileDownloaderServiceImpl $this) {
        return $this.fileManager;
    }

    public static final /* synthetic */ ListenableFuture access$getEntriesFromCommonParent(DeviceFileDownloaderServiceImpl $this, DeviceFileEntry parent, List paths) {
        return $this.getEntriesFromCommonParent(parent, paths);
    }
}

