/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.device.fs.DeviceFileId;
import com.android.tools.idea.device.fs.DownloadProgress;
import com.android.tools.idea.explorer.DeviceExplorerFileManager;
import com.android.tools.idea.explorer.DeviceExplorerFilesUtils;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.android.tools.idea.explorer.options.DeviceFileExplorerSettings;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.PathUtilRt;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class DeviceExplorerFileManagerImpl
implements DeviceExplorerFileManager {
    private static final Logger LOGGER = Logger.getInstance(DeviceExplorerFileManagerImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;
    @NotNull
    private Supplier<Path> myDefaultDownloadPath;

    private DeviceExplorerFileManagerImpl(@NotNull Project project) {
        if (project == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(0);
        }
        this(project, (Executor)new FutureCallbackExecutor((Executor)EdtExecutorService.getInstance()), (Executor)new FutureCallbackExecutor((Executor)PooledThreadExecutor.INSTANCE), () -> Paths.get(DeviceFileExplorerSettings.getInstance().getDownloadLocation(), new String[0]));
    }

    @NonInjectable
    @VisibleForTesting
    public DeviceExplorerFileManagerImpl(@NotNull Project project, @NotNull Executor edtExecutor2, @NotNull Executor taskExecutor2, @NotNull Supplier<Path> downloadPathSupplier) {
        if (project == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(1);
        }
        if (edtExecutor2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(2);
        }
        if (taskExecutor2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(3);
        }
        if (downloadPathSupplier == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (VfsUtilCore.isAncestor((File)DeviceExplorerFileManagerImpl.this.getDefaultDownloadPath().toFile(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (boolean)true)) {
                    Path localPath = Paths.get(file2.getPath(), new String[0]);
                    DeviceExplorerFileManagerImpl.deleteTemporaryFile(localPath);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl$1";
                objectArray[2] = "fileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myEdtExecutor = new FutureCallbackExecutor(edtExecutor2);
        this.myTaskExecutor = new FutureCallbackExecutor(taskExecutor2);
        this.myDefaultDownloadPath = downloadPathSupplier;
    }

    @NotNull
    public Path getDefaultLocalPathForDevice(@NotNull DeviceFileSystem device) {
        if (device == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(5);
        }
        Path rootPath = this.getDefaultDownloadPath();
        Path path2 = rootPath.resolve(DeviceExplorerFileManagerImpl.mapName(device.getName()));
        if (path2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(6);
        }
        return path2;
    }

    @Override
    @NotNull
    public Path getDefaultLocalPathForEntry(@NotNull DeviceFileEntry entry) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(7);
        }
        Path devicePath = this.getDefaultLocalPathForDevice(entry.getFileSystem());
        Path path2 = this.getPathForEntry(entry, devicePath);
        if (path2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(8);
        }
        return path2;
    }

    @Override
    @NotNull
    public ListenableFuture<VirtualFile> downloadFileEntry(@NotNull DeviceFileEntry entry, @NotNull Path localPath, @NotNull DownloadProgress progress) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(9);
        }
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(10);
        }
        if (progress == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(11);
        }
        final SettableFuture futureResult = SettableFuture.create();
        FileUtils.mkdirs((File)localPath.getParent().toFile());
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)localPath.toFile(), (boolean)true);
            if (virtualFile != null) {
                try {
                    this.deleteVirtualFile(virtualFile);
                }
                catch (Throwable exception) {
                    futureResult.setException(exception);
                    return;
                }
            }
            this.myTaskExecutor.addCallback(this.downloadFile(entry, localPath, progress), (FutureCallback)new FutureCallback<VirtualFile>(){

                public void onSuccess(VirtualFile result2) {
                    futureResult.set((Object)result2);
                }

                public void onFailure(@NotNull Throwable throwable) {
                    if (throwable == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    futureResult.setException(throwable);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl$2", "onFailure"));
                }
            });
        }), this.myProject.getDisposed());
        SettableFuture settableFuture = futureResult;
        if (settableFuture == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(12);
        }
        return settableFuture;
    }

    @Override
    public ListenableFuture<Void> deleteFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(13);
        }
        SettableFuture futureResult = SettableFuture.create();
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                this.deleteVirtualFile(virtualFile);
                futureResult.set(null);
            }
            catch (Throwable exception) {
                futureResult.setException(exception);
            }
        }), this.myProject.getDisposed());
        return futureResult;
    }

    private void deleteVirtualFile(@NotNull VirtualFile virtualFile) throws IOException {
        if (virtualFile == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(14);
        }
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        virtualFile.delete((Object)this);
    }

    @NotNull
    private ListenableFuture<VirtualFile> downloadFile(final @NotNull DeviceFileEntry entry, final @NotNull Path localPath, final @NotNull DownloadProgress progress) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(15);
        }
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(16);
        }
        if (progress == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(17);
        }
        FileTransferProgress fileTransferProgress = this.createFileTransferProgress(entry, progress);
        progress.onStarting(entry.getFullPath());
        ListenableFuture<Void> downloadFileFuture = entry.downloadFile(localPath, fileTransferProgress);
        ListenableFuture getVirtualFile = this.myTaskExecutor.transformAsync(downloadFileFuture, aVoid -> DeviceExplorerFilesUtils.findFile(localPath));
        this.myEdtExecutor.addCallback(getVirtualFile, (FutureCallback)new FutureCallback<VirtualFile>(){

            public void onSuccess(VirtualFile virtualFile) {
                DeviceFileId fileInfo = new DeviceFileId(entry.getFileSystem().getName(), entry.getFullPath());
                fileInfo.storeInVirtualFile(virtualFile);
                progress.onCompleted(entry.getFullPath());
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                progress.onCompleted(entry.getFullPath());
                DeviceExplorerFileManagerImpl.deleteTemporaryFile(localPath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl$3", "onFailure"));
            }
        });
        ListenableFuture listenableFuture = getVirtualFile;
        if (listenableFuture == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(18);
        }
        return listenableFuture;
    }

    private FileTransferProgress createFileTransferProgress(final @NotNull DeviceFileEntry entry, final @NotNull DownloadProgress progress) {
        if (entry == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(19);
        }
        if (progress == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(20);
        }
        return new FileTransferProgress(){

            @Override
            public void progress(long currentBytes, long totalBytes) {
                progress.onProgress(entry.getFullPath(), currentBytes, totalBytes);
            }

            @Override
            public boolean isCancelled() {
                return progress.isCancelled();
            }
        };
    }

    @NotNull
    private ListenableFuture<List<DeviceFileEntry>> mapPathsToEntries(@NotNull DeviceFileSystem fileSystem, @NotNull List<String> paths) {
        if (fileSystem == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(21);
        }
        if (paths == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(22);
        }
        ArrayList entries = new ArrayList();
        ListenableFuture allDone = this.myTaskExecutor.executeFuturesInSequence(paths.iterator(), path2 -> {
            ListenableFuture<DeviceFileEntry> futureEntry = fileSystem.getEntry((String)path2);
            return this.myTaskExecutor.transform(futureEntry, entry -> {
                entries.add(entry);
                return null;
            });
        });
        ListenableFuture listenableFuture = this.myTaskExecutor.transform(allDone, aVoid -> entries);
        if (listenableFuture == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(23);
        }
        return listenableFuture;
    }

    @NotNull
    private Path getDefaultDownloadPath() {
        Path path2 = this.myDefaultDownloadPath.get();
        if (path2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(24);
        }
        return path2;
    }

    @NotNull
    private static String mapName(String name) {
        String string = PathUtilRt.suggestFileName((String)name, (boolean)true, (boolean)true);
        if (string == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Override
    @NotNull
    public Path getPathForEntry(@NotNull DeviceFileEntry file2, @NotNull Path destinationPath) {
        if (file2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(26);
        }
        if (destinationPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(27);
        }
        ArrayList<String> entryPathComponents = new ArrayList<String>();
        for (DeviceFileEntry entry = file2; entry != null; entry = entry.getParent()) {
            entryPathComponents.add(DeviceExplorerFileManagerImpl.mapName(entry.getName()));
        }
        Collections.reverse(entryPathComponents);
        Path entryDestinationPath = destinationPath;
        for (String name : entryPathComponents) {
            entryDestinationPath = entryDestinationPath.resolve(name);
        }
        Path path2 = entryDestinationPath;
        if (path2 == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(28);
        }
        return path2;
    }

    private static void deleteTemporaryFile(@NotNull Path localPath) {
        if (localPath == null) {
            DeviceExplorerFileManagerImpl.$$$reportNull$$$0(29);
        }
        try {
            Files.deleteIfExists(localPath);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Error deleting device file from local file system \"%s\"", localPath), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadPathSupplier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl";
                break;
            }
            case 7: 
            case 9: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 10: 
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 11: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/explorer/DeviceExplorerFileManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLocalPathForDevice";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLocalPathForEntry";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFileEntry";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "mapPathsToEntries";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDownloadPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "mapName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLocalPathForDevice";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLocalPathForEntry";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "downloadFileEntry";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteVirtualFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFileTransferProgress";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mapPathsToEntries";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPathForEntry";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deleteTemporaryFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

