/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs;

import com.android.tools.idea.experimental.codeanalysis.datastructs.Modifier;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGField;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGMethod;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGPartialMethodSignature;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.BlockGraph;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCFGClass
implements PsiAnnotationOwner {
    public static final PsiCFGClass[] EMPTY_ARRAY = new PsiCFGClass[0];
    private PsiClass mRef;
    private PsiLambdaExpression mLambdaExpressionRef;
    private PsiFile mPsiFileRef;
    private int mModifierbits;
    private boolean mIsInterface = false;
    protected Map<PsiMethod, PsiCFGMethod> mMethodMap;
    protected Map<PsiCFGPartialMethodSignature, PsiCFGMethod> mSignatureMethodMap;
    protected ArrayList<PsiCFGMethod> mMethodList;
    protected Map<String, PsiCFGField> mFieldMap;
    protected boolean mIsAnonlymous;
    protected boolean mIsLambda;
    protected boolean mIsNestedClass;
    protected PsiCFGMethod mNestedClassParentMethod;
    protected BlockGraph mNestedClassParentBlock;
    protected ArrayList<PsiCFGClass> declaredAnonymousClass;
    protected ArrayList<PsiCFGClass> declaredLambda;
    protected String qualifiedClassName;
    protected PsiCFGClass mSuperCFGClass;
    protected Set<PsiCFGClass> mImplementedInterfacesSet;
    protected Set<PsiCFGClass> mDirectSubClasses;
    protected Set<PsiCFGClass> mDirectSubInterfaces;
    protected Map<String, Set<PsiCFGClass>> nestedInnerClassMap;
    protected boolean mLibraryClass;
    protected PsiCFGClass mDirectOverriddenInterface;

    public PsiCFGClass(@Nullable PsiClass origin, @Nullable PsiFile declearingFile) {
        this.mRef = origin;
        this.mPsiFileRef = declearingFile;
        this.parseModifierList();
        this.mIsAnonlymous = false;
        this.mIsLambda = false;
        this.mLibraryClass = false;
        this.mIsNestedClass = false;
        this.mNestedClassParentMethod = null;
        this.qualifiedClassName = origin != null && origin.getQualifiedName() != null ? origin.getQualifiedName() : "";
        this.declaredAnonymousClass = new ArrayList();
        this.declaredLambda = new ArrayList();
        this.mMethodMap = Maps.newHashMap();
        this.mFieldMap = Maps.newHashMap();
        this.mSuperCFGClass = null;
        this.mImplementedInterfacesSet = new HashSet<PsiCFGClass>();
        this.mDirectSubClasses = new HashSet<PsiCFGClass>();
        this.mDirectSubInterfaces = new HashSet<PsiCFGClass>();
        this.mMethodList = new ArrayList();
        this.mSignatureMethodMap = Maps.newHashMap();
        this.nestedInnerClassMap = Maps.newHashMap();
    }

    public void setLibraryClass() {
        this.mLibraryClass = true;
    }

    public boolean isLibraryClass() {
        return this.mLibraryClass;
    }

    @Nullable
    public PsiCFGClass getSuperClass() {
        return this.mSuperCFGClass;
    }

    public void setSuperClass(@NotNull PsiCFGClass clazz) {
        if (clazz == null) {
            PsiCFGClass.$$$reportNull$$$0(0);
        }
        this.mSuperCFGClass = clazz;
    }

    public void addSubClass(@NotNull PsiCFGClass clazz) {
        if (clazz == null) {
            PsiCFGClass.$$$reportNull$$$0(1);
        }
        this.mDirectSubClasses.add(clazz);
    }

    @NotNull
    public Set<PsiCFGClass> getSubClassSet() {
        Set<PsiCFGClass> set = this.mDirectSubClasses;
        if (set == null) {
            PsiCFGClass.$$$reportNull$$$0(2);
        }
        return set;
    }

    public void addSubInterface(@NotNull PsiCFGClass interfaze) {
        if (interfaze == null) {
            PsiCFGClass.$$$reportNull$$$0(3);
        }
        this.mDirectSubClasses.add(interfaze);
    }

    public void addInterface(@NotNull PsiCFGClass interfaze) {
        if (interfaze == null) {
            PsiCFGClass.$$$reportNull$$$0(4);
        }
        this.mImplementedInterfacesSet.add(interfaze);
    }

    @NotNull
    public Set<PsiCFGClass> getImplementedInterfaceSet() {
        Set<PsiCFGClass> set = this.mImplementedInterfacesSet;
        if (set == null) {
            PsiCFGClass.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public PsiCFGClass[] getImplementedInterfaceArray() {
        PsiCFGClass[] psiCFGClassArray = this.mImplementedInterfacesSet.toArray(EMPTY_ARRAY);
        if (psiCFGClassArray == null) {
            PsiCFGClass.$$$reportNull$$$0(6);
        }
        return psiCFGClassArray;
    }

    @NotNull
    public PsiCFGClass[] getAllSupers() {
        ArrayList<PsiCFGClass> supersList = new ArrayList<PsiCFGClass>();
        supersList.add(this.mSuperCFGClass);
        supersList.addAll(this.mImplementedInterfacesSet);
        PsiCFGClass[] psiCFGClassArray = supersList.toArray(EMPTY_ARRAY);
        if (psiCFGClassArray == null) {
            PsiCFGClass.$$$reportNull$$$0(7);
        }
        return psiCFGClassArray;
    }

    @Nullable
    public PsiLambdaExpression getPsiLambdaRef() {
        return this.mLambdaExpressionRef;
    }

    public void setLambdaRef(@NotNull PsiLambdaExpression lambdaRef) {
        if (lambdaRef == null) {
            PsiCFGClass.$$$reportNull$$$0(8);
        }
        this.mLambdaExpressionRef = lambdaRef;
        this.mIsLambda = true;
    }

    @Nullable
    public PsiClass getPsiClass() {
        return this.mRef;
    }

    public boolean isPublic() {
        return (this.mModifierbits & 1) != 0;
    }

    public boolean isInterface() {
        return this.mIsInterface;
    }

    public void setIsInterface(boolean isInterface) {
        this.mIsInterface = isInterface;
    }

    @Nullable
    public PsiFile getDeclearingFile() {
        return this.mPsiFileRef;
    }

    public boolean isAnonymous() {
        return this.mIsAnonlymous;
    }

    public void setAnonlymous() {
        this.mIsAnonlymous = true;
    }

    public void setNested() {
        this.mIsNestedClass = true;
    }

    public boolean isNested() {
        return this.mIsNestedClass;
    }

    @Nullable
    public PsiCFGMethod getDeclaringCFGMethod() {
        return this.mNestedClassParentMethod;
    }

    public void setDeclaringCFGMethod(PsiCFGMethod method2) {
        this.mNestedClassParentMethod = method2;
    }

    public BlockGraph getDeclaringBlock() {
        return this.mNestedClassParentBlock;
    }

    public void setDeclaringBlock(BlockGraph parentBlock) {
        this.mNestedClassParentBlock = parentBlock;
    }

    public String toString() {
        return this.getQualifiedClassName();
    }

    public PsiCFGClass getAnonymousClassDirectParent() {
        return this.mDirectOverriddenInterface;
    }

    public PsiCFGClass addAnonymousClass(PsiCFGClass anonymousClass) {
        int curCount = this.declaredAnonymousClass.size() + 1;
        anonymousClass.qualifiedClassName = this.qualifiedClassName + "$" + curCount;
        this.declaredAnonymousClass.add(anonymousClass);
        return anonymousClass;
    }

    public PsiCFGClass addNestedInnerClass(PsiCFGClass nestedClass, String name) {
        String qualifiedName;
        Set<Object> currentCFGClassSet;
        if (name == null) {
            name = "";
        }
        if (this.nestedInnerClassMap.containsKey(name)) {
            currentCFGClassSet = this.nestedInnerClassMap.get(name);
        } else {
            currentCFGClassSet = new HashSet();
            this.nestedInnerClassMap.put(name, currentCFGClassSet);
        }
        int indexNumber = currentCFGClassSet.size() + 1;
        nestedClass.qualifiedClassName = qualifiedName = String.format(Locale.US, "%s.$%d%s", this.qualifiedClassName, indexNumber, name);
        currentCFGClassSet.add(nestedClass);
        return nestedClass;
    }

    public PsiCFGClass addLambda(PsiCFGClass lambdaClass) {
        int curCount = this.declaredLambda.size() + 1;
        lambdaClass.qualifiedClassName = this.qualifiedClassName + "$lambda$" + curCount;
        this.declaredLambda.add(lambdaClass);
        return lambdaClass;
    }

    public void setDirectOverride(PsiCFGClass cfgClass) {
        this.mDirectOverriddenInterface = cfgClass;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        if (this.mRef.getModifierList() != null) {
            PsiAnnotation[] psiAnnotationArray = this.mRef.getModifierList().getAnnotations();
            if (psiAnnotationArray == null) {
                PsiCFGClass.$$$reportNull$$$0(9);
            }
            return psiAnnotationArray;
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            PsiCFGClass.$$$reportNull$$$0(10);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        if (this.mRef.getModifierList() != null) {
            PsiAnnotation[] psiAnnotationArray = this.mRef.getModifierList().getApplicableAnnotations();
            if (psiAnnotationArray == null) {
                PsiCFGClass.$$$reportNull$$$0(11);
            }
            return psiAnnotationArray;
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            PsiCFGClass.$$$reportNull$$$0(12);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @Nullable
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            PsiCFGClass.$$$reportNull$$$0(13);
        }
        if (this.mRef.getModifierList() != null) {
            return this.mRef.getModifierList().findAnnotation(qualifiedName);
        }
        return null;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            PsiCFGClass.$$$reportNull$$$0(14);
        }
        if (this.mRef.getModifierList() != null) {
            PsiAnnotation psiAnnotation = this.mRef.getModifierList().addAnnotation(qualifiedName);
            if (psiAnnotation == null) {
                PsiCFGClass.$$$reportNull$$$0(15);
            }
            return psiAnnotation;
        }
        if (null == null) {
            PsiCFGClass.$$$reportNull$$$0(16);
        }
        return null;
    }

    private void parseModifierList() {
        if (this.mRef != null) {
            PsiModifierList modList = this.mRef.getModifierList();
            if (modList == null) {
                this.mModifierbits = 2;
            } else {
                Modifier.ParseModifierList(modList);
            }
        }
    }

    @NotNull
    public String getQualifiedClassName() {
        String string = this.qualifiedClassName;
        if (string == null) {
            PsiCFGClass.$$$reportNull$$$0(17);
        }
        return string;
    }

    public void addMethod(@NotNull PsiCFGMethod method2) {
        if (method2 == null) {
            PsiCFGClass.$$$reportNull$$$0(18);
        }
        this.mMethodList.add(method2);
        PsiMethod methodRef = method2.getMethodRef();
        if (methodRef != null) {
            this.mMethodMap.put(methodRef, method2);
        }
        this.mSignatureMethodMap.put(method2.getSignature(), method2);
    }

    public void addField(@NotNull PsiCFGField field2) {
        if (field2 == null) {
            PsiCFGClass.$$$reportNull$$$0(19);
        }
        this.mFieldMap.put(field2.getPsiFieldRef().getName(), field2);
    }

    @Nullable
    public PsiCFGField getField(String name) {
        if (this.mFieldMap.containsKey(name)) {
            return this.mFieldMap.get(name);
        }
        return null;
    }

    @Nullable
    public PsiCFGMethod getMethod(PsiMethod method2) {
        if (this.mMethodMap.containsKey(method2)) {
            return this.mMethodMap.get(method2);
        }
        return null;
    }

    @Nullable
    public PsiCFGMethod getMethod(PsiCFGPartialMethodSignature signature) {
        if (this.mSignatureMethodMap.containsKey(signature)) {
            return this.mSignatureMethodMap.get(signature);
        }
        return null;
    }

    @NotNull
    public PsiCFGMethod[] getAllMethods() {
        PsiCFGMethod[] retArray = this.mMethodList.toArray(PsiCFGMethod.EMPTY_ARRAY);
        if (retArray == null) {
            PsiCFGClass.$$$reportNull$$$0(20);
        }
        return retArray;
    }

    @NotNull
    public PsiCFGField[] getAllFields() {
        PsiCFGField[] retArray = new PsiCFGField[this.mFieldMap.size()];
        int i2 = 0;
        for (String key : this.mFieldMap.keySet()) {
            retArray[i2++] = this.mFieldMap.get(key);
        }
        if (retArray == null) {
            PsiCFGClass.$$$reportNull$$$0(21);
        }
        return retArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaze";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaRef";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/experimental/codeanalysis/datastructs/PsiCFGClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubClassSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedInterfaceSet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedInterfaceArray";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSupers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedClassName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSuperClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addSubClass";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSubInterface";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addInterface";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLambdaRef";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addMethod";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

