/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.callgraph;

import com.android.tools.idea.experimental.codeanalysis.PsiCFGScene;
import com.android.tools.idea.experimental.codeanalysis.callgraph.Callgraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGMethod;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGPartialMethodSignature;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.Graph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.MethodGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.stmt.AssignStmt;
import com.android.tools.idea.experimental.codeanalysis.datastructs.stmt.Stmt;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.InstanceInvokeExpr;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.InvokeExpr;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.NewExpr;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.StaticInvokeExpr;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.ThisRef;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.Value;
import com.android.tools.idea.experimental.codeanalysis.utils.PsiCFGAnalysisUtil;
import com.android.tools.idea.experimental.codeanalysis.utils.PsiCFGDebugUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CallgraphBuilder {
    protected PsiCFGScene mScene;
    protected PsiCFGAnalysisUtil mAnalysisUtil;
    protected Callgraph mCallGraphInstance;
    protected Map<Pair<PsiCFGClass, PsiCFGPartialMethodSignature>, Set<PsiCFGMethod>> mMethodOrderTreeMap;
    public PsiCFGClass JAVA_LANG_OBJECT;

    public CallgraphBuilder(@NotNull PsiCFGScene scene, @NotNull PsiCFGAnalysisUtil analysisUtil) {
        if (scene == null) {
            CallgraphBuilder.$$$reportNull$$$0(0);
        }
        if (analysisUtil == null) {
            CallgraphBuilder.$$$reportNull$$$0(1);
        }
        this.mScene = scene;
        this.mAnalysisUtil = analysisUtil;
        this.mMethodOrderTreeMap = Maps.newHashMap();
        this.JAVA_LANG_OBJECT = this.mScene.getPsiCFGClass("java.lang.Object");
    }

    public void build() {
        GraphNode[] invocationNodes;
        this.mCallGraphInstance = new Callgraph();
        for (GraphNode invocationNode : invocationNodes = this.mScene.getAllInvocationNode()) {
            this.processSingleInvocation(invocationNode);
        }
    }

    public void processSingleInvocation(GraphNode node2) {
        Stmt[] stmtWithInvocationArray = node2.getStatements();
        if (stmtWithInvocationArray.length != 1) {
            PsiCFGDebugUtil.LOG.warning("Node contains more than 1 stmt" + node2.getSimpleName());
            return;
        }
        Stmt stmtWithInvocation = stmtWithInvocationArray[0];
        if (stmtWithInvocation instanceof AssignStmt) {
            Value Rop = ((AssignStmt)stmtWithInvocation).getROp();
            if (Rop instanceof InvokeExpr) {
                this.processSingleInvocationWithInvokeWxpr(node2, (InvokeExpr)Rop);
            } else if (Rop instanceof NewExpr) {
                this.processSingleInvocationWithConstructorInvoke(node2, (NewExpr)Rop);
            } else {
                PsiCFGDebugUtil.LOG.warning("Invocation neither an InvokeExpr nor NewExpr: " + Rop.getSimpleName());
            }
        }
    }

    public PsiCFGMethod retrieveParentMethod(GraphNode node2) {
        Graph parentGraph;
        for (parentGraph = node2.getParentGraph(); parentGraph != null && !(parentGraph instanceof MethodGraph); parentGraph = parentGraph.getParentGraph()) {
        }
        if (parentGraph != null) {
            MethodGraph methodGraph = (MethodGraph)parentGraph;
            return methodGraph.getPsiCFGMethod();
        }
        return null;
    }

    public void addToCallGraph(GraphNode callerNode, PsiCFGMethod calleeMethod) {
        this.mCallGraphInstance.callerNodeToMethodsMap.put((Object)callerNode, (Object)calleeMethod);
        this.mCallGraphInstance.calleeMethodToCallerGraphNodeMap.put((Object)calleeMethod, (Object)callerNode);
        PsiCFGMethod callerMethod = this.retrieveParentMethod(callerNode);
        if (callerMethod != null) {
            this.mCallGraphInstance.callerMethodToCalleeMethodMap.put((Object)callerMethod, (Object)calleeMethod);
            this.mCallGraphInstance.calleeMethodToCallerMethodReturnMap.put((Object)calleeMethod, (Object)callerMethod);
            this.mCallGraphInstance.allMethodsInGraph.add(callerMethod);
            this.mCallGraphInstance.allMethodsInGraph.add(calleeMethod);
        }
        if (calleeMethod.getControlFlowGraph() != null) {
            GraphNode entryNode = calleeMethod.getControlFlowGraph().getEntryNode();
            GraphNode exitNode = calleeMethod.getControlFlowGraph().getExitNode();
            this.mCallGraphInstance.callerNodeToCalleeNodeMap.put((Object)callerNode, (Object)entryNode);
            this.mCallGraphInstance.calleeNodeToCallerNodeMap.put((Object)exitNode, (Object)callerNode);
        }
    }

    public void performCHAForInvocationSite(GraphNode node2, PsiType receiverType, PsiCFGMethod targetMethod) {
        if (!(receiverType instanceof PsiClassType)) {
            PsiCFGDebugUtil.LOG.warning("The Receiver's type is not PsiClassType " + receiverType.getCanonicalText() + "  " + targetMethod.getName());
        } else {
            PsiClassType receiverClassType = (PsiClassType)receiverType;
            PsiClass psiClassRef = receiverClassType.resolve();
            PsiCFGClass receiverClass = this.mScene.getPsiCFGClass(psiClassRef);
            if (receiverClass == null) {
                PsiCFGDebugUtil.LOG.warning("The Receiver's CFGClass is not resolved during the CFG construction " + psiClassRef.getQualifiedName());
                return;
            }
            PsiCFGPartialMethodSignature methodSignature = targetMethod.getSignature();
            PsiCFGMethod nearestConcreteMethodFromTop = this.getNearestConcreteMethod(receiverClass, methodSignature);
            if (nearestConcreteMethodFromTop != null) {
                this.addToCallGraph(node2, nearestConcreteMethodFromTop);
            }
            ArrayList<PsiCFGMethod> methodList = new ArrayList<PsiCFGMethod>();
            this.recursivelyQueryConcreteMethodFromChildrenWithCache(methodList, receiverClass, methodSignature);
            for (PsiCFGMethod concreteMethodFromSubClass : methodList) {
                this.addToCallGraph(node2, concreteMethodFromSubClass);
            }
        }
    }

    public void recursivelyQueryConcreteMethodFromChildrenWithCache(ArrayList<PsiCFGMethod> methodList, PsiCFGClass receiverClass, PsiCFGPartialMethodSignature signature) {
        Pair keyPair = new Pair((Object)receiverClass, (Object)signature);
        if (this.mMethodOrderTreeMap.containsKey(keyPair)) {
            methodList.addAll((Collection<PsiCFGMethod>)this.mMethodOrderTreeMap.get(keyPair));
        } else {
            this.recursivelyQueryConcreteMethodFromChildrenWithOutCache(methodList, receiverClass, signature);
            this.mMethodOrderTreeMap.put((Pair<PsiCFGClass, PsiCFGPartialMethodSignature>)keyPair, Sets.newHashSet(methodList));
        }
    }

    public void recursivelyQueryConcreteMethodFromChildrenWithOutCache(ArrayList<PsiCFGMethod> methodList, PsiCFGClass receiverClass, PsiCFGPartialMethodSignature signature) {
        Pair keyPair = new Pair((Object)receiverClass, (Object)signature);
        PsiCFGMethod method2 = receiverClass.getMethod(signature);
        if (method2 != null && !method2.isAbstract()) {
            methodList.add(method2);
        }
        for (PsiCFGClass subClass : receiverClass.getSubClassSet()) {
            if (this.mMethodOrderTreeMap.containsKey(keyPair)) {
                methodList.addAll((Collection<PsiCFGMethod>)this.mMethodOrderTreeMap.get(keyPair));
                continue;
            }
            this.recursivelyQueryConcreteMethodFromChildrenWithOutCache(methodList, subClass, signature);
        }
    }

    public void addInvokeExprWithThisRef(GraphNode node2, PsiType thisBaseType, PsiCFGMethod method2) {
        if (!method2.isAbstract()) {
            this.addToCallGraph(node2, method2);
        } else {
            PsiClassType classType = null;
            PsiCFGClass cfgClass = null;
            if (!(thisBaseType instanceof PsiClassType)) {
                PsiCFGDebugUtil.LOG.warning("PsiType of ThisRef is not a PsiClassType :" + thisBaseType.getClass().getSimpleName());
                return;
            }
            classType = (PsiClassType)thisBaseType;
            cfgClass = this.mScene.getPsiCFGClass(classType.resolve());
            if (cfgClass == null) {
                PsiCFGDebugUtil.LOG.warning("PsiType of ThisRef cannot be resolved to cfgClass :" + thisBaseType.getClass().getSimpleName());
            }
            ArrayList<PsiCFGMethod> methodsList = new ArrayList<PsiCFGMethod>();
            this.recursivelyQueryConcreteMethodFromChildrenWithCache(methodsList, cfgClass, method2.getSignature());
        }
    }

    public PsiCFGMethod getNearestConcreteMethod(PsiCFGClass receiverClass, PsiCFGPartialMethodSignature signature) {
        while (receiverClass != null && !receiverClass.equals(this.JAVA_LANG_OBJECT)) {
            PsiCFGMethod methodInCurClass = receiverClass.getMethod(signature);
            if (methodInCurClass != null && !methodInCurClass.isAbstract()) {
                return methodInCurClass;
            }
            receiverClass = receiverClass.getSuperClass();
        }
        return null;
    }

    public void processSingleInvocationWithInvokeWxpr(GraphNode node2, InvokeExpr invokeExpr) {
        if (invokeExpr instanceof StaticInvokeExpr) {
            this.addToCallGraph(node2, invokeExpr.getMethod());
        } else if (invokeExpr instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr;
            Value base = instanceInvokeExpr.getBase();
            PsiType baseType = base.getType();
            PsiCFGMethod targetMethod = invokeExpr.getMethod();
            if (baseType == null) {
                PsiCFGDebugUtil.LOG.warning("Receiver Type is null at " + invokeExpr.getSimpleName());
                return;
            }
            if (base instanceof ThisRef) {
                this.addInvokeExprWithThisRef(node2, baseType, targetMethod);
            } else {
                this.performCHAForInvocationSite(node2, baseType, targetMethod);
            }
        }
    }

    public void processSingleInvocationWithConstructorInvoke(GraphNode node2, NewExpr newExpr) {
        PsiCFGMethod constructorMethod = newExpr.getConstructorInvocation();
        if (constructorMethod != null) {
            this.addToCallGraph(node2, constructorMethod);
        } else {
            PsiCFGDebugUtil.LOG.warning("Constructor in New Expr is null: " + newExpr.getSimpleName());
        }
    }

    public Callgraph getCallGraph() {
        return this.mCallGraphInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "scene";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "analysisUtil";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/experimental/codeanalysis/callgraph/CallgraphBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

