/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis;

import com.android.tools.idea.experimental.codeanalysis.callgraph.Callgraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGMethod;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.BlockGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.android.tools.idea.experimental.codeanalysis.utils.CFGUtil;
import com.android.tools.idea.experimental.codeanalysis.utils.PsiCFGAnalysisUtil;
import com.android.tools.idea.experimental.codeanalysis.utils.PsiCFGDebugUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class PsiCFGScene {
    private static ConcurrentMap<Project, PsiCFGScene> instanceMap = Maps.newConcurrentMap();
    private Map<String, PsiCFGClass> mAppClassNamePsiMap = Maps.newHashMap();
    private Map<String, PsiCFGClass> mLibraryClassNamePsiMap = Maps.newHashMap();
    private Map<PsiClass, PsiCFGClass> mAppPsiClassPsiCFGClassMap;
    private Map<PsiClass, PsiCFGClass> mLibraryPsiClassPsiCFGClassMap;
    private Map<PsiLambdaExpression, PsiCFGClass> mLambdaPsiCFGClassMap;
    private Project mProject;
    protected ArrayList<GraphNode> mInvocationNodes;
    public PsiCFGAnalysisUtil analysisUtil;
    protected Callgraph mCallGraph;
    public Deque<PsiCFGClass> workingList;

    @NotNull
    public Project getProject() {
        Project project = this.mProject;
        if (project == null) {
            PsiCFGScene.$$$reportNull$$$0(0);
        }
        return project;
    }

    private PsiCFGScene(Project proj) {
        this.mProject = proj;
        this.analysisUtil = new PsiCFGAnalysisUtil(this);
        this.mAppPsiClassPsiCFGClassMap = Maps.newHashMap();
        this.mLibraryPsiClassPsiCFGClassMap = Maps.newHashMap();
        this.mLambdaPsiCFGClassMap = Maps.newHashMap();
        this.mInvocationNodes = new ArrayList();
        this.workingList = Queues.newArrayDeque();
    }

    public void setCallGraph(Callgraph callGraph) {
        this.mCallGraph = callGraph;
    }

    public Callgraph getCallGraph() {
        return this.mCallGraph;
    }

    public void addInvocationNode(GraphNode node2) {
        this.mInvocationNodes.add(node2);
    }

    public GraphNode[] getAllInvocationNode() {
        return this.mInvocationNodes.toArray(GraphNode.EMPTY_ARRAY);
    }

    public static PsiCFGScene getInstance(Project proj) {
        if (instanceMap.containsKey(proj)) {
            return (PsiCFGScene)instanceMap.get(proj);
        }
        PsiCFGScene instance = new PsiCFGScene(proj);
        instanceMap.put(proj, instance);
        return instance;
    }

    public static PsiCFGScene createFreshInstance(Project proj) {
        if (instanceMap.containsKey(proj)) {
            instanceMap.remove(proj);
        }
        PsiCFGScene instance = new PsiCFGScene(proj);
        instanceMap.put(proj, instance);
        return instance;
    }

    public PsiClass[] getAllApplicationPsiClasses() {
        PsiClass[] retArray = new PsiClass[this.mAppClassNamePsiMap.size()];
        int i2 = 0;
        for (String className2 : this.mAppClassNamePsiMap.keySet()) {
            PsiCFGClass clazzBase = this.mAppClassNamePsiMap.get(className2);
            retArray[i2] = clazzBase.getPsiClass();
            ++i2;
        }
        return retArray;
    }

    public PsiCFGClass[] getAllApplicationClasses() {
        PsiCFGClass[] retArray = new PsiCFGClass[this.mAppClassNamePsiMap.size()];
        int i2 = 0;
        for (String className2 : this.mAppClassNamePsiMap.keySet()) {
            PsiCFGClass clazzBase = this.mAppClassNamePsiMap.get(className2);
            retArray[i2++] = clazzBase;
        }
        return retArray;
    }

    public Set<PsiClass> getAllLibraryClassPsiSet() {
        return Sets.newHashSet(this.mLibraryPsiClassPsiCFGClassMap.keySet());
    }

    public PsiCFGClass[] getAllLibraryClasses() {
        PsiCFGClass[] retArray = new PsiCFGClass[this.mLibraryClassNamePsiMap.size()];
        int i2 = 0;
        for (String className2 : this.mLibraryClassNamePsiMap.keySet()) {
            PsiCFGClass clazzBase = this.mLibraryClassNamePsiMap.get(className2);
            retArray[i2++] = clazzBase;
        }
        return retArray;
    }

    public PsiCFGClass[] getAllLambdaClass() {
        PsiCFGClass[] retArray = new PsiCFGClass[this.mLambdaPsiCFGClassMap.size()];
        int i2 = 0;
        for (PsiLambdaExpression lbdExpr : this.mLambdaPsiCFGClassMap.keySet()) {
            PsiCFGClass mLbdClass = this.mLambdaPsiCFGClassMap.get(lbdExpr);
            retArray[i2++] = mLbdClass;
        }
        return retArray;
    }

    public PsiCFGClass getPsiCFGClass(String name) {
        if (this.mAppClassNamePsiMap.containsKey(name)) {
            return this.mAppClassNamePsiMap.get(name);
        }
        if (this.mLibraryClassNamePsiMap.containsKey(name)) {
            return this.mLibraryClassNamePsiMap.get(name);
        }
        return null;
    }

    public PsiCFGClass getPsiCFGClass(PsiClass psiClazz) {
        if (this.mAppPsiClassPsiCFGClassMap.containsKey(psiClazz)) {
            return this.mAppPsiClassPsiCFGClassMap.get(psiClazz);
        }
        if (this.mLibraryPsiClassPsiCFGClassMap.containsKey(psiClazz)) {
            return this.mLibraryPsiClassPsiCFGClassMap.get(psiClazz);
        }
        return null;
    }

    public PsiCFGClass getOrCreateCFGClass(PsiClass psiClazz) {
        PsiCFGClass retClass = this.getPsiCFGClass(psiClazz);
        if (retClass == null) {
            retClass = this.createAndParsePsiCFGClassOnTheFly(psiClazz);
        }
        return retClass;
    }

    public PsiCFGClass createPsiCFGClass(PsiClass psiClass, PsiFile declaringFile, boolean bAppClass) {
        String fullClassName = psiClass.getQualifiedName();
        if (fullClassName == null) {
            PsiCFGDebugUtil.LOG.warning("The class has no name: ");
            PsiCFGDebugUtil.debugOutputPsiElement((PsiElement)psiClass);
            throw new RuntimeException(String.format("Class %s does not have a full name", psiClass.getText()));
        }
        if (!psiClass.isInterface()) {
            PsiCFGClass newClass = new PsiCFGClass(psiClass, declaringFile);
            if (bAppClass) {
                this.mAppClassNamePsiMap.put(fullClassName, newClass);
                this.mAppPsiClassPsiCFGClassMap.put(psiClass, newClass);
            } else {
                this.mLibraryClassNamePsiMap.put(fullClassName, newClass);
                this.mLibraryPsiClassPsiCFGClassMap.put(psiClass, newClass);
                newClass.setLibraryClass();
            }
            return newClass;
        }
        PsiCFGClass newInterface = new PsiCFGClass(psiClass, declaringFile);
        newInterface.setIsInterface(true);
        if (bAppClass) {
            this.mAppClassNamePsiMap.put(fullClassName, newInterface);
            this.mAppPsiClassPsiCFGClassMap.put(psiClass, newInterface);
        } else {
            this.mLibraryClassNamePsiMap.put(fullClassName, newInterface);
            this.mLibraryPsiClassPsiCFGClassMap.put(psiClass, newInterface);
            newInterface.setLibraryClass();
        }
        return newInterface;
    }

    public PsiCFGClass createAndParsePsiCFGClassOnTheFly(PsiClass psiClass) {
        if (this.mAppPsiClassPsiCFGClassMap.containsKey(psiClass)) {
            PsiCFGDebugUtil.LOG.warning("A user class is passed into createAndParsePsiCFGClassOnTheFly\nClassName: " + psiClass.getQualifiedName());
            return this.mAppPsiClassPsiCFGClassMap.get(psiClass);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            return null;
        }
        PsiCFGClass retClass = this.createLibraryCFGClassesWInnerClasses(psiClass);
        return retClass;
    }

    public PsiCFGClass createLibraryCFGClassesWInnerClasses(PsiClass clazz) {
        ArrayList<PsiClass> classList = new ArrayList<PsiClass>();
        this.retriveClassAndInnerClass(classList, clazz);
        classList.remove(clazz);
        PsiCFGClass retVal = this.createPsiCFGClass(clazz, null, false);
        this.analysisUtil.parseFields(retVal);
        this.analysisUtil.parseMethods(retVal);
        for (PsiClass curClassRef : classList) {
            PsiCFGClass curCFGClass = this.createPsiCFGClass(curClassRef, null, false);
            this.analysisUtil.parseFields(curCFGClass);
            this.analysisUtil.parseMethods(curCFGClass);
        }
        retVal.setLibraryClass();
        return retVal;
    }

    private void retriveClassAndInnerClass(@NotNull ArrayList<PsiClass> retList, @NotNull PsiClass psiClass) {
        PsiClass[] innerClasses;
        if (retList == null) {
            PsiCFGScene.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            PsiCFGScene.$$$reportNull$$$0(2);
        }
        if ((innerClasses = psiClass.getInnerClasses()).length == 0) {
            return;
        }
        for (PsiClass innerClazz : innerClasses) {
            this.retriveClassAndInnerClass(retList, innerClazz);
        }
        retList.add(psiClass);
    }

    public PsiCFGClass getOrCreateNestedClass(PsiClass nestedClass, PsiCFGClass parentCFGClass, PsiCFGMethod declaringMethod, BlockGraph declaringBlock) {
        String className2;
        PsiCFGClass currentNestedCFGClass = new PsiCFGClass(nestedClass, parentCFGClass.getDeclearingFile());
        currentNestedCFGClass.setNested();
        currentNestedCFGClass.setDeclaringCFGMethod(declaringMethod);
        currentNestedCFGClass.setDeclaringBlock(declaringBlock);
        if (nestedClass instanceof PsiAnonymousClass) {
            currentNestedCFGClass.setAnonlymous();
        }
        if ((className2 = nestedClass.getName()) == null) {
            className2 = "";
        }
        parentCFGClass.addNestedInnerClass(currentNestedCFGClass, className2);
        this.workingList.addLast(currentNestedCFGClass);
        this.mAppPsiClassPsiCFGClassMap.put(nestedClass, currentNestedCFGClass);
        this.mAppClassNamePsiMap.put(currentNestedCFGClass.getQualifiedClassName(), currentNestedCFGClass);
        this.analysisUtil.parseFields(currentNestedCFGClass);
        this.analysisUtil.parseMethods(currentNestedCFGClass);
        return currentNestedCFGClass;
    }

    public PsiCFGClass createLambdaAnonymousClass(PsiLambdaExpression lambdaExpress, PsiClass parentInterface, PsiCFGClass declearingClass) {
        PsiCFGClass parentInterfaceCFGClass = this.getOrCreateCFGClass(parentInterface);
        PsiMethod overridedMethod = this.extractLambdaMethod(parentInterface);
        PsiCFGClass wrapperClass = new PsiCFGClass(null, declearingClass.getDeclearingFile());
        wrapperClass.setAnonlymous();
        wrapperClass.setLambdaRef(lambdaExpress);
        declearingClass.addLambda(wrapperClass);
        wrapperClass.setDirectOverride(parentInterfaceCFGClass);
        PsiCFGMethod wrapperMethod = new PsiCFGMethod(lambdaExpress, overridedMethod, wrapperClass);
        wrapperClass.addMethod(wrapperMethod);
        this.mLambdaPsiCFGClassMap.put(lambdaExpress, wrapperClass);
        CFGUtil.constructMethodGraphForLambda(this, wrapperMethod);
        return wrapperClass;
    }

    public PsiMethod extractLambdaMethod(PsiClass parentInterface) {
        PsiMethod[] allMethods = parentInterface.getAllMethods();
        PsiMethod retMethod = null;
        for (PsiMethod m : allMethods) {
            if (m.getContainingClass().getQualifiedName().equals("java.lang.Object")) continue;
            if (retMethod == null) {
                retMethod = m;
                continue;
            }
            PsiCFGDebugUtil.LOG.warning("More than 1 method in the lambda's parent Interface");
            PsiCFGDebugUtil.LOG.warning("Type: " + parentInterface.getQualifiedName());
        }
        return retMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/experimental/codeanalysis/PsiCFGScene";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/experimental/codeanalysis/PsiCFGScene";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "retriveClassAndInnerClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

