/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.actions;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;

public class PermissionUsageQuickFixRunnable
implements Runnable {
    private Project project;
    private Editor editor;
    private static final String TEXT_BEFORE = "if (android.support.v4.content.PermissionChecker.checkSelfPermission(this, android.Manifest.permission.ACCESS_FINE_LOCATION) == PermissionChecker.PERMISSION_GRANTED) {";
    private static final String TEXT_AFTER = "}";

    PermissionUsageQuickFixRunnable(Project project, Editor editor2) {
        this.project = project;
        this.editor = editor2;
    }

    @Override
    public void run() {
        Document document = this.editor.getDocument();
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(document);
        assert (psiFile2 != null);
        SelectionModel selectionModel = this.editor.getSelectionModel();
        PermissionUsageQuickFixRunnable.setLineSelection(document, selectionModel);
        selectionModel = this.editor.getSelectionModel();
        document.insertString(selectionModel.getSelectionEnd(), (CharSequence)TEXT_AFTER);
        document.insertString(selectionModel.getSelectionStart(), (CharSequence)TEXT_BEFORE);
        PsiDocumentManager.getInstance((Project)this.project).commitDocument(document);
        CodeStyleManager.getInstance((Project)this.project).reformat(psiFile2.getNavigationElement());
        JavaCodeStyleManager.getInstance((Project)this.project).shortenClassReferences(psiFile2.getNavigationElement());
        selectionModel.removeSelection(true);
    }

    public static void setLineSelection(Document document, SelectionModel selectionModel) {
        int startLineNumber = document.getLineNumber(selectionModel.getSelectionStart());
        int endLineNumber = document.getLineNumber(selectionModel.getSelectionEnd());
        int lineStartOffset = document.getLineStartOffset(startLineNumber);
        int lineEndOffset = document.getLineEndOffset(endLineNumber);
        selectionModel.setSelection(lineStartOffset, lineEndOffset);
    }
}

